/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.test;

import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.commons.io.IOUtils;
import org.eclipse.smarthome.core.service.ReadyMarker;
import org.eclipse.smarthome.core.service.ReadyService;
import org.junit.Assert;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public class SyntheticBundleInstaller {
    private static final int WAIT_TIMOUT = 30;
    private static final String bundlePoolPath = "/test-bundle-pool";
    private static final String XML_THING_TYPE = "esh.xmlThingTypes";
    private static final String XML_BINDING_INFO = "esh.xmlBindingInfo";
    private static final String XML_CONFIG = "esh.xmlConfig";
    private static Set<String> DEFAULT_EXTENSIONS = ImmutableSet.of((Object)"*.xml", (Object)"*.properties", (Object)"*.json", (Object)".keep");

    public static Bundle install(BundleContext bundleContext, String testBundleName) throws Exception {
        return SyntheticBundleInstaller.install(bundleContext, testBundleName, DEFAULT_EXTENSIONS);
    }

    public static Bundle install(BundleContext bundleContext, String testBundleName, Set<String> extensionsToInclude) throws Exception {
        String bundlePath = "/test-bundle-pool/" + testBundleName + "/";
        byte[] syntheticBundleBytes = SyntheticBundleInstaller.createSyntheticBundle(bundleContext.getBundle(), bundlePath, testBundleName, extensionsToInclude);
        Bundle syntheticBundle = bundleContext.installBundle(testBundleName, (InputStream)new ByteArrayInputStream(syntheticBundleBytes));
        syntheticBundle.start(32);
        SyntheticBundleInstaller.waitUntilLoadingFinished(bundleContext, syntheticBundle);
        return syntheticBundle;
    }

    public static Bundle install(BundleContext bundleContext, String testBundleName, String ... extensionsToInclude) throws Exception {
        HashSet<String> extensionsSet = new HashSet<String>(Arrays.asList(extensionsToInclude));
        return SyntheticBundleInstaller.install(bundleContext, testBundleName, extensionsSet);
    }

    public static Bundle update(BundleContext bundleContext, String bundleToUpdateName, String updateDirName) throws Exception {
        return SyntheticBundleInstaller.update(bundleContext, bundleToUpdateName, updateDirName, DEFAULT_EXTENSIONS);
    }

    public static Bundle update(BundleContext bundleContext, String bundleToUpdateName, String updateDirName, Set<String> extensionsToInclude) throws Exception {
        Bundle[] bundles;
        Bundle[] bundleArray = bundles = bundleContext.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (bundleToUpdateName.equals(bundle.getSymbolicName())) {
                bundle.uninstall();
                break;
            }
            ++n2;
        }
        String updatePath = "/test-bundle-pool/" + updateDirName + "/";
        byte[] updatedBundleBytes = SyntheticBundleInstaller.createSyntheticBundle(bundleContext.getBundle(), updatePath, bundleToUpdateName, extensionsToInclude);
        Bundle syntheticBundle = bundleContext.installBundle(bundleToUpdateName, (InputStream)new ByteArrayInputStream(updatedBundleBytes));
        syntheticBundle.start(32);
        SyntheticBundleInstaller.waitUntilLoadingFinished(bundleContext, syntheticBundle);
        return syntheticBundle;
    }

    public static Bundle update(BundleContext bundleContext, String bundleToUpdateName, String updateDirName, String ... extensionsToInclude) throws Exception {
        HashSet<String> extensionsSet = new HashSet<String>(Arrays.asList(extensionsToInclude));
        return SyntheticBundleInstaller.update(bundleContext, bundleToUpdateName, updateDirName, extensionsSet);
    }

    public static Bundle installFragment(BundleContext bundleContext, String testBundleName) throws Exception {
        return SyntheticBundleInstaller.installFragment(bundleContext, testBundleName, DEFAULT_EXTENSIONS);
    }

    public static Bundle installFragment(BundleContext bundleContext, String testBundleName, Set<String> extensionsToInclude) throws Exception {
        String bundlePath = "/test-bundle-pool/" + testBundleName + "/";
        byte[] syntheticBundleBytes = SyntheticBundleInstaller.createSyntheticBundle(bundleContext.getBundle(), bundlePath, testBundleName, extensionsToInclude);
        Bundle syntheticBundle = bundleContext.installBundle(testBundleName, (InputStream)new ByteArrayInputStream(syntheticBundleBytes));
        return syntheticBundle;
    }

    private static boolean isBundleAvailable(BundleContext context, String bsn) {
        Bundle[] bundleArray = context.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (bundle.getSymbolicName().equals(bsn) && bundle.getState() == 32) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isXmlThingTypeBundleAvailable(BundleContext context) {
        return SyntheticBundleInstaller.isBundleAvailable(context, "org.eclipse.smarthome.core.thing.xml");
    }

    private static boolean isXmlBindingInfoBundleAvailable(BundleContext context) {
        return SyntheticBundleInstaller.isBundleAvailable(context, "org.eclipse.smarthome.core.binding.xml");
    }

    private static boolean isXmlConfigBundleAvailable(BundleContext context) {
        return SyntheticBundleInstaller.isBundleAvailable(context, "org.eclipse.smarthome.config.xml");
    }

    public static void waitUntilLoadingFinished(BundleContext context, Bundle bundle) {
        if (SyntheticBundleInstaller.isXmlThingTypeBundleAvailable(context)) {
            SyntheticBundleInstaller.waitForReadyMarker(context, XML_THING_TYPE, bundle);
        }
        if (SyntheticBundleInstaller.isXmlBindingInfoBundleAvailable(context)) {
            SyntheticBundleInstaller.waitForReadyMarker(context, XML_BINDING_INFO, bundle);
        }
        if (SyntheticBundleInstaller.isXmlConfigBundleAvailable(context)) {
            SyntheticBundleInstaller.waitForReadyMarker(context, XML_CONFIG, bundle);
        }
    }

    private static void waitForReadyMarker(BundleContext context, String marker, Bundle bundle) {
        if (bundle.getHeaders().get("Fragment-Host") != null) {
            return;
        }
        long startTime = System.nanoTime();
        ServiceReference readyServiceRef = context.getServiceReference(ReadyService.class.getName());
        ReadyService readyService = (ReadyService)context.getService(readyServiceRef);
        ReadyMarker expected = new ReadyMarker(marker, bundle.getSymbolicName());
        while (!readyService.isReady(expected)) {
            if (System.nanoTime() - startTime > TimeUnit.SECONDS.toNanos(30L)) {
                Assert.fail((String)MessageFormat.format("Timout waiting for marker {0} at bundle {1}", marker, bundle.getSymbolicName()));
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        context.ungetService(readyServiceRef);
    }

    public static void uninstall(BundleContext bundleContext, String testBundleName) throws BundleException {
        Bundle[] bundles;
        Bundle[] bundleArray = bundles = bundleContext.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (testBundleName.equals(bundle.getSymbolicName())) {
                bundle.uninstall();
            }
            ++n2;
        }
    }

    private static byte[] createSyntheticBundle(Bundle bundle, String bundlePath, String bundleName, Set<String> extensionsToInclude) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Manifest manifest = SyntheticBundleInstaller.getManifest(bundle, bundlePath);
        JarOutputStream jarOutputStream = manifest != null ? new JarOutputStream((OutputStream)outputStream, manifest) : new JarOutputStream(outputStream);
        List<String> files = SyntheticBundleInstaller.collectFilesFrom(bundle, bundlePath, bundleName, extensionsToInclude);
        for (String file : files) {
            SyntheticBundleInstaller.addFileToArchive(bundle, bundlePath, file, jarOutputStream);
        }
        jarOutputStream.close();
        return outputStream.toByteArray();
    }

    private static void addFileToArchive(Bundle bundle, String bundlePath, String fileInBundle, JarOutputStream jarOutputStream) throws IOException {
        String filePath = String.valueOf(bundlePath) + "/" + fileInBundle;
        URL resource = bundle.getResource(filePath);
        if (resource == null) {
            return;
        }
        ZipEntry zipEntry = new ZipEntry(fileInBundle);
        jarOutputStream.putNextEntry(zipEntry);
        IOUtils.copy((InputStream)resource.openStream(), (OutputStream)jarOutputStream);
        jarOutputStream.closeEntry();
    }

    private static List<String> collectFilesFrom(Bundle bundle, String bundlePath, String bundleName, Set<String> extensionsToInclude) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        URL url = SyntheticBundleInstaller.getBaseURL(bundle, bundleName);
        if (url != null) {
            String path = url.getPath();
            URI baseURI = url.toURI();
            List<URL> list = SyntheticBundleInstaller.collectEntries(bundle, path, extensionsToInclude);
            for (URL entryURL : list) {
                String fileEntry = SyntheticBundleInstaller.convertToFileEntry(baseURI, entryURL);
                result.add(fileEntry);
            }
        }
        return result;
    }

    private static URL getBaseURL(Bundle bundle, String bundleName) {
        Enumeration entries = bundle.findEntries("/", bundleName, true);
        return entries != null ? (URL)entries.nextElement() : null;
    }

    private static List<URL> collectEntries(Bundle bundle, String path, Set<String> extensionsToInclude) {
        ArrayList<URL> result = new ArrayList<URL>();
        for (String filePattern : extensionsToInclude) {
            Enumeration entries = bundle.findEntries(path, filePattern, true);
            if (entries == null) continue;
            result.addAll(Collections.list(entries));
        }
        return result;
    }

    private static String convertToFileEntry(URI baseURI, URL entryURL) throws URISyntaxException {
        URI entryURI = entryURL.toURI();
        URI relativeURI = baseURI.relativize(entryURI);
        String fileEntry = relativeURI.toString();
        return fileEntry;
    }

    private static Manifest getManifest(Bundle bundle, String bundlePath) throws IOException {
        String filePath = String.valueOf(bundlePath) + "/" + "META-INF/MANIFEST.MF";
        URL resource = bundle.getResource(filePath);
        if (resource == null) {
            return null;
        }
        return new Manifest(resource.openStream());
    }
}

