/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.test.java;

import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;

public class JavaTest {
    protected static final int DFL_TIMEOUT = 10000;
    protected static final int DFL_SLEEP_TIME = 50;

    protected boolean waitFor(BooleanSupplier condition) {
        return this.waitFor(condition, 10000, 50);
    }

    protected boolean waitFor(BooleanSupplier condition, int timeout, int sleepTime) {
        boolean rv;
        int waitingTime = 0;
        while (!(rv = condition.getAsBoolean()) && waitingTime < timeout) {
            waitingTime += sleepTime;
            this.internalSleep(sleepTime);
        }
        return rv;
    }

    protected void waitForAssert(Runnable assertion) {
        this.waitForAssert(assertion, null, 10000, 50);
    }

    protected void waitForAssert(Runnable assertion, int timeout, int sleepTime) {
        this.waitForAssert(assertion, null, timeout, sleepTime);
    }

    protected <T> T waitForAssert(Supplier<T> assertion) {
        return this.waitForAssert(assertion, null, 10000L, 50);
    }

    protected <T> T waitForAssert(Supplier<T> assertion, int timeout, int sleepTime) {
        return this.waitForAssert(assertion, null, (long)timeout, sleepTime);
    }

    protected void waitForAssert(Runnable assertion, Runnable beforeLastCall, int timeout, int sleepTime) {
        this.waitForAssert(assertion, beforeLastCall, null, timeout, sleepTime);
    }

    protected void waitForAssert(Runnable assertion, Runnable beforeLastCall, Runnable afterLastCall, int timeout, int sleepTime) {
        int waitingTime = 0;
        while (waitingTime < timeout) {
            try {
                assertion.run();
                if (afterLastCall != null) {
                    afterLastCall.run();
                }
                return;
            }
            catch (Error | NullPointerException throwable) {
                waitingTime += sleepTime;
                this.internalSleep(sleepTime);
            }
        }
        if (beforeLastCall != null) {
            beforeLastCall.run();
        }
        try {
            assertion.run();
        }
        finally {
            if (afterLastCall != null) {
                afterLastCall.run();
            }
        }
    }

    private <T> T waitForAssert(Supplier<T> assertion, Runnable beforeLastCall, long timeout, int sleepTime) {
        long timeoutNs = TimeUnit.MILLISECONDS.toNanos(timeout);
        long startingTime = System.nanoTime();
        while (System.nanoTime() - startingTime < timeoutNs) {
            try {
                return assertion.get();
            }
            catch (Error | NullPointerException throwable) {
                this.internalSleep(sleepTime);
            }
        }
        if (beforeLastCall != null) {
            beforeLastCall.run();
        }
        return assertion.get();
    }

    private void internalSleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            throw new Error("We shouldn't be interrupted while testing");
        }
    }
}

