/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation;

import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.Visibility;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.core.common.registry.Identifiable;

@NonNullByDefault
public interface Rule
extends Identifiable<String> {
    public String getUID();

    public @Nullable String getTemplateUID();

    public @Nullable String getName();

    public Set<String> getTags();

    public @Nullable String getDescription();

    public Visibility getVisibility();

    public Configuration getConfiguration();

    public List<ConfigDescriptionParameter> getConfigurationDescriptions();

    public List<Condition> getConditions();

    public List<Action> getActions();

    public List<Trigger> getTriggers();

    public List<Module> getModules();

    default public @Nullable Module getModule(String moduleId) {
        for (Module module : this.getModules()) {
            if (!module.getId().equals(moduleId)) continue;
            return module;
        }
        return null;
    }
}

