/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.core.provider;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.annotation.ActionInput;
import org.eclipse.smarthome.automation.annotation.ActionOutput;
import org.eclipse.smarthome.automation.annotation.ActionOutputs;
import org.eclipse.smarthome.automation.annotation.ActionScope;
import org.eclipse.smarthome.automation.annotation.RuleAction;
import org.eclipse.smarthome.automation.module.core.provider.ActionModuleKind;
import org.eclipse.smarthome.automation.module.core.provider.ModuleInformation;
import org.eclipse.smarthome.automation.type.ActionType;
import org.eclipse.smarthome.automation.type.Input;
import org.eclipse.smarthome.automation.type.Output;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameterBuilder;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.config.core.ParameterOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationActionModuleTypeHelper {
    private final Logger logger = LoggerFactory.getLogger(AnnotationActionModuleTypeHelper.class);
    private static final String SELECT_SERVICE_LABEL = "Select Service Instance";
    private static final String SELECT_THING_LABEL = "Select Thing";
    public static final String CONFIG_PARAM = "config";

    public Collection<ModuleInformation> parseAnnotations(Object actionProvider) {
        Class<?> clazz = actionProvider.getClass();
        if (clazz.isAnnotationPresent(ActionScope.class)) {
            ActionScope scope = clazz.getAnnotation(ActionScope.class);
            return this.parseAnnotations(scope.name(), actionProvider);
        }
        return Collections.emptyList();
    }

    public Collection<ModuleInformation> parseAnnotations(String name, Object actionProvider) {
        Method[] methods;
        ArrayList<ModuleInformation> moduleInformation = new ArrayList<ModuleInformation>();
        Class<?> clazz = actionProvider.getClass();
        Method[] methodArray = methods = clazz.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(RuleAction.class)) {
                List<Input> inputs = this.getInputsFromAction(method);
                List<Output> outputs = this.getOutputsFromMethod(method);
                RuleAction ruleAction = method.getAnnotation(RuleAction.class);
                String uid = String.valueOf(name) + "." + method.getName();
                HashSet<String> tags = new HashSet<String>(Arrays.asList(ruleAction.tags()));
                ModuleInformation mi = new ModuleInformation(uid, actionProvider, method);
                mi.setLabel(ruleAction.label());
                mi.setDescription(ruleAction.description());
                mi.setVisibility(ruleAction.visibility());
                mi.setInputs(inputs);
                mi.setOutputs(outputs);
                mi.setTags(tags);
                moduleInformation.add(mi);
            }
            ++n2;
        }
        return moduleInformation;
    }

    private List<Input> getInputsFromAction(Method method) {
        ArrayList<Input> inputs = new ArrayList<Input>();
        Annotation[][] annotations = method.getParameterAnnotations();
        Parameter[] params = method.getParameters();
        int i = 0;
        while (i < annotations.length) {
            Annotation a;
            Parameter param = params[i];
            Annotation[] paramAnnotations = annotations[i];
            Input input = null;
            if (paramAnnotations.length == 0) {
                input = new Input("p" + i, param.getType().getCanonicalName(), "", "", Collections.emptySet(), false, "", "");
            } else if (paramAnnotations.length == 1 && (a = paramAnnotations[0]) instanceof ActionInput) {
                ActionInput inp = (ActionInput)a;
                String type = !"".equals(inp.type()) ? inp.type() : param.getType().getCanonicalName();
                input = new Input(inp.name(), type, inp.label(), inp.description(), Arrays.stream(inp.tags()).collect(Collectors.toSet()), inp.required(), inp.reference(), inp.defaultValue());
            }
            inputs.add(input);
            ++i;
        }
        return inputs;
    }

    private List<Output> getOutputsFromMethod(Method method) {
        ArrayList<Output> outputs = new ArrayList<Output>();
        if (method.isAnnotationPresent(ActionOutputs.class)) {
            ActionOutput[] actionOutputArray = (ActionOutput[])method.getAnnotationsByType(ActionOutput.class);
            int n = actionOutputArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActionOutput ruleActionOutput = actionOutputArray[n2];
                Output output = new Output(ruleActionOutput.name(), ruleActionOutput.type(), ruleActionOutput.label(), ruleActionOutput.description(), Arrays.stream(ruleActionOutput.tags()).collect(Collectors.toSet()), ruleActionOutput.reference(), ruleActionOutput.defaultValue());
                outputs.add(output);
                ++n2;
            }
        }
        return outputs;
    }

    public ActionType buildModuleType(String UID, Map<String, Set<ModuleInformation>> moduleInformation) {
        Set<ModuleInformation> mis = moduleInformation.get(UID);
        ArrayList<ConfigDescriptionParameter> configDescriptions = new ArrayList<ConfigDescriptionParameter>();
        if (mis != null && mis.size() > 0) {
            ModuleInformation mi = (ModuleInformation)mis.toArray()[0];
            ActionModuleKind kind = ActionModuleKind.SINGLE;
            if (mi.getConfigName() != null && mi.getThingUID() != null) {
                this.logger.error("ModuleType with UID {} has thingUID ({}) and multi-service ({}) property set, ignoring it.", new Object[]{UID, mi.getConfigName(), mi.getThingUID()});
                return null;
            }
            if (mi.getConfigName() != null) {
                kind = ActionModuleKind.SERVICE;
            } else if (mi.getThingUID() != null) {
                kind = ActionModuleKind.THING;
            }
            ConfigDescriptionParameter configParam = this.buildConfigParam(mis, kind);
            if (configParam != null) {
                configDescriptions.add(configParam);
            }
            ActionType at = new ActionType(UID, configDescriptions, mi.getLabel(), mi.getDescription(), mi.getTags(), mi.getVisibility(), mi.getInputs(), mi.getOutputs());
            return at;
        }
        return null;
    }

    private ConfigDescriptionParameter buildConfigParam(Set<ModuleInformation> moduleInformations, ActionModuleKind kind) {
        ArrayList<ParameterOption> options = new ArrayList<ParameterOption>();
        if (kind == ActionModuleKind.SINGLE) {
            if (moduleInformations.size() == 1 && ((ModuleInformation)moduleInformations.toArray()[0]).getConfigName() == null && ((ModuleInformation)moduleInformations.toArray()[0]).getThingUID() == null) {
                return null;
            }
        } else {
            if (kind == ActionModuleKind.SERVICE) {
                for (ModuleInformation mi : moduleInformations) {
                    String configName = mi.getConfigName();
                    options.add(new ParameterOption(configName, configName));
                }
                return ConfigDescriptionParameterBuilder.create((String)CONFIG_PARAM, (ConfigDescriptionParameter.Type)ConfigDescriptionParameter.Type.TEXT).withLabel(SELECT_SERVICE_LABEL).withOptions(options).withLimitToOptions(Boolean.valueOf(true)).withRequired(Boolean.valueOf(true)).build();
            }
            if (kind == ActionModuleKind.THING) {
                for (ModuleInformation mi : moduleInformations) {
                    String thingUID = mi.getThingUID();
                    options.add(new ParameterOption(thingUID, null));
                }
                return ConfigDescriptionParameterBuilder.create((String)CONFIG_PARAM, (ConfigDescriptionParameter.Type)ConfigDescriptionParameter.Type.TEXT).withLabel(SELECT_THING_LABEL).withContext("thing").withOptions(options).withLimitToOptions(Boolean.valueOf(true)).withRequired(Boolean.valueOf(true)).build();
            }
        }
        return null;
    }

    public ModuleInformation getModuleInformationForIdentifier(Action module, Map<String, Set<ModuleInformation>> moduleInformation, boolean thing) {
        Configuration c = module.getConfiguration();
        String config = (String)c.get(CONFIG_PARAM);
        Set<ModuleInformation> mis = moduleInformation.get(module.getTypeUID());
        ModuleInformation finalMI = null;
        if (mis.size() == 1 && config == null) {
            finalMI = (ModuleInformation)mis.toArray()[0];
        } else {
            for (ModuleInformation mi : mis) {
                if (thing) {
                    if (!Objects.equals(mi.getThingUID(), config)) continue;
                    finalMI = mi;
                    break;
                }
                if (!Objects.equals(mi.getConfigName(), config)) continue;
                finalMI = mi;
                break;
            }
        }
        return finalMI;
    }
}

