/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.persistence.internal;

import java.text.DateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.smarthome.core.common.SafeCaller;
import org.eclipse.smarthome.core.common.registry.RegistryChangeListener;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.items.ItemRegistryChangeListener;
import org.eclipse.smarthome.core.items.StateChangeListener;
import org.eclipse.smarthome.core.persistence.FilterCriteria;
import org.eclipse.smarthome.core.persistence.HistoricItem;
import org.eclipse.smarthome.core.persistence.PersistenceManager;
import org.eclipse.smarthome.core.persistence.PersistenceService;
import org.eclipse.smarthome.core.persistence.PersistenceServiceConfiguration;
import org.eclipse.smarthome.core.persistence.QueryablePersistenceService;
import org.eclipse.smarthome.core.persistence.SimpleItemConfiguration;
import org.eclipse.smarthome.core.persistence.config.SimpleAllConfig;
import org.eclipse.smarthome.core.persistence.config.SimpleConfig;
import org.eclipse.smarthome.core.persistence.config.SimpleGroupConfig;
import org.eclipse.smarthome.core.persistence.config.SimpleItemConfig;
import org.eclipse.smarthome.core.persistence.internal.PersistItemsJob;
import org.eclipse.smarthome.core.persistence.strategy.SimpleCronStrategy;
import org.eclipse.smarthome.core.persistence.strategy.SimpleStrategy;
import org.eclipse.smarthome.core.scheduler.CronScheduler;
import org.eclipse.smarthome.core.scheduler.ScheduledCompletableFuture;
import org.eclipse.smarthome.core.scheduler.SchedulerRunnable;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={PersistenceManager.class}, immediate=true)
public class PersistenceManagerImpl
implements PersistenceManager,
ItemRegistryChangeListener,
StateChangeListener {
    private final Logger logger = LoggerFactory.getLogger(PersistenceManagerImpl.class);
    private CronScheduler scheduler;
    private ItemRegistry itemRegistry;
    private SafeCaller safeCaller;
    private volatile boolean started = false;
    final Map<String, PersistenceService> persistenceServices = new HashMap<String, PersistenceService>();
    final Map<String, PersistenceServiceConfiguration> persistenceServiceConfigs = new HashMap<String, PersistenceServiceConfiguration>();
    private final Map<String, Set<ScheduledCompletableFuture<?>>> persistenceJobs = new HashMap();

    protected void activate() {
        this.allItemsChanged(null);
        this.started = true;
        this.itemRegistry.addRegistryChangeListener((RegistryChangeListener)this);
    }

    protected void deactivate() {
        this.itemRegistry.removeRegistryChangeListener((RegistryChangeListener)this);
        this.started = false;
        this.removeTimers();
        this.removeItemStateChangeListeners();
    }

    @Reference
    protected void setCronScheduler(CronScheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unsetCronScheduler(CronScheduler scheduler) {
        this.scheduler = null;
    }

    @Reference
    protected void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    protected void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    @Reference
    protected void setSafeCaller(SafeCaller safeCaller) {
        this.safeCaller = safeCaller;
    }

    protected void unsetSafeCaller(SafeCaller safeCaller) {
        this.safeCaller = null;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addPersistenceService(PersistenceService persistenceService) {
        this.logger.debug("Initializing {} persistence service.", (Object)persistenceService.getId());
        this.persistenceServices.put(persistenceService.getId(), persistenceService);
        if (this.started) {
            this.stopEventHandling(persistenceService.getId());
            this.startEventHandling(persistenceService.getId());
        }
    }

    protected void removePersistenceService(PersistenceService persistenceService) {
        this.stopEventHandling(persistenceService.getId());
        this.persistenceServices.remove(persistenceService.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleStateEvent(Item item, boolean onlyChanges) {
        Map<String, PersistenceServiceConfiguration> map = this.persistenceServiceConfigs;
        synchronized (map) {
            for (Map.Entry<String, PersistenceServiceConfiguration> entry : this.persistenceServiceConfigs.entrySet()) {
                String serviceName = entry.getKey();
                PersistenceServiceConfiguration config = entry.getValue();
                if (!this.persistenceServices.containsKey(serviceName)) continue;
                for (SimpleItemConfiguration itemConfig : config.getConfigs()) {
                    if (!this.hasStrategy(serviceName, itemConfig, onlyChanges ? SimpleStrategy.Globals.CHANGE : SimpleStrategy.Globals.UPDATE) || !this.appliesToItem(itemConfig, item)) continue;
                    this.persistenceServices.get(serviceName).store(item, itemConfig.getAlias());
                }
            }
        }
    }

    private boolean hasStrategy(String serviceName, SimpleItemConfiguration itemConfig, SimpleStrategy strategy) {
        PersistenceServiceConfiguration config = this.persistenceServiceConfigs.get(serviceName);
        if (config.getDefaults().contains(strategy) && itemConfig.getStrategies().isEmpty()) {
            return true;
        }
        for (SimpleStrategy s : itemConfig.getStrategies()) {
            if (!s.equals(strategy)) continue;
            return true;
        }
        return false;
    }

    private boolean appliesToItem(SimpleItemConfiguration config, Item item) {
        for (SimpleConfig itemCfg : config.getItems()) {
            if (itemCfg instanceof SimpleAllConfig) {
                return true;
            }
            if (itemCfg instanceof SimpleItemConfig) {
                SimpleItemConfig singleItemConfig = (SimpleItemConfig)itemCfg;
                if (item.getName().equals(singleItemConfig.getItem())) {
                    return true;
                }
            }
            if (!(itemCfg instanceof SimpleGroupConfig)) continue;
            SimpleGroupConfig groupItemCfg = (SimpleGroupConfig)itemCfg;
            String groupName = groupItemCfg.getGroup();
            try {
                GroupItem groupItem;
                Item gItem = this.itemRegistry.getItem(groupName);
                if (!(gItem instanceof GroupItem) || !(groupItem = (GroupItem)gItem).getAllMembers().contains(item)) continue;
                return true;
            }
            catch (Exception exception) {}
        }
        return false;
    }

    Iterable<Item> getAllItems(SimpleItemConfiguration config) {
        for (SimpleConfig itemCfg : config.getItems()) {
            if (!(itemCfg instanceof SimpleAllConfig)) continue;
            return this.itemRegistry.getItems();
        }
        HashSet<Item> items = new HashSet<Item>();
        for (SimpleConfig itemCfg : config.getItems()) {
            if (itemCfg instanceof SimpleItemConfig) {
                SimpleItemConfig singleItemConfig = (SimpleItemConfig)itemCfg;
                try {
                    Item item = this.itemRegistry.getItem(singleItemConfig.getItem());
                    items.add(item);
                }
                catch (ItemNotFoundException itemNotFoundException) {
                    this.logger.debug("Item '{}' does not exist.", (Object)singleItemConfig.getItem());
                }
            }
            if (!(itemCfg instanceof SimpleGroupConfig)) continue;
            SimpleGroupConfig groupItemCfg = (SimpleGroupConfig)itemCfg;
            String groupName = groupItemCfg.getGroup();
            try {
                Item gItem = this.itemRegistry.getItem(groupName);
                if (!(gItem instanceof GroupItem)) continue;
                GroupItem groupItem = (GroupItem)gItem;
                items.addAll(groupItem.getAllMembers());
            }
            catch (ItemNotFoundException itemNotFoundException) {
                this.logger.debug("Item group '{}' does not exist.", (Object)groupName);
            }
        }
        return items;
    }

    private void initialize(Item item) {
        if (item.getState().equals(UnDefType.NULL) && item instanceof GenericItem) {
            for (Map.Entry<String, PersistenceServiceConfiguration> entry : this.persistenceServiceConfigs.entrySet()) {
                String serviceName = entry.getKey();
                PersistenceServiceConfiguration config = entry.getValue();
                for (SimpleItemConfiguration itemConfig : config.getConfigs()) {
                    if (!this.hasStrategy(serviceName, itemConfig, SimpleStrategy.Globals.RESTORE) || !this.appliesToItem(itemConfig, item)) continue;
                    PersistenceService service = this.persistenceServices.get(serviceName);
                    if (service instanceof QueryablePersistenceService) {
                        Iterator<HistoricItem> it;
                        QueryablePersistenceService queryService = (QueryablePersistenceService)service;
                        FilterCriteria filter = new FilterCriteria().setItemName(item.getName()).setPageSize(1);
                        Iterable<HistoricItem> result = ((QueryablePersistenceService)this.safeCaller.create((Object)queryService, QueryablePersistenceService.class).onTimeout(() -> this.logger.warn("Querying persistence service '{}' takes more than {}ms.", (Object)queryService.getId(), (Object)SafeCaller.DEFAULT_TIMEOUT)).onException(e -> this.logger.error("Exception occurred while querying persistence service '{}': {}", new Object[]{queryService.getId(), e.getMessage(), e})).build()).query(filter);
                        if (result == null || !(it = result.iterator()).hasNext()) continue;
                        HistoricItem historicItem = it.next();
                        GenericItem genericItem = (GenericItem)item;
                        genericItem.removeStateChangeListener((StateChangeListener)this);
                        genericItem.setState(historicItem.getState());
                        genericItem.addStateChangeListener((StateChangeListener)this);
                        this.logger.debug("Restored item state from '{}' for item '{}' -> '{}'", new Object[]{DateFormat.getDateTimeInstance().format(historicItem.getTimestamp()), item.getName(), historicItem.getState().toString()});
                        return;
                    }
                    if (service == null) continue;
                    this.logger.warn("Failed to restore item states as persistence service '{}' can not be queried.", (Object)serviceName);
                }
            }
        }
    }

    private void removeItemStateChangeListeners() {
        for (Item item : this.itemRegistry.getAll()) {
            if (!(item instanceof GenericItem)) continue;
            ((GenericItem)item).removeStateChangeListener((StateChangeListener)this);
        }
    }

    private void createTimers(String dbId, List<SimpleStrategy> strategies) {
        for (SimpleStrategy strategy : strategies) {
            if (!(strategy instanceof SimpleCronStrategy)) continue;
            SimpleCronStrategy cronStrategy = (SimpleCronStrategy)strategy;
            String cronExpression = cronStrategy.getCronExpression();
            PersistItemsJob job = new PersistItemsJob(this, dbId, cronStrategy.getName());
            ScheduledCompletableFuture schedule = this.scheduler.schedule((SchedulerRunnable)job, cronExpression);
            if (this.persistenceJobs.containsKey(dbId)) {
                this.persistenceJobs.get(dbId).add(schedule);
            } else {
                HashSet<ScheduledCompletableFuture> jobs = new HashSet<ScheduledCompletableFuture>();
                jobs.add(schedule);
                this.persistenceJobs.put(dbId, jobs);
            }
            this.logger.debug("Scheduled strategy {} with cron expression {}", (Object)cronStrategy.getName(), (Object)cronExpression);
        }
    }

    private void removeTimers(String dbId) {
        if (!this.persistenceJobs.containsKey(dbId)) {
            return;
        }
        for (ScheduledCompletableFuture<?> job : this.persistenceJobs.get(dbId)) {
            job.cancel(true);
            this.logger.debug("Removed scheduled cron job for persistence service '{}'", (Object)dbId);
        }
        this.persistenceJobs.remove(dbId);
    }

    private void removeTimers() {
        HashSet<String> dbIds = new HashSet<String>(this.persistenceJobs.keySet());
        for (String dbId : dbIds) {
            this.removeTimers(dbId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConfig(String dbId, PersistenceServiceConfiguration config) {
        Map<String, PersistenceServiceConfiguration> map = this.persistenceServiceConfigs;
        synchronized (map) {
            this.persistenceServiceConfigs.put(dbId, config);
            if (this.persistenceServices.containsKey(dbId)) {
                this.startEventHandling(dbId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConfig(String dbId) {
        Map<String, PersistenceServiceConfiguration> map = this.persistenceServiceConfigs;
        synchronized (map) {
            this.stopEventHandling(dbId);
            this.persistenceServiceConfigs.remove(dbId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startEventHandling(String dbId) {
        Map<String, PersistenceServiceConfiguration> map = this.persistenceServiceConfigs;
        synchronized (map) {
            PersistenceServiceConfiguration config = this.persistenceServiceConfigs.get(dbId);
            if (config == null) {
                return;
            }
            for (SimpleItemConfiguration itemConfig : config.getConfigs()) {
                if (!this.hasStrategy(dbId, itemConfig, SimpleStrategy.Globals.RESTORE)) continue;
                for (Item item : this.getAllItems(itemConfig)) {
                    this.initialize(item);
                }
            }
            this.createTimers(dbId, config.getStrategies());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopEventHandling(String dbId) {
        Map<String, PersistenceServiceConfiguration> map = this.persistenceServiceConfigs;
        synchronized (map) {
            this.removeTimers(dbId);
        }
    }

    public void allItemsChanged(Collection<String> oldItemNames) {
        for (Item item : this.itemRegistry.getItems()) {
            this.added(item);
        }
    }

    public void added(Item item) {
        this.initialize(item);
        if (item instanceof GenericItem) {
            GenericItem genericItem = (GenericItem)item;
            genericItem.addStateChangeListener((StateChangeListener)this);
        }
    }

    public void removed(Item item) {
        if (item instanceof GenericItem) {
            GenericItem genericItem = (GenericItem)item;
            genericItem.removeStateChangeListener((StateChangeListener)this);
        }
    }

    public void updated(Item oldItem, Item item) {
        this.removed(oldItem);
        this.added(item);
    }

    public void stateChanged(Item item, State oldState, State newState) {
        this.handleStateEvent(item, true);
    }

    public void stateUpdated(Item item, State state) {
        this.handleStateEvent(item, false);
    }
}

