/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing;

import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;

@NonNullByDefault
public class ThingStatusInfo {
    private final ThingStatus status;
    private final ThingStatusDetail statusDetail;
    private @Nullable String description;

    protected ThingStatusInfo() {
        this.status = ThingStatus.UNKNOWN;
        this.statusDetail = ThingStatusDetail.NONE;
    }

    public ThingStatusInfo(ThingStatus status, ThingStatusDetail statusDetail, @Nullable String description) {
        this.status = status;
        this.statusDetail = statusDetail;
        this.description = description;
    }

    public ThingStatus getStatus() {
        return this.status;
    }

    public ThingStatusDetail getStatusDetail() {
        return this.statusDetail;
    }

    public @Nullable String getDescription() {
        return this.description;
    }

    public String toString() {
        return (Object)((Object)this.getStatus()) + (this.getStatusDetail() == ThingStatusDetail.NONE ? "" : " (" + (Object)((Object)this.getStatusDetail()) + ")") + (StringUtils.isBlank((String)this.getDescription()) ? "" : ": " + this.getDescription());
    }

    public int hashCode() {
        int result = 1;
        String description = this.description;
        result = 31 * result + (description == null ? 0 : description.hashCode());
        result = 31 * result + this.status.hashCode();
        result = 31 * result + this.statusDetail.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThingStatusInfo other = (ThingStatusInfo)obj;
        if (this.description == null ? other.description != null : !Objects.equals(this.description, other.description)) {
            return false;
        }
        if (this.status != other.status) {
            return false;
        }
        return this.statusDetail == other.statusDetail;
    }
}

