/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.i18n;

import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.i18n.TranslationProvider;
import org.eclipse.smarthome.core.thing.i18n.ThingTypeI18nUtil;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeBuilder;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.eclipse.smarthome.core.thing.type.StateChannelTypeBuilder;
import org.eclipse.smarthome.core.thing.type.TriggerChannelTypeBuilder;
import org.eclipse.smarthome.core.types.StateDescription;
import org.eclipse.smarthome.core.types.StateOption;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ChannelTypeI18nLocalizationService.class})
@NonNullByDefault
public class ChannelTypeI18nLocalizationService {
    @NonNullByDefault(value={})
    private ThingTypeI18nUtil thingTypeI18nUtil;

    @Reference
    protected void setTranslationProvider(TranslationProvider i18nProvider) {
        this.thingTypeI18nUtil = new ThingTypeI18nUtil(i18nProvider);
    }

    protected void unsetTranslationProvider(TranslationProvider i18nProvider) {
        this.thingTypeI18nUtil = null;
    }

    private @Nullable StateDescription createLocalizedStateDescription(Bundle bundle, @Nullable StateDescription state, ChannelTypeUID channelTypeUID, @Nullable Locale locale) {
        if (state == null) {
            return null;
        }
        String pattern = this.thingTypeI18nUtil.getChannelStatePattern(bundle, channelTypeUID, state.getPattern(), locale);
        ArrayList<StateOption> localizedOptions = new ArrayList<StateOption>();
        for (StateOption options : state.getOptions()) {
            String optionLabel = this.thingTypeI18nUtil.getChannelStateOption(bundle, channelTypeUID, options.getValue(), options.getLabel(), locale);
            localizedOptions.add(new StateOption(options.getValue(), optionLabel));
        }
        return new StateDescription(state.getMinimum(), state.getMaximum(), state.getStep(), pattern, state.isReadOnly(), localizedOptions);
    }

    public ChannelType createLocalizedChannelType(Bundle bundle, ChannelType channelType, @Nullable Locale locale) {
        ChannelTypeUID channelTypeUID = channelType.getUID();
        String defaultLabel = channelType.getLabel();
        String label = this.thingTypeI18nUtil.getChannelLabel(bundle, channelTypeUID, defaultLabel, locale);
        String description = this.thingTypeI18nUtil.getChannelDescription(bundle, channelTypeUID, channelType.getDescription(), locale);
        switch (channelType.getKind()) {
            case STATE: {
                StateDescription state = this.createLocalizedStateDescription(bundle, channelType.getState(), channelTypeUID, locale);
                StateChannelTypeBuilder stateBuilder = ((StateChannelTypeBuilder)((StateChannelTypeBuilder)((StateChannelTypeBuilder)((StateChannelTypeBuilder)ChannelTypeBuilder.state(channelTypeUID, label == null ? defaultLabel : label, channelType.getItemType()).isAdvanced(channelType.isAdvanced())).withCategory(channelType.getCategory())).withConfigDescriptionURI(channelType.getConfigDescriptionURI())).withTags(channelType.getTags())).withStateDescription(state).withAutoUpdatePolicy(channelType.getAutoUpdatePolicy());
                if (description != null) {
                    stateBuilder.withDescription(description);
                }
                return stateBuilder.build();
            }
            case TRIGGER: {
                TriggerChannelTypeBuilder triggerBuilder = ((TriggerChannelTypeBuilder)((TriggerChannelTypeBuilder)((TriggerChannelTypeBuilder)((TriggerChannelTypeBuilder)ChannelTypeBuilder.trigger(channelTypeUID, label == null ? defaultLabel : label).isAdvanced(channelType.isAdvanced())).withCategory(channelType.getCategory())).withConfigDescriptionURI(channelType.getConfigDescriptionURI())).withTags(channelType.getTags())).withEventDescription(channelType.getEvent());
                if (description != null) {
                    triggerBuilder.withDescription(description);
                }
                return triggerBuilder.build();
            }
        }
        return new ChannelType(channelTypeUID, channelType.isAdvanced(), channelType.getItemType(), channelType.getKind(), label == null ? defaultLabel : label, description, channelType.getCategory(), channelType.getTags(), channelType.getState(), channelType.getEvent(), channelType.getConfigDescriptionURI(), channelType.getAutoUpdatePolicy());
    }
}

