/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.measure.Quantity;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.common.SafeCaller;
import org.eclipse.smarthome.core.common.registry.RegistryChangeListener;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventFilter;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.events.EventSubscriber;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemFactory;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.items.ItemStateConverter;
import org.eclipse.smarthome.core.items.ItemUtil;
import org.eclipse.smarthome.core.items.events.ItemCommandEvent;
import org.eclipse.smarthome.core.items.events.ItemStateEvent;
import org.eclipse.smarthome.core.library.items.NumberItem;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.QuantityType;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.events.ChannelTriggeredEvent;
import org.eclipse.smarthome.core.thing.events.ThingEventFactory;
import org.eclipse.smarthome.core.thing.internal.AutoUpdateManager;
import org.eclipse.smarthome.core.thing.internal.ProfileContextImpl;
import org.eclipse.smarthome.core.thing.internal.profiles.ProfileCallbackImpl;
import org.eclipse.smarthome.core.thing.internal.profiles.SystemProfileFactory;
import org.eclipse.smarthome.core.thing.link.ItemChannelLink;
import org.eclipse.smarthome.core.thing.link.ItemChannelLinkRegistry;
import org.eclipse.smarthome.core.thing.profiles.Profile;
import org.eclipse.smarthome.core.thing.profiles.ProfileAdvisor;
import org.eclipse.smarthome.core.thing.profiles.ProfileCallback;
import org.eclipse.smarthome.core.thing.profiles.ProfileFactory;
import org.eclipse.smarthome.core.thing.profiles.ProfileTypeUID;
import org.eclipse.smarthome.core.thing.profiles.StateProfile;
import org.eclipse.smarthome.core.thing.profiles.TriggerProfile;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeRegistry;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.Type;
import org.eclipse.smarthome.core.types.util.UnitUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={EventSubscriber.class, CommunicationManager.class}, immediate=true)
public class CommunicationManager
implements EventSubscriber,
RegistryChangeListener<ItemChannelLink> {
    public static final long THINGHANDLER_EVENT_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    private static final Set<String> SUBSCRIBED_EVENT_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(ItemStateEvent.TYPE, ItemCommandEvent.TYPE, ChannelTriggeredEvent.TYPE)));
    private final Logger logger = LoggerFactory.getLogger(CommunicationManager.class);
    @NonNullByDefault(value={})
    private SystemProfileFactory defaultProfileFactory;
    @NonNullByDefault(value={})
    private ItemChannelLinkRegistry itemChannelLinkRegistry;
    @NonNullByDefault(value={})
    private ThingRegistry thingRegistry;
    @NonNullByDefault(value={})
    private ItemRegistry itemRegistry;
    @NonNullByDefault(value={})
    private EventPublisher eventPublisher;
    @NonNullByDefault(value={})
    private SafeCaller safeCaller;
    @NonNullByDefault(value={})
    private AutoUpdateManager autoUpdateManager;
    @NonNullByDefault(value={})
    private ItemStateConverter itemStateConverter;
    @NonNullByDefault(value={})
    private ChannelTypeRegistry channelTypeRegistry;
    private final Set<ItemFactory> itemFactories = new CopyOnWriteArraySet<ItemFactory>();
    private final Map<String, Profile> profiles = new ConcurrentHashMap<String, Profile>();
    private final Map<ProfileFactory, Set<String>> profileFactories = new ConcurrentHashMap<ProfileFactory, Set<String>>();
    private final Set<ProfileAdvisor> profileAdvisors = new CopyOnWriteArraySet<ProfileAdvisor>();
    private final Map<String, @Nullable List<Class<? extends Command>>> acceptedCommandTypeMap = new ConcurrentHashMap<String, List<Class<? extends Command>>>();
    private final Map<String, @Nullable List<Class<? extends State>>> acceptedStateTypeMap = new ConcurrentHashMap<String, List<Class<? extends State>>>();

    public Set<String> getSubscribedEventTypes() {
        return SUBSCRIBED_EVENT_TYPES;
    }

    public @Nullable EventFilter getEventFilter() {
        return null;
    }

    public void receive(Event event) {
        if (event instanceof ItemStateEvent) {
            this.receiveUpdate((ItemStateEvent)event);
        } else if (event instanceof ItemCommandEvent) {
            this.receiveCommand((ItemCommandEvent)event);
        } else if (event instanceof ChannelTriggeredEvent) {
            this.receiveTrigger((ChannelTriggeredEvent)event);
        }
    }

    private @Nullable Thing getThing(ThingUID thingUID) {
        return this.thingRegistry.get(thingUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Profile getProfile(ItemChannelLink link, Item item, @Nullable Thing thing) {
        Map<String, Profile> map = this.profiles;
        synchronized (map) {
            Profile profile = this.profiles.get(link.getUID());
            if (profile != null) {
                return profile;
            }
            ProfileTypeUID profileTypeUID = this.determineProfileTypeUID(link, item, thing);
            if (profileTypeUID != null && (profile = this.getProfileFromFactories(profileTypeUID, link, this.createCallback(link))) != null) {
                this.profiles.put(link.getUID(), profile);
                return profile;
            }
            return new NoOpProfile();
        }
    }

    private ProfileCallback createCallback(ItemChannelLink link) {
        return new ProfileCallbackImpl(this.eventPublisher, this.safeCaller, this.itemStateConverter, link, thingUID -> this.getThing((ThingUID)((Object)thingUID)), itemName -> this.getItem((String)itemName));
    }

    private @Nullable ProfileTypeUID determineProfileTypeUID(ItemChannelLink link, Item item, @Nullable Thing thing) {
        ProfileTypeUID profileTypeUID = this.getConfiguredProfileTypeUID(link);
        Channel channel = null;
        if (profileTypeUID == null) {
            if (thing == null) {
                return null;
            }
            channel = thing.getChannel(link.getLinkedUID().getId());
            if (channel == null) {
                return null;
            }
            profileTypeUID = this.getAdvice(link, item, channel);
            if (profileTypeUID == null) {
                this.logger.trace("No profile advisor found for link {}, falling back to the defaults", (Object)link);
                profileTypeUID = this.defaultProfileFactory.getSuggestedProfileTypeUID(channel, item.getType());
            }
        }
        return profileTypeUID;
    }

    private @Nullable ProfileTypeUID getAdvice(ItemChannelLink link, Item item, Channel channel) {
        for (ProfileAdvisor advisor : this.profileAdvisors) {
            ProfileTypeUID ret = advisor.getSuggestedProfileTypeUID(channel, item.getType());
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private @Nullable ProfileTypeUID getConfiguredProfileTypeUID(ItemChannelLink link) {
        String profileName = (String)link.getConfiguration().get("profile");
        if (profileName != null && !profileName.trim().isEmpty()) {
            profileName = this.normalizeProfileName(profileName);
            return new ProfileTypeUID(profileName);
        }
        return null;
    }

    private String normalizeProfileName(String profileName) {
        if (!profileName.contains(":")) {
            return "system:" + profileName;
        }
        return profileName;
    }

    private @Nullable Profile getProfileFromFactories(ProfileTypeUID profileTypeUID, ItemChannelLink link, ProfileCallback callback) {
        ProfileContextImpl context = new ProfileContextImpl(link.getConfiguration());
        if (this.supportsProfileTypeUID(this.defaultProfileFactory, profileTypeUID)) {
            this.logger.trace("using the default ProfileFactory to create profile '{}'", (Object)profileTypeUID);
            return this.defaultProfileFactory.createProfile(profileTypeUID, callback, context);
        }
        for (Map.Entry<ProfileFactory, Set<String>> entry : this.profileFactories.entrySet()) {
            ProfileFactory factory = entry.getKey();
            if (!this.supportsProfileTypeUID(factory, profileTypeUID)) continue;
            this.logger.trace("using ProfileFactory '{}' to create profile '{}'", (Object)factory, (Object)profileTypeUID);
            Profile profile = factory.createProfile(profileTypeUID, callback, context);
            if (profile == null) {
                this.logger.error("ProfileFactory '{}' returned 'null' although it claimed it supports item type '{}'", (Object)factory, (Object)profileTypeUID);
                continue;
            }
            entry.getValue().add(link.getUID());
            return profile;
        }
        this.logger.debug("no ProfileFactory found which supports '{}'", (Object)profileTypeUID);
        return null;
    }

    private boolean supportsProfileTypeUID(ProfileFactory profileFactory, ProfileTypeUID profileTypeUID) {
        return profileFactory.getSupportedProfileTypeUIDs().contains((Object)profileTypeUID);
    }

    private void receiveCommand(ItemCommandEvent commandEvent) {
        String itemName = commandEvent.getItemName();
        Command command = commandEvent.getItemCommand();
        Item item = this.getItem(itemName);
        if (item != null) {
            this.autoUpdateManager.receiveCommand(commandEvent, item);
        }
        this.handleEvent(itemName, command, commandEvent.getSource(), s -> this.acceptedCommandTypeMap.get(s), (profile, thing, convertedCommand) -> {
            if (profile instanceof StateProfile) {
                ((StateProfile)this.safeCaller.create((Object)((StateProfile)profile), StateProfile.class).withAsync().withIdentifier((Object)thing).withTimeout(THINGHANDLER_EVENT_TIMEOUT).build()).onCommandFromItem((Command)convertedCommand);
            }
        });
    }

    private void receiveUpdate(ItemStateEvent updateEvent) {
        String itemName = updateEvent.getItemName();
        State newState = updateEvent.getItemState();
        this.handleEvent(itemName, newState, updateEvent.getSource(), s -> this.acceptedStateTypeMap.get(s), (profile, thing, convertedState) -> ((Profile)this.safeCaller.create((Object)profile, Profile.class).withAsync().withIdentifier((Object)thing).withTimeout(THINGHANDLER_EVENT_TIMEOUT).build()).onStateUpdateFromItem((State)convertedState));
    }

    private <T extends Type> void handleEvent(String itemName, T type, @Nullable String source, Function<@Nullable String, @Nullable List<Class<? extends T>>> acceptedTypesFunction, ProfileAction<T> action) {
        Item item = this.getItem(itemName);
        if (item == null) {
            this.logger.debug("Received an event for item {} which does not exist", (Object)itemName);
            return;
        }
        this.itemChannelLinkRegistry.getLinks(itemName).stream().filter(link -> !link.getLinkedUID().toString().equals(source)).forEach(link -> {
            ChannelUID channelUID = link.getLinkedUID();
            Thing thing = this.getThing(channelUID.getThingUID());
            if (thing != null) {
                Channel channel = thing.getChannel(channelUID.getId());
                if (channel != null) {
                    @Nullable Type convertedType = this.toAcceptedType(type, channel, acceptedTypesFunction, item);
                    if (convertedType != null) {
                        if (thing.getHandler() != null) {
                            Profile profile = this.getProfile((ItemChannelLink)link, item, thing);
                            action.handle(profile, thing, convertedType);
                        }
                    } else {
                        this.logger.debug("Received event '{}' ({}) could not be converted to any type accepted by item '{}' ({})", new Object[]{type, type.getClass().getSimpleName(), itemName, item.getType()});
                    }
                } else {
                    this.logger.debug("Received  event '{}' for non-existing channel '{}', not forwarding it to the handler", (Object)type, (Object)channelUID);
                }
            } else {
                this.logger.debug("Received  event '{}' for non-existing thing '{}', not forwarding it to the handler", (Object)type, (Object)channelUID.getThingUID());
            }
        });
    }

    private <T extends Type> @Nullable T toAcceptedType(T originalType, Channel channel, Function<@Nullable String, @Nullable List<Class<? extends T>>> acceptedTypesFunction, Item item) {
        ChannelType channelType;
        String acceptedItemTypeFromChannelType;
        QuantityType<?> quantityType;
        QuantityType<?> quantityType2;
        String acceptedItemType = channel.getAcceptedItemType();
        if (originalType instanceof DecimalType && this.hasDimension(item, acceptedItemType) && (quantityType2 = this.convertToQuantityType((DecimalType)originalType, item, acceptedItemType)) != null) {
            return (T)quantityType2;
        }
        if (originalType instanceof DecimalType && !this.hasDimension(item, acceptedItemType) && this.channelTypeDefinesDimension(channel.getChannelTypeUID()) && (quantityType = this.convertToQuantityType((DecimalType)originalType, item, acceptedItemTypeFromChannelType = (channelType = this.channelTypeRegistry.getChannelType(channel.getChannelTypeUID())) != null ? channelType.getItemType() : null)) != null) {
            return (T)quantityType;
        }
        if (acceptedItemType == null) {
            return originalType;
        }
        List<Class<T>> acceptedTypes = acceptedTypesFunction.apply(acceptedItemType);
        if (acceptedTypes == null) {
            return originalType;
        }
        if (acceptedTypes.contains(originalType.getClass())) {
            return originalType;
        }
        for (Class<T> typeClass : acceptedTypes) {
            if (typeClass.isEnum() || !typeClass.isAssignableFrom(originalType.getClass()) || !State.class.isAssignableFrom(typeClass) || !(originalType instanceof State)) continue;
            State ret = ((State)originalType).as(typeClass);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Converted '{}' ({}) to accepted type '{}' ({}) for channel '{}' ", new Object[]{originalType, originalType.getClass().getSimpleName(), ret, ret.getClass().getName(), channel.getUID()});
            }
            return (T)ret;
        }
        this.logger.debug("Received not accepted type '{}' for channel '{}'", (Object)originalType.getClass().getSimpleName(), (Object)channel.getUID());
        return null;
    }

    private boolean channelTypeDefinesDimension(@Nullable ChannelTypeUID channelTypeUID) {
        if (channelTypeUID == null) {
            return false;
        }
        ChannelType channelType = this.channelTypeRegistry.getChannelType(channelTypeUID);
        return channelType != null && this.getDimension(channelType.getItemType()) != null;
    }

    private boolean hasDimension(Item item, @Nullable String acceptedItemType) {
        return item instanceof NumberItem && ((NumberItem)item).getDimension() != null || this.getDimension(acceptedItemType) != null;
    }

    private @Nullable QuantityType<?> convertToQuantityType(DecimalType originalType, Item item, @Nullable String acceptedItemType) {
        NumberItem numberItem = (NumberItem)item;
        Class<? extends Quantity<?>> dimension = numberItem.getDimension();
        if (dimension == null) {
            dimension = this.getDimension(acceptedItemType);
        }
        if (dimension != null) {
            return numberItem.toQuantityType(originalType, dimension);
        }
        return null;
    }

    private @Nullable Class<? extends Quantity<?>> getDimension(@Nullable String acceptedItemType) {
        if (acceptedItemType == null || acceptedItemType.isEmpty()) {
            return null;
        }
        String itemTypeExtension = ItemUtil.getItemTypeExtension((String)acceptedItemType);
        if (itemTypeExtension == null) {
            return null;
        }
        return UnitUtils.parseDimension((String)itemTypeExtension);
    }

    private @Nullable Item getItem(String itemName) {
        return (Item)this.itemRegistry.get((Object)itemName);
    }

    private void receiveTrigger(ChannelTriggeredEvent channelTriggeredEvent) {
        ChannelUID channelUID = channelTriggeredEvent.getChannel();
        String event = channelTriggeredEvent.getEvent();
        Thing thing = this.getThing(channelUID.getThingUID());
        this.handleCallFromHandler(channelUID, thing, profile -> {
            if (profile instanceof TriggerProfile) {
                ((TriggerProfile)profile).onTriggerFromHandler(event);
            }
        });
    }

    public void stateUpdated(ChannelUID channelUID, State state) {
        Thing thing = this.getThing(channelUID.getThingUID());
        this.handleCallFromHandler(channelUID, thing, profile -> {
            if (profile instanceof StateProfile) {
                ((StateProfile)profile).onStateUpdateFromHandler(state);
            }
        });
    }

    public void postCommand(ChannelUID channelUID, Command command) {
        Thing thing = this.getThing(channelUID.getThingUID());
        this.handleCallFromHandler(channelUID, thing, profile -> {
            if (profile instanceof StateProfile) {
                ((StateProfile)profile).onCommandFromHandler(command);
            }
        });
    }

    void handleCallFromHandler(ChannelUID channelUID, @Nullable Thing thing, Consumer<Profile> action) {
        this.itemChannelLinkRegistry.getLinks(channelUID).forEach(link -> {
            Item item = this.getItem(link.getItemName());
            if (item != null) {
                Profile profile = this.getProfile((ItemChannelLink)link, item, thing);
                action.accept(profile);
            }
        });
    }

    public void channelTriggered(Thing thing, ChannelUID channelUID, String event) {
        this.eventPublisher.post((Event)ThingEventFactory.createTriggerEvent(event, channelUID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup(ItemChannelLink link) {
        Map<String, Profile> map = this.profiles;
        synchronized (map) {
            this.profiles.remove(link.getUID());
        }
        this.profileFactories.values().forEach(list -> {
            boolean bl = list.remove(link.getUID());
        });
    }

    public void added(ItemChannelLink element) {
    }

    public void removed(ItemChannelLink element) {
        this.cleanup(element);
    }

    public void updated(ItemChannelLink oldElement, ItemChannelLink element) {
        this.cleanup(oldElement);
    }

    @Reference
    protected void setItemChannelLinkRegistry(ItemChannelLinkRegistry itemChannelLinkRegistry) {
        this.itemChannelLinkRegistry = itemChannelLinkRegistry;
        itemChannelLinkRegistry.addRegistryChangeListener(this);
    }

    protected void unsetItemChannelLinkRegistry(ItemChannelLinkRegistry itemChannelLinkRegistry) {
        this.itemChannelLinkRegistry = null;
    }

    @Reference
    protected void setThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = thingRegistry;
    }

    protected void unsetThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = null;
    }

    @Reference
    protected void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }

    @Reference
    protected void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    protected void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addProfileFactory(ProfileFactory profileFactory) {
        this.profileFactories.put(profileFactory, ConcurrentHashMap.newKeySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeProfileFactory(ProfileFactory profileFactory) {
        Set<String> links = this.profileFactories.remove(profileFactory);
        Map<String, Profile> map = this.profiles;
        synchronized (map) {
            links.forEach(link -> this.profiles.remove(link));
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addProfileAdvisor(ProfileAdvisor profileAdvisor) {
        this.profileAdvisors.add(profileAdvisor);
    }

    protected void removeProfileAdvisor(ProfileAdvisor profileAdvisor) {
        this.profileAdvisors.remove(profileAdvisor);
    }

    @Reference
    protected void setDefaultProfileFactory(SystemProfileFactory defaultProfileFactory) {
        this.defaultProfileFactory = defaultProfileFactory;
    }

    protected void unsetDefaultProfileFactory(SystemProfileFactory defaultProfileFactory) {
        this.defaultProfileFactory = null;
    }

    @Reference
    protected void setSafeCaller(SafeCaller safeCaller) {
        this.safeCaller = safeCaller;
    }

    protected void unsetSafeCaller(SafeCaller safeCaller) {
        this.safeCaller = null;
    }

    @Reference
    public void setItemStateConverter(ItemStateConverter itemStateConverter) {
        this.itemStateConverter = itemStateConverter;
    }

    public void unsetItemStateConverter(ItemStateConverter itemStateConverter) {
        this.itemStateConverter = null;
    }

    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC)
    protected void addItemFactory(ItemFactory itemFactory) {
        this.itemFactories.add(itemFactory);
        this.calculateAcceptedTypes();
    }

    protected void removeItemFactory(ItemFactory itemFactory) {
        this.itemFactories.remove(itemFactory);
        this.calculateAcceptedTypes();
    }

    private synchronized void calculateAcceptedTypes() {
        this.acceptedCommandTypeMap.clear();
        this.acceptedStateTypeMap.clear();
        for (ItemFactory itemFactory : this.itemFactories) {
            String[] stringArray = itemFactory.getSupportedItemTypes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String itemTypeName = stringArray[n2];
                Item item = itemFactory.createItem(itemTypeName, "tmp");
                if (item != null) {
                    this.acceptedCommandTypeMap.put(itemTypeName, item.getAcceptedCommandTypes());
                    this.acceptedStateTypeMap.put(itemTypeName, item.getAcceptedDataTypes());
                } else {
                    this.logger.error("Item factory {} suggested it can create items of type {} but returned null", (Object)itemFactory, (Object)itemTypeName);
                }
                ++n2;
            }
        }
    }

    @Reference
    public void setAutoUpdateManager(AutoUpdateManager autoUpdateManager) {
        this.autoUpdateManager = autoUpdateManager;
    }

    public void unsetAutoUpdateManager(AutoUpdateManager autoUpdateManager) {
        this.autoUpdateManager = null;
    }

    @Reference
    public void setChannelTypeRegistry(ChannelTypeRegistry channelTypeRegistry) {
        this.channelTypeRegistry = channelTypeRegistry;
    }

    public void unsetChannelTypeRegistry(ChannelTypeRegistry channelTypeRegistry) {
        this.channelTypeRegistry = null;
    }

    private static class NoOpProfile
    implements Profile {
        private NoOpProfile() {
        }

        @Override
        public @NonNull ProfileTypeUID getProfileTypeUID() {
            return new ProfileTypeUID("system", "noop");
        }

        @Override
        public void onStateUpdateFromItem(@NonNull State state) {
        }
    }

    @FunctionalInterface
    private static interface ProfileAction<T extends Type> {
        public void handle(Profile var1, Thing var2, T var3);
    }
}

