/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal.firmware;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.i18n.TranslationProvider;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.firmware.Firmware;
import org.eclipse.smarthome.core.thing.binding.firmware.FirmwareUpdateHandler;
import org.eclipse.smarthome.core.thing.binding.firmware.ProgressCallback;
import org.eclipse.smarthome.core.thing.binding.firmware.ProgressStep;
import org.eclipse.smarthome.core.thing.firmware.FirmwareEventFactory;
import org.eclipse.smarthome.core.thing.firmware.FirmwareUpdateProgressInfo;
import org.eclipse.smarthome.core.thing.firmware.FirmwareUpdateResult;
import org.eclipse.smarthome.core.thing.firmware.FirmwareUpdateResultInfo;
import org.eclipse.smarthome.core.thing.internal.firmware.ParameterChecks;
import org.eclipse.smarthome.core.util.BundleResolver;
import org.osgi.framework.Bundle;

final class ProgressCallbackImpl
implements ProgressCallback {
    private static final String UPDATE_CANCELED_MESSAGE_KEY = "update-canceled";
    private final FirmwareUpdateHandler firmwareUpdateHandler;
    private final EventPublisher eventPublisher;
    private final TranslationProvider i18nProvider;
    private final BundleResolver bundleResolver;
    private final ThingUID thingUID;
    private final Firmware firmware;
    private final Locale locale;
    private Collection<ProgressStep> sequence;
    private Iterator<ProgressStep> progressIterator;
    private ProgressStep current;
    private Integer progress;
    private InternalState state;

    ProgressCallbackImpl(FirmwareUpdateHandler firmwareUpdateHandler, EventPublisher eventPublisher, TranslationProvider i18nProvider, BundleResolver bundleResolver, ThingUID thingUID, Firmware firmware, Locale locale) {
        this.firmwareUpdateHandler = firmwareUpdateHandler;
        ParameterChecks.checkNotNull(eventPublisher, "Event publisher");
        this.eventPublisher = eventPublisher;
        ParameterChecks.checkNotNull(i18nProvider, "i18n provider");
        this.i18nProvider = i18nProvider;
        this.bundleResolver = bundleResolver;
        this.thingUID = thingUID;
        ParameterChecks.checkNotNull(firmware, "Firmware");
        this.firmware = firmware;
        this.locale = locale;
        this.progress = null;
    }

    @Override
    public void defineSequence(ProgressStep ... sequence) {
        if (sequence == null || sequence.length == 0) {
            throw new IllegalArgumentException("Sequence must not be null or empty.");
        }
        this.sequence = Collections.unmodifiableCollection(Arrays.asList(sequence));
        this.progressIterator = this.sequence.iterator();
        this.state = InternalState.INITIALIZED;
    }

    @Override
    public void next() {
        if (this.state == InternalState.FINISHED) {
            throw new IllegalStateException("Update is finished.");
        }
        if (this.state == InternalState.PENDING) {
            this.state = InternalState.RUNNING;
            this.postProgressInfoEvent();
        } else if (this.progressIterator.hasNext()) {
            this.state = InternalState.RUNNING;
            this.current = this.progressIterator.next();
            this.postProgressInfoEvent();
        } else {
            this.state = InternalState.FINISHED;
            throw new IllegalStateException("There is no further progress step to be executed.");
        }
    }

    @Override
    public void failed(String errorMessageKey, Object ... arguments) {
        if (this.state == InternalState.FINISHED) {
            throw new IllegalStateException("Update is finished.");
        }
        if (errorMessageKey == null || errorMessageKey.isEmpty()) {
            throw new IllegalArgumentException("The error message key must not be null or empty.");
        }
        this.state = InternalState.FINISHED;
        String errorMessage = this.getMessage(this.firmwareUpdateHandler.getClass(), errorMessageKey, arguments);
        this.postResultInfoEvent(FirmwareUpdateResult.ERROR, errorMessage);
    }

    @Override
    public void success() {
        if (this.state == InternalState.FINISHED) {
            throw new IllegalStateException("Update is finished.");
        }
        if (!(this.progress != null && this.progress >= 100 || this.progressIterator != null && !this.progressIterator.hasNext())) {
            throw new IllegalStateException("Update can't be successfully finished until progress is 100% or last progress step is reached");
        }
        this.state = InternalState.FINISHED;
        this.postResultInfoEvent(FirmwareUpdateResult.SUCCESS, null);
    }

    @Override
    public void pending() {
        if (this.state == InternalState.FINISHED) {
            throw new IllegalStateException("Update is finished.");
        }
        this.state = InternalState.PENDING;
        this.postProgressInfoEvent();
    }

    @Override
    public void canceled() {
        if (this.state == InternalState.FINISHED) {
            throw new IllegalStateException("Update is finished.");
        }
        this.state = InternalState.FINISHED;
        String cancelMessage = this.getMessage(this.getClass(), UPDATE_CANCELED_MESSAGE_KEY, new Object[0]);
        this.postResultInfoEvent(FirmwareUpdateResult.CANCELED, cancelMessage);
    }

    @Override
    public void update(int progress) {
        if (this.state == InternalState.FINISHED) {
            throw new IllegalStateException("Update is finished.");
        }
        if (progress < 0 || progress > 100) {
            throw new IllegalArgumentException("The progress must be between 0 and 100.");
        }
        if (this.progress == null) {
            this.updateProgress(progress);
        } else {
            if (progress < this.progress) {
                throw new IllegalArgumentException("The new progress must not be smaller than the old progress.");
            }
            if (this.progress != progress) {
                this.updateProgress(progress);
            }
        }
    }

    private void updateProgress(int progress) {
        this.progress = progress;
        this.state = InternalState.RUNNING;
        this.postProgressInfoEvent();
    }

    void failedInternal(String errorMessageKey) {
        this.state = InternalState.FINISHED;
        String errorMessage = this.getMessage(ProgressCallbackImpl.class, errorMessageKey, new Object[0]);
        this.postResultInfoEvent(FirmwareUpdateResult.ERROR, errorMessage);
    }

    private String getMessage(Class<?> clazz, String errorMessageKey, Object ... arguments) {
        Bundle bundle = this.bundleResolver.resolveBundle(clazz);
        String errorMessage = this.i18nProvider.getText(bundle, errorMessageKey, null, this.locale, arguments);
        return errorMessage;
    }

    private void postResultInfoEvent(FirmwareUpdateResult result, String message) {
        this.post((Event)FirmwareEventFactory.createFirmwareUpdateResultInfoEvent(FirmwareUpdateResultInfo.createFirmwareUpdateResultInfo(this.thingUID, result, message)));
    }

    private void postProgressInfoEvent() {
        if (this.progress == null) {
            this.post((Event)FirmwareEventFactory.createFirmwareUpdateProgressInfoEvent(FirmwareUpdateProgressInfo.createFirmwareUpdateProgressInfo(this.thingUID, this.firmware.getThingTypeUID(), this.firmware.getVersion(), this.getCurrentStep(), this.sequence, this.state == InternalState.PENDING)));
        } else {
            this.post((Event)FirmwareEventFactory.createFirmwareUpdateProgressInfoEvent(FirmwareUpdateProgressInfo.createFirmwareUpdateProgressInfo(this.thingUID, this.firmware.getVersion(), this.getCurrentStep(), this.sequence, this.state == InternalState.PENDING, this.progress)));
        }
    }

    private void post(Event event) {
        this.eventPublisher.post(event);
    }

    ProgressStep getCurrentStep() {
        if (this.current != null) {
            return this.current;
        }
        if (this.sequence != null && this.progressIterator.hasNext()) {
            this.current = this.progressIterator.next();
            return this.current;
        }
        return null;
    }

    private static enum InternalState {
        FINISHED,
        PENDING,
        RUNNING,
        INITIALIZED;

    }
}

