/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.internal.profiles;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.smarthome.core.thing.profiles.ProfileType;
import org.eclipse.smarthome.core.thing.profiles.ProfileTypeProvider;
import org.eclipse.smarthome.core.thing.profiles.ProfileTypeRegistry;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={ProfileTypeRegistry.class})
public class ProfileTypeRegistryImpl
implements ProfileTypeRegistry {
    private final List<ProfileTypeProvider> profileTypeProviders = new CopyOnWriteArrayList<ProfileTypeProvider>();

    @Override
    public List<ProfileType> getProfileTypes() {
        return this.getProfileTypes(null);
    }

    @Override
    public List<ProfileType> getProfileTypes(Locale locale) {
        ArrayList<ProfileType> profileTypes = new ArrayList<ProfileType>();
        for (ProfileTypeProvider profileTypeProvider : this.profileTypeProviders) {
            profileTypes.addAll(profileTypeProvider.getProfileTypes(locale));
        }
        return Collections.unmodifiableList(profileTypes);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addProfileTypeProvider(ProfileTypeProvider profileTypeProvider) {
        this.profileTypeProviders.add(profileTypeProvider);
    }

    protected void removeProfileTypeProvider(ProfileTypeProvider profileTypeProvider) {
        this.profileTypeProviders.remove(profileTypeProvider);
    }
}

