/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.link.events;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.smarthome.core.events.AbstractEventFactory;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventFactory;
import org.eclipse.smarthome.core.thing.link.AbstractLink;
import org.eclipse.smarthome.core.thing.link.ItemChannelLink;
import org.eclipse.smarthome.core.thing.link.dto.ItemChannelLinkDTO;
import org.eclipse.smarthome.core.thing.link.events.ItemChannelLinkAddedEvent;
import org.eclipse.smarthome.core.thing.link.events.ItemChannelLinkRemovedEvent;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={EventFactory.class})
public class LinkEventFactory
extends AbstractEventFactory {
    private static final String LINK_ADDED_EVENT_TOPIC = "smarthome/links/{linkID}/added";
    private static final String LINK_REMOVED_EVENT_TOPIC = "smarthome/links/{linkID}/removed";

    public LinkEventFactory() {
        super(Stream.of(ItemChannelLinkAddedEvent.TYPE, ItemChannelLinkRemovedEvent.TYPE).collect(Collectors.toSet()));
    }

    protected Event createEventByType(String eventType, String topic, String payload, String source) throws Exception {
        Event event = null;
        if (eventType.equals(ItemChannelLinkAddedEvent.TYPE)) {
            event = this.createItemChannelLinkAddedEvent(topic, payload);
        } else if (eventType.equals(ItemChannelLinkRemovedEvent.TYPE)) {
            event = this.createItemChannelLinkRemovedEvent(topic, payload);
        }
        return event;
    }

    private Event createItemChannelLinkAddedEvent(String topic, String payload) throws Exception {
        ItemChannelLinkDTO link = (ItemChannelLinkDTO)LinkEventFactory.deserializePayload((String)payload, ItemChannelLinkDTO.class);
        return new ItemChannelLinkAddedEvent(topic, payload, link);
    }

    private Event createItemChannelLinkRemovedEvent(String topic, String payload) throws Exception {
        ItemChannelLinkDTO link = (ItemChannelLinkDTO)LinkEventFactory.deserializePayload((String)payload, ItemChannelLinkDTO.class);
        return new ItemChannelLinkRemovedEvent(topic, payload, link);
    }

    public static ItemChannelLinkAddedEvent createItemChannelLinkAddedEvent(ItemChannelLink itemChannelLink) {
        LinkEventFactory.checkNotNull((Object)itemChannelLink, (String)"itemChannelLink");
        String topic = LinkEventFactory.buildTopic(LINK_ADDED_EVENT_TOPIC, itemChannelLink);
        ItemChannelLinkDTO itemChannelLinkDTO = LinkEventFactory.map(itemChannelLink);
        String payload = LinkEventFactory.serializePayload((Object)itemChannelLinkDTO);
        return new ItemChannelLinkAddedEvent(topic, payload, itemChannelLinkDTO);
    }

    public static ItemChannelLinkRemovedEvent createItemChannelLinkRemovedEvent(ItemChannelLink itemChannelLink) {
        LinkEventFactory.checkNotNull((Object)itemChannelLink, (String)"itemChannelLink");
        String topic = LinkEventFactory.buildTopic(LINK_REMOVED_EVENT_TOPIC, itemChannelLink);
        ItemChannelLinkDTO itemChannelLinkDTO = LinkEventFactory.map(itemChannelLink);
        String payload = LinkEventFactory.serializePayload((Object)itemChannelLinkDTO);
        return new ItemChannelLinkRemovedEvent(topic, payload, itemChannelLinkDTO);
    }

    private static String buildTopic(String topic, AbstractLink itemChannelLink) {
        String targetEntity = String.valueOf(itemChannelLink.getItemName()) + "-" + itemChannelLink.getLinkedUID().toString();
        return topic.replace("{linkID}", targetEntity);
    }

    private static ItemChannelLinkDTO map(ItemChannelLink itemChannelLink) {
        return new ItemChannelLinkDTO(itemChannelLink.getItemName(), itemChannelLink.getLinkedUID().toString(), itemChannelLink.getConfiguration().getProperties());
    }
}

