/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.profiles;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.core.thing.internal.profiles.StateProfileTypeImpl;
import org.eclipse.smarthome.core.thing.internal.profiles.TriggerProfileTypeImpl;
import org.eclipse.smarthome.core.thing.profiles.ProfileType;
import org.eclipse.smarthome.core.thing.profiles.ProfileTypeUID;
import org.eclipse.smarthome.core.thing.profiles.StateProfileType;
import org.eclipse.smarthome.core.thing.profiles.TriggerProfileType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;

@NonNullByDefault
public final class ProfileTypeBuilder<T extends ProfileType> {
    private final ProfileTypeFactory<T> profileTypeFactory;
    private final ProfileTypeUID profileTypeUID;
    private final Collection<String> supportedItemTypes = new HashSet<String>();
    private final Collection<String> supportedItemTypesOfChannel = new HashSet<String>();
    private final Collection<ChannelTypeUID> supportedChannelTypeUIDs = new HashSet<ChannelTypeUID>();
    private final String label;

    private ProfileTypeBuilder(ProfileTypeUID profileTypeUID, String label, ProfileTypeFactory<T> profileTypeFactory) {
        this.profileTypeFactory = profileTypeFactory;
        this.profileTypeUID = profileTypeUID;
        this.label = label;
    }

    public static ProfileTypeBuilder<StateProfileType> newState(ProfileTypeUID profileTypeUID, String label) {
        return new ProfileTypeBuilder<StateProfileType>(profileTypeUID, label, (leProfileTypeUID, leLabel, leSupportedItemTypes, leSupportedItemTypesOfChannel, leSupportedChannelTypeUIDs) -> new StateProfileTypeImpl(leProfileTypeUID, leLabel, leSupportedItemTypes, leSupportedItemTypesOfChannel));
    }

    public static ProfileTypeBuilder<TriggerProfileType> newTrigger(ProfileTypeUID profileTypeUID, String label) {
        return new ProfileTypeBuilder<TriggerProfileType>(profileTypeUID, label, (leProfileTypeUID, leLabel, leSupportedItemTypes, leSupportedItemTypesOfChannel, leSupportedChannelTypeUIDs) -> new TriggerProfileTypeImpl(leProfileTypeUID, leLabel, leSupportedItemTypes, leSupportedChannelTypeUIDs));
    }

    public ProfileTypeBuilder<T> withSupportedItemTypes(String ... itemType) {
        this.supportedItemTypes.addAll(Arrays.asList(itemType));
        return this;
    }

    public ProfileTypeBuilder<T> withSupportedItemTypes(Collection<String> itemTypes) {
        this.supportedItemTypes.addAll(itemTypes);
        return this;
    }

    public ProfileTypeBuilder<T> withSupportedChannelTypeUIDs(ChannelTypeUID ... channelTypeUIDs) {
        this.supportedChannelTypeUIDs.addAll(Arrays.asList(channelTypeUIDs));
        return this;
    }

    public ProfileTypeBuilder<T> withSupportedChannelTypeUIDs(Collection<ChannelTypeUID> channelTypeUIDs) {
        this.supportedChannelTypeUIDs.addAll(channelTypeUIDs);
        return this;
    }

    public ProfileTypeBuilder<T> withSupportedItemTypesOfChannel(String ... supportedItemTypesOfChannel) {
        this.supportedItemTypesOfChannel.addAll(Arrays.asList(supportedItemTypesOfChannel));
        return this;
    }

    public ProfileTypeBuilder<T> withSupportedItemTypesOfChannel(Collection<String> supportedItemTypesOfChannel) {
        this.supportedItemTypesOfChannel.addAll(supportedItemTypesOfChannel);
        return this;
    }

    public T build() {
        return this.profileTypeFactory.create(this.profileTypeUID, this.label, this.supportedItemTypes, this.supportedItemTypesOfChannel, this.supportedChannelTypeUIDs);
    }

    @FunctionalInterface
    private static interface ProfileTypeFactory<T extends ProfileType> {
        public T create(ProfileTypeUID var1, String var2, Collection<String> var3, Collection<String> var4, Collection<ChannelTypeUID> var5);
    }
}

