/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.internal.common;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.common.SafeCaller;
import org.eclipse.smarthome.core.common.SafeCallerBuilder;
import org.eclipse.smarthome.core.common.ThreadPoolManager;
import org.eclipse.smarthome.core.internal.common.SafeCallManagerImpl;
import org.eclipse.smarthome.core.internal.common.SafeCallerBuilderImpl;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@NonNullByDefault
@Component(configurationPid="org.eclipse.smarthome.safecaller", immediate=true)
public class SafeCallerImpl
implements SafeCaller {
    private static final String SAFE_CALL_POOL_NAME = "safeCall";
    @NonNullByDefault(value={})
    private ScheduledExecutorService watcher;
    @NonNullByDefault(value={})
    private SafeCallManagerImpl manager;

    @Activate
    public void activate(@Nullable Map<String, Object> properties) {
        this.watcher = Executors.newSingleThreadScheduledExecutor();
        this.manager = new SafeCallManagerImpl(this.watcher, this.getScheduler(), false);
        this.modified(properties);
    }

    @Modified
    public void modified(@Nullable Map<String, Object> properties) {
        if (properties != null) {
            String enabled = (String)properties.get("singleThread");
            this.manager.setEnforceSingleThreadPerIdentifier("true".equalsIgnoreCase(enabled));
        }
    }

    @Deactivate
    public void deactivate() {
        if (this.watcher != null) {
            this.watcher.shutdownNow();
            this.watcher = null;
        }
        this.manager = null;
    }

    @Override
    public <T> SafeCallerBuilder<T> create(T target, Class<T> interfaceType) {
        return new SafeCallerBuilderImpl<T>(target, new Class[]{interfaceType}, this.manager);
    }

    protected ExecutorService getScheduler() {
        return ThreadPoolManager.getPool(SAFE_CALL_POOL_NAME);
    }
}

