/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.internal.scheduler;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.internal.scheduler.CronAdjuster;
import org.eclipse.smarthome.core.scheduler.CronJob;
import org.eclipse.smarthome.core.scheduler.CronScheduler;
import org.eclipse.smarthome.core.scheduler.ScheduledCompletableFuture;
import org.eclipse.smarthome.core.scheduler.Scheduler;
import org.eclipse.smarthome.core.scheduler.SchedulerRunnable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={CronScheduler.class})
@NonNullByDefault
public class CronSchedulerImpl
implements CronScheduler {
    private final Logger logger = LoggerFactory.getLogger(CronSchedulerImpl.class);
    private final List<Cron> crons = new ArrayList<Cron>();
    @NonNullByDefault(value={})
    private Scheduler scheduler;

    @Override
    public ScheduledCompletableFuture<@Nullable Void> schedule(SchedulerRunnable runnable, String cronExpression) {
        return this.schedule(d -> runnable.run(), Collections.emptyMap(), cronExpression);
    }

    @Override
    public ScheduledCompletableFuture<@Nullable Void> schedule(CronJob job, Map<String, Object> config, String cronExpression) {
        CronAdjuster cronAdjuster = new CronAdjuster(cronExpression);
        SchedulerRunnable runnable = () -> job.run(config);
        if (cronAdjuster.isReboot()) {
            return this.scheduler.at(runnable, Instant.ofEpochMilli(1L));
        }
        return this.scheduler.schedule(runnable, cronAdjuster);
    }

    @Reference
    void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    void unsetScheduler(Scheduler scheduler) {
        this.scheduler = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    <T> void addSchedule(CronJob cronJob, Map<String, Object> map) {
        Object scheduleConfig = map.get("cron");
        String[] schedules = null;
        if (scheduleConfig instanceof String[]) {
            schedules = (String[])scheduleConfig;
        } else if (scheduleConfig instanceof String) {
            schedules = new String[]{(String)scheduleConfig};
        }
        if (schedules == null || schedules.length == 0) {
            this.logger.info("No schedules in map with key 'cron'. Nothing scheduled");
            return;
        }
        List<Cron> list = this.crons;
        synchronized (list) {
            String[] stringArray = schedules;
            int n = schedules.length;
            int n2 = 0;
            while (n2 < n) {
                String schedule = stringArray[n2];
                try {
                    Cron cron = new Cron(cronJob, this.schedule(cronJob, map, schedule));
                    this.crons.add(cron);
                }
                catch (RuntimeException e) {
                    this.logger.warn("Invalid cron expression {} from {}", new Object[]{schedule, map, e});
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSchedule(CronJob s) {
        List<Cron> list = this.crons;
        synchronized (list) {
            Iterator<Cron> cron = this.crons.iterator();
            while (cron.hasNext()) {
                Cron c = cron.next();
                if (c.target != s) continue;
                cron.remove();
                c.schedule.cancel(true);
            }
        }
    }

    private static class Cron {
        private final CronJob target;
        private final ScheduledCompletableFuture<?> schedule;

        public Cron(CronJob target, ScheduledCompletableFuture<?> schedule) {
            this.target = target;
            this.schedule = schedule;
        }
    }
}

