/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.internal.service;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.internal.types.StateDescriptionFragmentImpl;
import org.eclipse.smarthome.core.service.StateDescriptionService;
import org.eclipse.smarthome.core.types.StateDescription;
import org.eclipse.smarthome.core.types.StateDescriptionFragment;
import org.eclipse.smarthome.core.types.StateDescriptionFragmentProvider;
import org.eclipse.smarthome.core.types.StateDescriptionProvider;
import org.eclipse.smarthome.core.types.StateOption;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@NonNullByDefault
@Component
public class StateDescriptionServiceImpl
implements StateDescriptionService {
    @Deprecated
    private final Set<StateDescriptionProvider> stateDescriptionProviders = Collections.synchronizedSet(new TreeSet<StateDescriptionProvider>(new Comparator<StateDescriptionProvider>(){

        @Override
        public int compare(StateDescriptionProvider provider1, StateDescriptionProvider provider2) {
            return provider2.getRank().compareTo(provider1.getRank());
        }
    }));
    private final Set<StateDescriptionFragmentProvider> stateDescriptionFragmentProviders = Collections.synchronizedSet(new TreeSet<StateDescriptionFragmentProvider>(new Comparator<StateDescriptionFragmentProvider>(){

        @Override
        public int compare(StateDescriptionFragmentProvider provider1, StateDescriptionFragmentProvider provider2) {
            return provider2.getRank().compareTo(provider1.getRank());
        }
    }));

    @Deprecated
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addStateDescriptionProvider(StateDescriptionProvider provider) {
        this.stateDescriptionProviders.add(provider);
    }

    @Deprecated
    public void removeStateDescriptionProvider(StateDescriptionProvider provider) {
        this.stateDescriptionProviders.remove(provider);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addStateDescriptionFragmentProvider(StateDescriptionFragmentProvider provider) {
        this.stateDescriptionFragmentProviders.add(provider);
    }

    public void removeStateDescriptionFragmentProvider(StateDescriptionFragmentProvider provider) {
        this.stateDescriptionFragmentProviders.remove(provider);
    }

    @Override
    public @Nullable StateDescription getStateDescription(String itemName, @Nullable Locale locale) {
        StateDescription legacy = this.getLegacyStateDescription(itemName, locale);
        StateDescriptionFragment stateDescriptionFragment = this.mergeStateDescriptionFragments(itemName, locale);
        StateDescriptionFragment result = legacy != null ? new StateDescriptionFragmentImpl(legacy).merge(stateDescriptionFragment) : stateDescriptionFragment;
        return result.toStateDescription();
    }

    private StateDescriptionFragment mergeStateDescriptionFragments(String itemName, @Nullable Locale locale) {
        StateDescriptionFragmentImpl result = new StateDescriptionFragmentImpl();
        for (StateDescriptionFragmentProvider provider : this.stateDescriptionFragmentProviders) {
            StateDescriptionFragment fragment = provider.getStateDescriptionFragment(itemName, locale);
            if (fragment == null) continue;
            result.merge(fragment);
        }
        return result;
    }

    @Deprecated
    private @Nullable StateDescription getLegacyStateDescription(String itemName, @Nullable Locale locale) {
        StateDescription result = null;
        List<StateOption> stateOptions = Collections.emptyList();
        for (StateDescriptionProvider stateDescriptionProvider : this.stateDescriptionProviders) {
            StateDescription stateDescription = stateDescriptionProvider.getStateDescription(itemName, locale);
            if (stateDescription == null) continue;
            if (result == null) {
                result = stateDescription;
            }
            if (stateDescription.getOptions().isEmpty() || !stateOptions.isEmpty()) continue;
            stateOptions = stateDescription.getOptions();
        }
        if (result != null && !stateOptions.isEmpty()) {
            result = new StateDescription(result.getMinimum(), result.getMaximum(), result.getStep(), result.getPattern(), result.isReadOnly(), stateOptions);
        }
        return result;
    }
}

