/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.library.unit;

import java.math.BigInteger;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Length;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Temperature;
import javax.measure.spi.SystemOfUnits;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.core.library.unit.SmartHomeUnits;
import tec.uom.se.AbstractConverter;
import tec.uom.se.format.SimpleUnitFormat;
import tec.uom.se.function.AddConverter;
import tec.uom.se.function.MultiplyConverter;
import tec.uom.se.function.RationalConverter;
import tec.uom.se.unit.ProductUnit;
import tec.uom.se.unit.TransformedUnit;
import tec.uom.se.unit.Units;

@NonNullByDefault
public class ImperialUnits
extends SmartHomeUnits {
    private static final ImperialUnits INSTANCE = new ImperialUnits();
    public static final Unit<Pressure> INCH_OF_MERCURY = ImperialUnits.addUnit(new TransformedUnit("inHg", Units.PASCAL, (UnitConverter)new RationalConverter(BigInteger.valueOf(3386388L), BigInteger.valueOf(1000L))));
    public static final Unit<Temperature> FAHRENHEIT = ImperialUnits.addUnit(new TransformedUnit("\u00b0F", Units.KELVIN, (UnitConverter)new RationalConverter(BigInteger.valueOf(5L), BigInteger.valueOf(9L)).concatenate((AbstractConverter)new AddConverter(459.67))));
    public static final Unit<Speed> MILES_PER_HOUR = ImperialUnits.addUnit(new TransformedUnit("mph", Units.KILOMETRE_PER_HOUR, (UnitConverter)new RationalConverter(1609344L, 1000000L)));
    public static final Unit<Length> INCH = ImperialUnits.addUnit(new TransformedUnit("in", Units.METRE, (UnitConverter)new RationalConverter(254L, 10000L)));
    public static final Unit<Length> FOOT = ImperialUnits.addUnit(new TransformedUnit("ft", INCH, (UnitConverter)new MultiplyConverter(12.0)));
    public static final Unit<Length> YARD = ImperialUnits.addUnit(new TransformedUnit("yd", FOOT, (UnitConverter)new MultiplyConverter(3.0)));
    public static final Unit<Length> CHAIN = ImperialUnits.addUnit(new TransformedUnit("ch", YARD, (UnitConverter)new MultiplyConverter(22.0)));
    public static final Unit<Length> FURLONG = ImperialUnits.addUnit(new TransformedUnit("fur", CHAIN, (UnitConverter)new MultiplyConverter(10.0)));
    public static final Unit<Length> MILE = ImperialUnits.addUnit(new TransformedUnit("mi", FURLONG, (UnitConverter)new MultiplyConverter(8.0)));
    public static final Unit<Length> LEAGUE = ImperialUnits.addUnit(new TransformedUnit("lea", MILE, (UnitConverter)new MultiplyConverter(3.0)));
    public static final Unit<Length> SQUARE_FOOT = ImperialUnits.addUnit(new ProductUnit(FOOT.multiply(FOOT)));
    public static final Unit<Length> CUBIC_FOOT = ImperialUnits.addUnit(new ProductUnit(SQUARE_FOOT.multiply(FOOT)));

    static {
        SimpleUnitFormat.getInstance().label(INCH_OF_MERCURY, INCH_OF_MERCURY.getSymbol());
        SimpleUnitFormat.getInstance().label(FAHRENHEIT, FAHRENHEIT.getSymbol());
        SimpleUnitFormat.getInstance().label(MILES_PER_HOUR, MILES_PER_HOUR.getSymbol());
        SimpleUnitFormat.getInstance().label(INCH, INCH.getSymbol());
        SimpleUnitFormat.getInstance().label(FOOT, FOOT.getSymbol());
        SimpleUnitFormat.getInstance().label(YARD, YARD.getSymbol());
        SimpleUnitFormat.getInstance().label(CHAIN, CHAIN.getSymbol());
        SimpleUnitFormat.getInstance().label(FURLONG, FURLONG.getSymbol());
        SimpleUnitFormat.getInstance().label(MILE, MILE.getSymbol());
        SimpleUnitFormat.getInstance().label(LEAGUE, LEAGUE.getSymbol());
    }

    private ImperialUnits() {
    }

    @Override
    public String getName() {
        return ImperialUnits.class.getSimpleName();
    }

    public static SystemOfUnits getInstance() {
        return INSTANCE;
    }

    private static <U extends Unit<?>> U addUnit(U unit) {
        ImperialUnits.INSTANCE.units.add(unit);
        return unit;
    }
}

