/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.service;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchEvent;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.core.service.WatchQueueReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWatchService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String pathToWatch;
    protected WatchQueueReader watchQueueReader;

    protected AbstractWatchService(String pathToWatch) {
        this.pathToWatch = pathToWatch;
    }

    public void activate() {
        Path pathToWatch = this.getSourcePath();
        if (pathToWatch != null) {
            this.watchQueueReader = WatchQueueReader.getInstance();
            this.watchQueueReader.customizeWatchQueueReader(this, pathToWatch, this.watchSubDirectories());
        }
    }

    public void deactivate() {
        WatchQueueReader watchQueueReader = this.watchQueueReader;
        if (watchQueueReader != null) {
            watchQueueReader.stopWatchService(this);
        }
        this.watchQueueReader = null;
    }

    public Path getSourcePath() {
        if (StringUtils.isNotBlank((String)this.pathToWatch)) {
            return Paths.get(this.pathToWatch, new String[0]);
        }
        return null;
    }

    protected abstract boolean watchSubDirectories();

    protected abstract WatchEvent.Kind<?>[] getWatchEventKinds(Path var1);

    protected abstract void processWatchEvent(WatchEvent<?> var1, WatchEvent.Kind<?> var2, Path var3);
}

