/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.test.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.test.internal.java.MissingServiceAnalyzer;
import org.eclipse.smarthome.test.java.JavaTest;
import org.eclipse.smarthome.test.storage.VolatileStorageService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

@NonNullByDefault
public class JavaOSGiTest
extends JavaTest {
    private final Map<String, List<ServiceRegistration<?>>> registeredServices = new HashMap();
    @NonNullByDefault(value={})
    protected BundleContext bundleContext;

    @Before
    public void bindBundleContext() {
        this.bundleContext = this.initBundleContext();
        Assert.assertThat((Object)this.bundleContext, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    private @Nullable BundleContext initBundleContext() {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        if (bundle != null) {
            return bundle.getBundleContext();
        }
        return null;
    }

    private <T> @Nullable T unrefService(@Nullable ServiceReference<T> serviceReference) {
        if (serviceReference == null) {
            return null;
        }
        return (T)this.bundleContext.getService(serviceReference);
    }

    protected <T> @Nullable T getService(Class<T> clazz) {
        ServiceReference serviceReference = this.bundleContext.getServiceReference(clazz.getName());
        if (serviceReference == null) {
            new MissingServiceAnalyzer(System.out, this.bundleContext).printMissingServiceDetails(clazz);
            return null;
        }
        return this.unrefService(serviceReference);
    }

    protected <T> List<T> getServices(Class<T> clazz, Predicate<ServiceReference<T>> filter) {
        ServiceReference<@Nullable T>[] serviceReferences = this.getServices(clazz);
        if (serviceReferences == null) {
            new MissingServiceAnalyzer(System.out, this.bundleContext).printMissingServiceDetails(clazz);
            return Collections.emptyList();
        }
        return Arrays.stream(serviceReferences).filter(filter).map(this::unrefService).collect(Collectors.toList());
    }

    protected <T> @Nullable T getService(Class<T> clazz, Predicate<ServiceReference<T>> filter) {
        List<T> filteredServices = this.getServices(clazz, filter);
        return this.getSingleServiceInstance(clazz, filteredServices);
    }

    private <T, I extends T> @Nullable I getSingleServiceInstance(Class<T> clazz, List<I> filteredServices) {
        if (filteredServices.size() > 1) {
            Assert.fail((String)"More than 1 service matching the filter is registered.");
        }
        if (filteredServices.isEmpty()) {
            new MissingServiceAnalyzer(System.out, this.bundleContext).printMissingServiceDetails(clazz);
            return null;
        }
        return filteredServices.get(0);
    }

    private <T> ServiceReference<T> @Nullable [] getServices(Class<T> clazz) {
        try {
            ServiceReference[] serviceReferences = this.bundleContext.getServiceReferences(clazz.getName(), null);
            return serviceReferences;
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            throw new IllegalArgumentException("Invalid exception for a null filter");
        }
    }

    protected <T, I extends T> @Nullable I getService(Class<T> clazz, Class<I> implementationClass) {
        List<I> services = this.getServices(clazz, implementationClass);
        return this.getSingleServiceInstance(clazz, services);
    }

    protected <T, I extends T> List<I> getServices(Class<T> clazz, Class<I> implementationClass) {
        ServiceReference<@Nullable T>[] serviceReferences = this.getServices(clazz);
        if (serviceReferences == null) {
            new MissingServiceAnalyzer(System.out, this.bundleContext).printMissingServiceDetails(clazz);
            return Collections.emptyList();
        }
        return Arrays.stream(serviceReferences).map(this::unrefService).filter(implementationClass::isInstance).map(implementationClass::cast).collect(Collectors.toList());
    }

    protected ServiceRegistration<?> registerService(Object service) {
        return this.registerService(service, this.getInterfaceName(service), null);
    }

    protected ServiceRegistration<?> registerService(Object service, Dictionary<String, ?> properties) {
        return this.registerService(service, this.getInterfaceName(service), properties);
    }

    protected ServiceRegistration<?> registerService(Object service, String interfaceName) {
        return this.registerService(service, interfaceName, null);
    }

    protected ServiceRegistration<?> registerService(Object service, String interfaceName, @Nullable Dictionary<String, ?> properties) {
        Assert.assertThat((Object)interfaceName, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        ServiceRegistration srvReg = this.bundleContext.registerService(interfaceName, service, properties);
        this.saveServiceRegistration(interfaceName, srvReg);
        return srvReg;
    }

    private void saveServiceRegistration(String interfaceName, ServiceRegistration<?> srvReg) {
        List<ServiceRegistration<?>> regs = this.registeredServices.get(interfaceName);
        if (regs == null) {
            regs = new ArrayList();
            this.registeredServices.put(interfaceName, regs);
        }
        regs.add(srvReg);
    }

    protected ServiceRegistration<?> registerService(Object service, String[] interfaceNames, Dictionary<String, ?> properties) {
        Assert.assertThat((Object)interfaceNames, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        ServiceRegistration srvReg = this.bundleContext.registerService(interfaceNames, service, properties);
        String[] stringArray = interfaceNames;
        int n = interfaceNames.length;
        int n2 = 0;
        while (n2 < n) {
            String interfaceName = stringArray[n2];
            this.saveServiceRegistration(interfaceName, srvReg);
            ++n2;
        }
        return srvReg;
    }

    protected @Nullable ServiceRegistration<?> unregisterService(Object service) {
        return this.unregisterService(this.getInterfaceName(service));
    }

    protected @Nullable ServiceRegistration<?> unregisterService(String interfaceName) {
        ServiceRegistration<?> reg = null;
        List<ServiceRegistration<?>> regList = this.registeredServices.remove(interfaceName);
        if (regList != null) {
            reg = regList.get(0);
            regList.forEach(r -> r.unregister());
        }
        return reg;
    }

    protected String getInterfaceName(Object service) {
        Class<?>[] classes = service.getClass().getInterfaces();
        if (classes.length >= 1) {
            return classes[0].getName();
        }
        throw new IllegalArgumentException(String.format("The given reference (class: %s) does not implement an interface.", service.getClass()));
    }

    protected void registerVolatileStorageService() {
        this.registerService(new VolatileStorageService());
    }

    @After
    public void unregisterMocks() {
        this.registeredServices.forEach((interfaceName, services) -> services.forEach(service -> service.unregister()));
        this.registeredServices.clear();
    }
}

