/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.mwe.dynamic.internal;

import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ClassUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.mwe2.runtime.workflow.IWorkflowComponent;
import org.eclipse.emf.mwe2.runtime.workflow.Workflow;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.sphinx.emf.mwe.dynamic.WorkflowContributorRegistry;
import org.eclipse.sphinx.emf.mwe.dynamic.WorkspaceWorkflow;
import org.eclipse.sphinx.emf.mwe.dynamic.annotations.WorkflowParameter;
import org.eclipse.sphinx.emf.mwe.dynamic.internal.Activator;
import org.eclipse.sphinx.emf.mwe.dynamic.util.XtendUtil;
import org.eclipse.sphinx.jdt.loaders.ProjectClassLoader;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.sphinx.platform.util.StatusUtil;

public class WorkflowInstanceFactory {
    public Workflow createWorkflowInstance(Object workflow) throws CoreException {
        Class<Workflow> workflowClass;
        block4: {
            workflowClass = this.getWorkflowClass(workflow);
            if (workflowClass != null) break block4;
            return null;
        }
        try {
            return workflowClass.newInstance();
        }
        catch (CoreException ex) {
            throw ex;
        }
        catch (Exception ex) {
            IStatus status = StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
            throw new CoreException(status);
        }
    }

    public Workflow createWorkflowInstance(Object workflow, Map<String, Object> arguments) throws CoreException {
        Workflow workflowInstance = this.createWorkflowInstance(workflow);
        this.injectArguments(workflowInstance, arguments);
        return workflowInstance;
    }

    protected Class<Workflow> getWorkflowClass(Object workflow) throws CoreException {
        IType workflowType = this.getWorkflowType(workflow);
        if (workflowType != null) {
            return this.loadWorkflowClass(workflowType);
        }
        return this.doGetWorkflowClass(workflow);
    }

    protected Class<Workflow> doGetWorkflowClass(Object workflow) throws CoreException {
        if (workflow instanceof Class) {
            Class clazz = (Class)workflow;
            if (!Workflow.class.isAssignableFrom(clazz)) {
                IllegalStateException ex = new IllegalStateException("Workflow class '" + clazz.getName() + "' is not a subclass of " + Workflow.class.getName());
                IStatus status = StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
                throw new CoreException(status);
            }
            Class workflowClass = clazz;
            return workflowClass;
        }
        return null;
    }

    protected IType getWorkflowType(Object workflow) {
        IJavaElement workflowJavaElement;
        if (workflow instanceof IType) {
            return (IType)workflow;
        }
        if (workflow instanceof ICompilationUnit) {
            return ((ICompilationUnit)workflow).findPrimaryType();
        }
        if (workflow instanceof IFile && (workflowJavaElement = XtendUtil.getJavaElement((IFile)workflow)) instanceof ICompilationUnit) {
            return ((ICompilationUnit)workflowJavaElement).findPrimaryType();
        }
        return null;
    }

    protected Class<Workflow> loadWorkflowClass(IType workflowType) throws CoreException {
        Assert.isNotNull((Object)workflowType);
        try {
            if (!workflowType.isBinary()) {
                ProjectClassLoader projectClassLoader = new ProjectClassLoader(workflowType.getJavaProject());
                Class clazz = projectClassLoader.loadClass(workflowType.getFullyQualifiedName());
                if (!Workflow.class.isAssignableFrom(clazz)) {
                    throw new IllegalStateException("Workflow class '" + clazz.getName() + "' is not a subclass of " + Workflow.class.getName());
                }
                Class workflowClass = clazz;
                return workflowClass;
            }
            return WorkflowContributorRegistry.INSTANCE.loadContributedWorkflowClass(workflowType);
        }
        catch (CoreException ex) {
            throw ex;
        }
        catch (Exception ex) {
            IStatus status = StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
            throw new CoreException(status);
        }
    }

    public Map<String, Class<?>> getWorkflowParameters(Workflow workflowInstance) {
        Map<String, Class<?>> workflowParameters = this.doGetWorkflowParameters(workflowInstance.getClass());
        if (workflowInstance instanceof WorkspaceWorkflow) {
            List<IWorkflowComponent> children = ((WorkspaceWorkflow)workflowInstance).getChildren();
            for (IWorkflowComponent component : children) {
                workflowParameters.putAll(this.doGetWorkflowParameters(component.getClass()));
            }
        }
        return workflowParameters;
    }

    protected Map<String, Class<?>> doGetWorkflowParameters(Class<?> clazz) {
        LinkedHashMap workflowParameters = new LinkedHashMap();
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (this.isWorkflowParameter(field)) {
                String name = this.getWorkflowParameterName(field);
                workflowParameters.put(name, field.getType());
            }
            ++n2;
        }
        return workflowParameters;
    }

    protected boolean isWorkflowParameter(Field field) {
        Assert.isNotNull((Object)field);
        return field.getAnnotation(WorkflowParameter.class) != null;
    }

    protected String getWorkflowParameterName(Field parameterField) {
        Assert.isNotNull((Object)parameterField);
        Assert.isLegal((boolean)this.isWorkflowParameter(parameterField));
        WorkflowParameter annotation = parameterField.getAnnotation(WorkflowParameter.class);
        String value = annotation.value();
        return value != null && !value.isEmpty() ? value : parameterField.getName();
    }

    protected boolean isWorkflowParameterTypeAssignableFrom(Class<?> parameterType, Class<?> valueType) {
        if (parameterType.isPrimitive()) {
            return ClassUtils.isAssignable(parameterType, valueType, (boolean)true);
        }
        return parameterType.isAssignableFrom(valueType);
    }

    protected void setWorkflowParameterValue(Object object, Field parameterField, Object value) throws CoreException {
        Assert.isNotNull((Object)object);
        Assert.isNotNull((Object)parameterField);
        Assert.isLegal((boolean)this.isWorkflowParameter(parameterField));
        boolean oldAccessible = parameterField.isAccessible();
        parameterField.setAccessible(true);
        try {
            try {
                parameterField.set(object, value);
            }
            catch (Exception ex) {
                IStatus status = StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
                throw new CoreException(status);
            }
        }
        finally {
            parameterField.setAccessible(oldAccessible);
        }
    }

    public void injectArguments(Workflow workflowInstance, Map<String, Object> arguments) throws CoreException {
        Assert.isNotNull((Object)workflowInstance);
        this.doInjectArguments(workflowInstance, arguments);
        if (workflowInstance instanceof WorkspaceWorkflow) {
            List<IWorkflowComponent> children = ((WorkspaceWorkflow)workflowInstance).getChildren();
            for (IWorkflowComponent component : children) {
                this.doInjectArguments(component, arguments);
            }
        }
    }

    protected void doInjectArguments(Object object, Map<String, Object> arguments) throws CoreException {
        Class<?> clazz = object.getClass();
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            Object value;
            Field field = fieldArray[n2];
            if (this.isWorkflowParameter(field) && (value = arguments.get(name = this.getWorkflowParameterName(field))) != null) {
                if (this.isWorkflowParameterTypeAssignableFrom(field.getType(), value.getClass())) {
                    this.setWorkflowParameterValue(object, field, value);
                } else {
                    RuntimeException ex = new RuntimeException("Workflow argument '" + name + " : " + value.getClass().getName() + "' cannot be assigned to workflow parameter '" + field.getName() + " : " + field.getType().getName() + "'");
                    PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)ex);
                }
            }
            ++n2;
        }
    }
}

