/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.examples.hummingbird.metamodelgen.operations;

import java.util.regex.Matcher;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.sphinx.emf.metamodelgen.operations.AbstractGenerateFromEcoreOperation;
import org.eclipse.sphinx.emf.serialization.generators.xsd.Ecore2XSDGenerator;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.examples.hummingbird.metamodelgen.internal.messages.Messages;
import org.eclipse.sphinx.examples.hummingbird.metamodelgen.operations.GenerateXMLPersistenceMappingsOperation;

public class GenerateXSDOperation
extends AbstractGenerateFromEcoreOperation {
    public GenerateXSDOperation(IFile ecoreFile) {
        super(Messages.operation_generateXSD_label, ecoreFile);
    }

    public GenerateXSDOperation(String label, IFile ecoreFile) {
        super(label, ecoreFile);
    }

    public URI getXSDFileURI() {
        Matcher matcher = GenerateXMLPersistenceMappingsOperation.ORIGINAL_ECORE_FILE_BASE_NAME_PATTERN.matcher(this.ecoreFile.getName());
        String xsdFileBaseName = matcher.matches() ? matcher.group(1) : this.ecoreFile.getFullPath().removeFileExtension().lastSegment();
        IPath xsdPath = this.ecoreFile.getParent().getFullPath().append(xsdFileBaseName).addFileExtension("xsd");
        return EcorePlatformUtil.createURI((IPath)xsdPath);
    }

    public void generate(EPackage ecoreModel, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        monitor.setTaskName("Generating XSD schema");
        Ecore2XSDGenerator ecore2XSDGenerator = this.createEcore2XSDGenerator(ecoreModel);
        ecore2XSDGenerator.run(monitor);
    }

    protected Ecore2XSDGenerator createEcore2XSDGenerator(EPackage ecoreModel) {
        return new Ecore2XSDGenerator(this.getXSDFileURI(), ecoreModel);
    }
}

