/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.ui.fields;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.platform.messages.PlatformMessages;
import org.eclipse.sphinx.platform.ui.fields.IField;
import org.eclipse.sphinx.platform.ui.fields.IFieldListener;
import org.eclipse.sphinx.platform.ui.fields.messages.FieldsMessages;
import org.eclipse.sphinx.platform.ui.internal.util.LayoutUtil;
import org.eclipse.sphinx.platform.ui.widgets.IWidgetFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class BasicField
implements IField {
    protected static final int MAX_WITDH = 175;
    private ListenerList fFieldListeners = new ListenerList();
    private boolean fEnabled = true;
    protected boolean fUseFormLayout = false;
    protected IWidgetFactory fWidgetFactory;
    protected Control fLabelControl = null;
    protected String fLabelText = new String();

    public BasicField(IWidgetFactory widgetFactory) {
        this.fWidgetFactory = widgetFactory;
    }

    protected final boolean isOkToUse(Control control) {
        return control != null && Display.getCurrent() != null && !control.isDisposed();
    }

    private final void assertEnoughColumns(int nColumns) {
        String msg = NLS.bind((String)FieldsMessages.error_assert_LayoutNumberOfColumnsIsTooSmall, (Object)this.getNumberOfControls());
        Assert.isTrue((nColumns >= this.getNumberOfControls() ? 1 : 0) != 0, (String)msg);
    }

    protected final void assertCompositeNotNull(Composite composite) {
        Assert.isNotNull((Object)composite, (String)"uncreated control requested with composite null");
    }

    protected static final Composite createSpecificComposite(Composite parent, int nColumns, int span, boolean hgrab, boolean vgrab, boolean useFormLayout) {
        Object layout = useFormLayout ? LayoutUtil.tableWrapLayoutForSpecificComposite(nColumns) : LayoutUtil.gridLayoutForSpecificComposite(nColumns);
        Object data = useFormLayout ? LayoutUtil.tableWrapDataForSpecificComposite(span, hgrab, vgrab) : LayoutUtil.gridDataForSpecificComposite(span, hgrab, vgrab);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)layout);
        composite.setLayoutData(data);
        composite.setFont(parent.getFont());
        return composite;
    }

    protected static final Control createEmptySpace(Composite parent, int span) {
        Label label = new Label(parent, 16384);
        TableWrapData data = null;
        if (parent.getLayout() instanceof TableWrapLayout) {
            TableWrapData twd = new TableWrapData();
            twd.align = 2;
            twd.grabHorizontal = false;
            twd.colspan = span;
            twd.indent = 0;
            twd.maxWidth = 0;
            twd.heightHint = 0;
            data = twd;
        } else {
            GridData gd = new GridData();
            gd.horizontalAlignment = 1;
            gd.grabExcessHorizontalSpace = false;
            gd.horizontalSpan = span;
            gd.horizontalIndent = 0;
            gd.widthHint = 0;
            gd.heightHint = 0;
            data = gd;
        }
        label.setLayoutData((Object)data);
        return label;
    }

    public static final Control createEmptySpace(Composite parent) {
        return BasicField.createEmptySpace(parent, 1);
    }

    @Override
    public Control[] fillIntoGrid(Composite parent, int nColumns) {
        Assert.isNotNull((Object)parent, (String)NLS.bind((String)PlatformMessages.arg_mustNotBeNull, (Object)"parent"));
        Layout layout = parent.getLayout();
        Assert.isNotNull((Object)layout, (String)NLS.bind((String)PlatformMessages.error_mustNotBeNull, (Object)"layout"));
        this.fUseFormLayout = layout instanceof TableWrapLayout;
        this.assertEnoughColumns(nColumns);
        return this.doFillIntoGrid(parent, nColumns);
    }

    protected Control[] doFillIntoGrid(Composite parent, int nColumns) {
        Control label = this.getLabelControl(parent, 1);
        return new Control[]{label};
    }

    protected final Control getLabelControl(Composite parent, int hspan) {
        return this.getLabelControl(parent, false, hspan);
    }

    protected final Control getLabelControl(Composite parent, boolean multiLine, int hspan) {
        if (this.fLabelControl == null) {
            this.fLabelControl = this.createLabelControl(parent, multiLine, hspan);
            if (this.fUseFormLayout) {
                this.fLabelControl.setLayoutData((Object)LayoutUtil.tableWrapDataForLabel(hspan, multiLine));
            } else {
                this.fLabelControl.setLayoutData((Object)LayoutUtil.gridDataForLabel(hspan, multiLine));
            }
        }
        return this.fLabelControl;
    }

    protected Control createLabelControl(Composite parent, boolean multiLine, int hspan) {
        this.assertCompositeNotNull(parent);
        Label labelControl = null;
        if (this.fWidgetFactory != null) {
            labelControl = this.fWidgetFactory.createLabel(parent, this.fLabelText, multiLine, hspan, false);
        } else {
            labelControl = new Label(parent, 16448);
            if (this.fLabelText != null && !"".equals(this.fLabelText)) {
                labelControl.setText(this.fLabelText);
            } else {
                labelControl.setText(".");
                labelControl.setVisible(false);
            }
        }
        labelControl.setFont(parent.getFont());
        labelControl.setEnabled(this.fEnabled);
        return labelControl;
    }

    @Override
    public Control getLabelControl() {
        Control control = null;
        if (this.isOkToUse(this.fLabelControl)) {
            control = this.fLabelControl;
        }
        return control;
    }

    protected int getNumberOfControls() {
        return 1;
    }

    @Override
    public void setLabelText(String labeltext) {
        this.fLabelText = labeltext;
        if (this.isOkToUse(this.fLabelControl) && this.fLabelControl instanceof Label) {
            ((Label)this.fLabelControl).setText(labeltext);
        }
    }

    @Override
    public void setToolTipText(String toolTip) {
        if (this.isOkToUse(this.fLabelControl)) {
            this.fLabelControl.setToolTipText(toolTip);
        }
    }

    @Override
    public final boolean isEnabled() {
        return this.fEnabled;
    }

    @Override
    public final void setEnabled(boolean enabled) {
        if (enabled != this.fEnabled) {
            this.fEnabled = enabled;
            this.updateEnableState();
        }
    }

    protected void updateEnableState() {
        if (this.fLabelControl != null) {
            this.fLabelControl.setEnabled(this.fEnabled);
        }
    }

    @Override
    public void dispose() {
        if (this.isOkToUse(this.fLabelControl)) {
            this.fLabelControl.dispose();
        }
    }

    protected boolean setFocus() {
        return false;
    }

    @Override
    public final void addFieldListener(IFieldListener listener) {
        this.fFieldListeners.add((Object)listener);
    }

    @Override
    public void removeFieldListener(IFieldListener listener) {
        this.fFieldListeners.remove((Object)listener);
    }

    protected void dialogFieldChanged() {
        Object[] objectArray = this.fFieldListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IFieldListener)listener).dialogFieldChanged(this);
            ++n2;
        }
    }

    public void refresh() {
        this.updateEnableState();
    }
}

