/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.markers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.validation.Activator;
import org.eclipse.sphinx.emf.validation.diagnostic.ExtendedDiagnostic;
import org.eclipse.sphinx.emf.validation.markers.IValidationProblemMarkersChangeListener;
import org.eclipse.sphinx.emf.validation.markers.util.FeatureAttUtil;
import org.eclipse.sphinx.emf.validation.stats.ValidationPerformanceStats;
import org.eclipse.sphinx.emf.validation.util.Messages;
import org.eclipse.sphinx.emf.validation.util.ValidationUtil;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public class ValidationMarkerManager {
    private static ValidationMarkerManager markerManager = null;
    protected ListenerList validationProblemMarkersChangeListenerList = new ListenerList();

    public static ValidationMarkerManager getInstance() {
        if (markerManager == null) {
            markerManager = new ValidationMarkerManager();
        }
        return markerManager;
    }

    private ValidationMarkerManager() {
    }

    public void addMarkers(Resource resource, Diagnostic diagnostic) throws CoreException {
        Assert.isNotNull((Object)resource);
        Assert.isNotNull((Object)diagnostic);
        ArrayList<IMarker> markerResultList = new ArrayList<IMarker>();
        IFile iResource = EcorePlatformUtil.getFile((Resource)resource);
        if (iResource == null || !iResource.exists()) {
            return;
        }
        List diagnosticData = diagnostic.getData();
        if (diagnosticData == null || diagnosticData.size() == 0) {
            return;
        }
        int max_err = Platform.getPreferencesService().getInt("org.eclipse.sphinx.emf.validation", "pref_max_number_of_errors", 10000, null);
        IMarker[] markers = iResource.getWorkspace().getRoot().findMarkers("sphinx.emf.validation.problem.marker", true, 2);
        int nb_err = markers.length;
        int to_be_added = 0;
        for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
            if (childDiagnostic.getData().isEmpty()) continue;
            ++to_be_added;
        }
        if (max_err > 0 && nb_err + to_be_added > max_err) {
            int nb_removed = 0;
            Arrays.sort(markers, new Comparator<IMarker>(){

                @Override
                public int compare(IMarker o1, IMarker o2) {
                    try {
                        return Long.valueOf(o1.getCreationTime()).compareTo(o2.getCreationTime());
                    }
                    catch (CoreException coreException) {
                        return 0;
                    }
                }
            });
            int remove_threshold = (nb_err > max_err ? nb_err : max_err) / 2;
            int i = 0;
            while (i < markers.length && nb_err + to_be_added > max_err) {
                markers[i].delete();
                --nb_err;
                if (++nb_removed >= remove_threshold) break;
                ++i;
            }
        }
        EObject validatedObject = (EObject)diagnosticData.get(0);
        try {
            int markerSeverity = 0;
            for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                if (max_err > 0 && nb_err > max_err) break;
                if (childDiagnostic.getData().isEmpty()) continue;
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                IMarker marker = iResource.createMarker("sphinx.emf.validation.problem.marker");
                ++nb_err;
                EObject tgtObject = (EObject)childDiagnostic.getData().get(0);
                attributes.put("uri", EcoreUtil.getURI((EObject)tgtObject).toString());
                attributes.put("hash_code", tgtObject.hashCode());
                int severity = childDiagnostic.getSeverity();
                markerSeverity = severity < 2 ? 0 : (severity < 4 ? 1 : 2);
                attributes.put("severity", markerSeverity);
                String message = childDiagnostic.getMessage();
                if (message == null) {
                    message = Messages.noMessageAvailableForThisMarker;
                }
                attributes.put("message", message);
                EObject eTgt = (EObject)childDiagnostic.getData().get(0);
                if (childDiagnostic instanceof ExtendedDiagnostic) {
                    String ruleId = ((ExtendedDiagnostic)childDiagnostic).getConstraintId();
                    Set<String> features = FeatureAttUtil.getRulesFeaturesForEObj(ruleId, eTgt);
                    String packedFeaturesStr = FeatureAttUtil.packFeaturesAsString(marker, features);
                    attributes.put("features_id", packedFeaturesStr);
                    attributes.put("rule_id", ruleId);
                }
                marker.setAttributes(attributes);
                markerResultList.add(marker);
            }
            this.fireValidationProblemMarkersChanged(validatedObject);
        }
        catch (CoreException coreException) {
            PlatformLogUtil.logAsWarning((Plugin)Activator.getDefault(), (Object)NLS.bind((String)Messages.warningProblemWithMarkerOperationOnResource, (Object)iResource.getLocationURI().toString()));
        }
    }

    private void removeSphinxValidationProblemMarker(IResource resource) throws CoreException {
        Assert.isNotNull((Object)resource);
        resource.deleteMarkers("sphinx.emf.validation.problem.marker", true, 2);
    }

    private void removeXMLIntegrityProblemMarker(IResource resource) throws CoreException {
        Assert.isNotNull((Object)resource);
        resource.deleteMarkers("org.eclipse.sphinx.emf.xmlintegrityproblemmarker", true, 2);
    }

    private void removeXSDDiagnosticMarker(IResource resource) throws CoreException {
        Assert.isNotNull((Object)resource);
        resource.deleteMarkers("org.eclipse.sphinx.emf.xmlvalidityproblemmarker", true, 2);
    }

    private void removeXMLWellFormednessProblemMarker(IResource resource) throws CoreException {
        Assert.isNotNull((Object)resource);
        resource.deleteMarkers("org.eclipse.sphinx.emf.xmlwellformednessproblemmarker", true, 2);
    }

    public void removeMarkers(EObject eObject, int depth) throws CoreException {
        this.removeMarkers(eObject, depth, "sphinx.emf.validation.problem.marker");
    }

    public void removeMarkers(EObject eObject, int depth, String markerType) throws CoreException {
        EObject rootObject;
        IFile file = EcorePlatformUtil.getFile((EObject)eObject);
        Resource resource = eObject.eResource();
        if (resource != null && resource.getContents() != null && resource.getContents().size() >= 1 && (rootObject = (EObject)resource.getContents().get(0)) == eObject && depth == 2) {
            this.removeSphinxValidationProblemMarker((IResource)file);
            this.removeXMLWellFormednessProblemMarker((IResource)file);
            this.removeXSDDiagnosticMarker((IResource)file);
            this.removeXMLIntegrityProblemMarker((IResource)file);
            this.fireValidationProblemMarkersChanged(rootObject);
            return;
        }
        IMarker[] markers = this.getValidationMarkersList(eObject, depth, markerType);
        if (markers == null || markers.length == 0) {
            return;
        }
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            marker.delete();
            ++n2;
        }
        this.fireValidationProblemMarkersChanged(eObject);
    }

    public void modifyMarkersURI(IResource resource, String oldUri, String newUri) throws CoreException {
        if (resource == null) {
            return;
        }
        String[] oldInfo = ValidationUtil.splitURI(oldUri);
        String[] newInfo = ValidationUtil.splitURI(newUri);
        if (oldInfo != null && oldInfo.length == 2 && newInfo != null && newInfo.length == 2) {
            IMarker[] markers = resource.findMarkers("sphinx.emf.validation.problem.marker", true, 2);
            if (markers == null || markers.length == 0) {
                return;
            }
            String currentUri = null;
            try {
                IMarker[] iMarkerArray = markers;
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    currentUri = marker.getAttribute("uri", "--");
                    if (currentUri.contains(oldInfo[0])) {
                        String newURI = currentUri.replace(oldInfo[0], newInfo[0]);
                        marker.setAttribute("uri", (Object)newURI);
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {
                PlatformLogUtil.logAsWarning((Plugin)Activator.getDefault(), (Object)NLS.bind((String)Messages.warningProblemWithMarkerOperationOnResource, (Object)resource.getLocationURI().toString()));
            }
        }
    }

    public void updateMarkersURI(IResource resource) throws CoreException {
        if (resource.isAccessible()) {
            block13: {
                ValidationPerformanceStats.INSTANCE.startNewEvent(ValidationPerformanceStats.ValidationEvent.EVENT_UPDATE_PROBLEM_MARKERS, resource.getFullPath());
                IMarker[] markers = resource.findMarkers("sphinx.emf.validation.problem.marker", true, 2);
                String workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
                String currentUri = null;
                String fragment = null;
                String newURIPath = resource.getLocation().toString().replace(workspacePath, "platform:/resource");
                ISchedulingRule rule = ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule(resource);
                Workspace workspace = (Workspace)resource.getWorkspace();
                try {
                    try {
                        workspace.prepareOperation(rule, null);
                        workspace.beginOperation(true);
                        IMarker[] iMarkerArray = markers;
                        int n = markers.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMarker marker = iMarkerArray[n2];
                            currentUri = marker.getAttribute("uri", "#");
                            fragment = currentUri.substring(currentUri.lastIndexOf("#"));
                            marker.setAttribute("uri", (Object)(String.valueOf(newURIPath) + fragment));
                            ++n2;
                        }
                    }
                    catch (CoreException coreException) {
                        PlatformLogUtil.logAsWarning((Plugin)Activator.getDefault(), (Object)NLS.bind((String)Messages.warningProblemWithMarkerOperationOnResource, (Object)resource.getLocationURI().toString()));
                        try {
                            workspace.endOperation(rule, false, null);
                        }
                        catch (CoreException coreException2) {
                            PlatformLogUtil.logAsWarning((Plugin)Activator.getDefault(), (Object)Messages.warningProblemWithWorkspaceOperation);
                        }
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        workspace.endOperation(rule, false, null);
                    }
                    catch (CoreException coreException) {
                        PlatformLogUtil.logAsWarning((Plugin)Activator.getDefault(), (Object)Messages.warningProblemWithWorkspaceOperation);
                    }
                    throw throwable;
                }
                try {
                    workspace.endOperation(rule, false, null);
                }
                catch (CoreException coreException) {
                    PlatformLogUtil.logAsWarning((Plugin)Activator.getDefault(), (Object)Messages.warningProblemWithWorkspaceOperation);
                }
            }
            ValidationPerformanceStats.INSTANCE.endEvent(ValidationPerformanceStats.ValidationEvent.EVENT_UPDATE_PROBLEM_MARKERS, resource.getFullPath());
        }
    }

    public IMarker[] getValidationMarkersList(EObject eObject, int depth) throws CoreException {
        return this.getValidationMarkersList(eObject, depth, "sphinx.emf.validation.problem.marker");
    }

    /*
     * Unable to fully structure code
     */
    public IMarker[] getValidationMarkersList(EObject eObject, int depth, String markerType) throws CoreException {
        resource = EcorePlatformUtil.getFile((EObject)eObject);
        if (resource == null || !resource.exists()) {
            return new IMarker[0];
        }
        allMarkers = resource.findMarkers(markerType, true, 2);
        tmp = ValidationUtil.splitURI(eObject);
        if (tmp == null || tmp.length < 2) {
            return new IMarker[0];
        }
        eObjURI = tmp[0];
        eObjType = tmp[1];
        result = new ArrayList<IMarker>();
        var15_10 = allMarkers;
        var14_11 = allMarkers.length;
        var13_12 = 0;
        while (var13_12 < var14_11) {
            block13: {
                block12: {
                    current = var15_10[var13_12];
                    if (current == null || !current.exists()) break block12;
                    tmp = ValidationUtil.splitURI((String)current.getAttribute("uri"));
                    if (tmp == null || tmp.length != 2) break block13;
                    markerURI = tmp[0];
                    markerEObjType = tmp[1];
                    hash = current.getAttribute("hash_code");
                    switch (depth) {
                        case 0: {
                            if (markerURI.equals(eObjURI) && eObjType.equals(markerEObjType) && ((Integer)hash).intValue() == eObject.hashCode()) {
                                result.add(current);
                                ** break;
                            }
                            break block13;
                        }
                        case 1: {
                            shouldbeDeleted = true;
                            if (shouldbeDeleted &= markerURI.contains(eObjURI)) {
                                subPart = markerURI.substring(eObjURI.length());
                                shouldbeDeleted &= subPart.indexOf(47) == subPart.lastIndexOf(47);
                            }
                            if (shouldbeDeleted) {
                                result.add(current);
                                ** break;
                            }
                            break block13;
                        }
                        case 2: {
                            if (markerURI.contains(eObjURI)) {
                                result.add(current);
                                ** break;
                            }
                            break block13;
                        }
                    }
lbl46:
                    // 4 sources

                    break block13;
                }
                msg = NLS.bind((String)Messages.warningNoSuchMarker, (Object)(current == null ? "???" : Long.valueOf(current.getId())));
                PlatformLogUtil.logAsWarning((Plugin)Activator.getDefault(), (Object)msg);
            }
            ++var13_12;
        }
        return result.toArray(new IMarker[result.size()]);
    }

    public boolean isError(IMarker[] markers) {
        return this.isCodePresent(2, markers);
    }

    public boolean isWarning(IMarker[] markers) {
        return this.isCodePresent(1, markers);
    }

    public boolean isCodePresent(int status, IMarker[] markers) {
        boolean result = false;
        int i = -1;
        int len = markers.length;
        while (++i < len) {
            if (markers[i].getAttribute("severity", -1) != status) continue;
            result = true;
            break;
        }
        return result;
    }

    public int getUpperSeverity(IMarker[] markers) {
        int currentSeverity = -1;
        int i = -1;
        int len = markers.length;
        while (++i < len) {
            if (markers[i].getAttribute("severity", -1) > currentSeverity) {
                currentSeverity = markers[i].getAttribute("severity", -1);
            }
            if (currentSeverity == 2) break;
        }
        return currentSeverity;
    }

    public int getEObjectErrorStatus(EObject eObject, int depth) throws CoreException {
        IMarker[] markers = this.getValidationMarkersList(eObject, depth, "sphinx.emf.validation.problem.marker");
        return this.getUpperSeverity(markers);
    }

    public void handleDiagnostic(Diagnostic diagnostic) {
        this.handleDiagnostic(diagnostic, 2);
    }

    public void handleDiagnostic(Diagnostic diagnostic, int depth) {
        Assert.isNotNull((Object)diagnostic);
        if (diagnostic.getData() == null) {
            return;
        }
        List diagnosticData = diagnostic.getData();
        if (diagnosticData.isEmpty() || !(diagnosticData.get(0) instanceof EObject)) {
            return;
        }
        EObject eObject = (EObject)diagnosticData.get(0);
        if (diagnostic.getSeverity() == 0) {
            try {
                markerManager.removeMarkers(eObject, depth);
            }
            catch (CoreException ex) {
                PlatformLogUtil.logAsWarning((Plugin)Activator.getDefault(), (Object)((Object)ex));
            }
        } else {
            Resource resource = eObject.eResource();
            if (resource != null) {
                try {
                    markerManager.removeMarkers(eObject, depth);
                    markerManager.addMarkers(resource, diagnostic);
                }
                catch (CoreException ex) {
                    PlatformLogUtil.logAsWarning((Plugin)Activator.getDefault(), (Object)((Object)ex));
                }
            }
        }
    }

    public void addValidationProblemMarkersChangeListener(IValidationProblemMarkersChangeListener listener) {
        this.validationProblemMarkersChangeListenerList.add((Object)listener);
    }

    public void removeValidationProblemMarkersChangeListener(IValidationProblemMarkersChangeListener listener) {
        this.validationProblemMarkersChangeListenerList.remove((Object)listener);
    }

    protected void fireValidationProblemMarkersChanged(EObject object) {
        Object[] objectArray = this.validationProblemMarkersChangeListenerList.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            if (listener instanceof IValidationProblemMarkersChangeListener) {
                ((IValidationProblemMarkersChangeListener)listener).validationProblemMarkersChanged(new EventObject(object));
            }
            ++n2;
        }
    }
}

