/**
 * <copyright>
 * 
 * Copyright (c) 2014 itemis and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     itemis - Initial API and implementation
 *     itemis - [436112] Rework XML Persistence Mapping & XSD generation menu items to make them less prominent in the Eclipse UI
 * 
 * </copyright>
 */
package org.eclipse.sphinx.emf.serialization.generators.xsd;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.sphinx.emf.serialization.generators.xsd.Ecore2XSDConverter;
import org.eclipse.sphinx.emf.serialization.generators.xsd.Ecore2XSDFactory;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class Ecore2XSDGenerator {
  protected EPackage ecoreModel;
  
  protected Ecore2XSDFactory xsdFactory;
  
  protected XSDSchema xsdSchema;
  
  protected URI xsdFileURI;
  
  public Ecore2XSDGenerator(final URI xsdFileURI, final EPackage ecoreModel) {
    this.xsdFileURI = xsdFileURI;
    this.ecoreModel = ecoreModel;
  }
  
  public void run(final IProgressMonitor monitor) {
    final SubMonitor progress = SubMonitor.convert(monitor, 100);
    boolean _isCanceled = progress.isCanceled();
    if (_isCanceled) {
      throw new OperationCanceledException();
    }
    final ResourceSet resourceSet = new ResourceSetImpl();
    this.xsdFactory = this.createEcore2XSDFactory();
    this.xsdSchema = this.xsdFactory.initSchema(this.ecoreModel, resourceSet, monitor);
    final Ecore2XSDConverter converter = this.createEcore2XSDConverter(this.xsdFactory, this.xsdSchema);
    this.xsdSchema = converter.doConvertRMFPackageSchema2(this.ecoreModel, progress.newChild(90));
    this.refineXSDSchemaNamespace(progress.newChild(5));
    this.saveSchema(this.xsdFileURI, this.xsdSchema, resourceSet);
  }
  
  public void saveSchema(final URI xsdFileURI, final XSDSchema xsdSchema, final ResourceSet resourceSet) {
    try {
      Resource resource = resourceSet.createResource(xsdFileURI);
      resource.getContents().add(xsdSchema);
      resource.save(null);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  protected Ecore2XSDConverter createEcore2XSDConverter(final Ecore2XSDFactory xsdFactory, final XSDSchema xsdSchema) {
    return new Ecore2XSDConverter(xsdFactory, xsdSchema);
  }
  
  protected Ecore2XSDFactory createEcore2XSDFactory() {
    return new Ecore2XSDFactory(this.ecoreModel);
  }
  
  /**
   * Change the namespace to the global namespace.
   * This method can be overriden by custom
   */
  protected void refineXSDSchemaNamespace(final IProgressMonitor monitor) {
  }
}
