/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.ui.refactoring.participant;

import com.google.inject.Inject;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.common.types.access.jdt.TypeURIHelper;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;

public class JvmElementFinder {
    @Inject
    private IJvmTypeProvider.Factory typeProviderFactory;
    @Inject
    private TypeURIHelper typeURIHelper;
    @Inject
    private IResourceDescriptions resourceDescriptions;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;

    public EObject getCorrespondingJvmElement(IJavaElement javaElement, ResourceSet resourceSet) {
        this.typeProviderFactory.findOrCreateTypeProvider(resourceSet);
        URI jvmElementURI = this.typeURIHelper.getFullURI(javaElement);
        return jvmElementURI != null ? resourceSet.getEObject(jvmElementURI, true) : null;
    }

    public EObject findJvmElementDeclarationInIndex(EObject jvmElement, IProject project, ResourceSet resourceSet) {
        Iterator exportedObjects;
        JvmType type = (JvmType)EcoreUtil2.getContainerOfType((EObject)jvmElement, JvmType.class);
        if (type == null) {
            return null;
        }
        QualifiedName qualifiedName = this.qualifiedNameProvider.getFullyQualifiedName((EObject)type);
        if (qualifiedName != null && (exportedObjects = this.resourceDescriptions.getExportedObjects(type.eClass(), qualifiedName, false).iterator()).hasNext()) {
            URI eObjectURI = ((IEObjectDescription)exportedObjects.next()).getEObjectURI();
            EObject eObject = resourceSet.getEObject(eObjectURI, true);
            if (type != jvmElement) {
                TreeIterator contents = eObject.eAllContents();
                QualifiedName nameOfActualElement = this.qualifiedNameProvider.getFullyQualifiedName(jvmElement);
                while (contents.hasNext()) {
                    EObject next = (EObject)contents.next();
                    if (!jvmElement.eClass().isInstance((Object)next) || !nameOfActualElement.equals((Object)this.qualifiedNameProvider.getFullyQualifiedName(next))) continue;
                    return next;
                }
            }
            return eObject;
        }
        return null;
    }
}

