/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.patch;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.core.patch.DiffProject;
import org.eclipse.compare.internal.core.patch.FileDiffResult;
import org.eclipse.compare.internal.core.patch.FilePatch2;
import org.eclipse.compare.internal.core.patch.HunkResult;
import org.eclipse.compare.internal.patch.HunkDiffNode;
import org.eclipse.compare.internal.patch.PatchFileDiffNode;
import org.eclipse.compare.internal.patch.PatchProjectDiffNode;
import org.eclipse.compare.internal.patch.WorkspaceFileDiffResult;
import org.eclipse.compare.internal.patch.WorkspacePatcher;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;

public class PatchWorkspace
extends DiffNode
implements IAdaptable {
    private WorkspacePatcher patcher;

    public PatchWorkspace(WorkspacePatcher patcher) {
        super(null, 0);
        this.patcher = patcher;
    }

    public WorkspacePatcher getPatcher() {
        return this.patcher;
    }

    public IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public String getName() {
        return "Patch Root Workspace";
    }

    public IDiffContainer getParent() {
        return null;
    }

    public IDiffElement[] getChildren() {
        IDiffElement[] children = this.getPatcher().isWorkspacePatch() ? this.processProjects(this.getPatcher().getDiffProjects()) : this.processDiffs(this.getPatcher().getDiffs());
        return children;
    }

    private IDiffElement[] processDiffs(FilePatch2[] diffs) {
        ArrayList<IDiffElement> result = new ArrayList<IDiffElement>();
        int i = 0;
        while (i < diffs.length) {
            result.addAll(this.processDiff(diffs[i], this));
            ++i;
        }
        return result.toArray(new IDiffElement[result.size()]);
    }

    private IDiffElement[] processProjects(DiffProject[] diffProjects) {
        ArrayList<PatchProjectDiffNode> result = new ArrayList<PatchProjectDiffNode>();
        int i = 0;
        while (i < diffProjects.length) {
            PatchProjectDiffNode projectNode = new PatchProjectDiffNode((IDiffContainer)this, diffProjects[i], this.getPatcher().getConfiguration());
            result.add(projectNode);
            FilePatch2[] diffs = diffProjects[i].getFileDiffs();
            int j = 0;
            while (j < diffs.length) {
                FilePatch2 fileDiff = diffs[j];
                this.processDiff(fileDiff, (DiffNode)projectNode);
                ++j;
            }
            ++i;
        }
        return result.toArray(new IDiffElement[result.size()]);
    }

    private List<IDiffElement> processDiff(FilePatch2 diff, DiffNode parent) {
        ArrayList<IDiffElement> result = new ArrayList<IDiffElement>();
        FileDiffResult diffResult = this.getPatcher().getDiffResult(diff);
        PatchFileDiffNode node = new PatchFileDiffNode(diffResult, (IDiffContainer)parent, PatchFileDiffNode.getKind((FileDiffResult)diffResult), PatchFileDiffNode.getAncestorElement((FileDiffResult)diffResult), PatchWorkspace.getLeftElement(diffResult), PatchFileDiffNode.getRightElement((FileDiffResult)diffResult));
        result.add((IDiffElement)node);
        HunkResult[] hunkResults = diffResult.getHunkResults();
        int i = 0;
        while (i < hunkResults.length) {
            HunkResult hunkResult = hunkResults[i];
            new HunkDiffNode(hunkResult, node, 3, HunkDiffNode.getAncestorElement((HunkResult)hunkResult, (boolean)false), PatchWorkspace.getLeftElement(hunkResult), HunkDiffNode.getRightElement((HunkResult)hunkResult, (boolean)false));
            ++i;
        }
        return result;
    }

    private static ITypedElement getLeftElement(final FileDiffResult result) {
        return new LocalResourceTypedElement((IResource)((WorkspaceFileDiffResult)result).getTargetFile()){

            public String getName() {
                return result.getTargetPath().toString();
            }
        };
    }

    private static ITypedElement getLeftElement(final HunkResult result) {
        return new LocalResourceTypedElement((IResource)((WorkspaceFileDiffResult)result.getDiffResult()).getTargetFile()){

            public String getName() {
                return result.getHunk().getLabel();
            }
        };
    }

    public <T> T getAdapter(Class<T> adapter) {
        return (T)Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

