/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.jobs.simulation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.stem.core.CorePlugin;
import org.eclipse.stem.core.graph.GraphPartitioner;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.scenario.Scenario;
import org.eclipse.stem.core.scenario.ScenarioInitializationException;
import org.eclipse.stem.core.scenario.impl.ScenarioImpl;
import org.eclipse.stem.core.scenario.provider.ScenarioItemProviderAdapterFactory;
import org.eclipse.stem.core.sequencer.Sequencer;
import org.eclipse.stem.core.solver.Solver;
import org.eclipse.stem.core.solver.SolverException;
import org.eclipse.stem.jobs.Activator;
import org.eclipse.stem.jobs.DisplaySafeExecutor;
import org.eclipse.stem.jobs.execution.Executable;
import org.eclipse.stem.jobs.execution.IBaseListener;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationListener;
import org.eclipse.stem.jobs.simulation.ISimulationListenerSync;
import org.eclipse.stem.jobs.simulation.Messages;
import org.eclipse.stem.jobs.simulation.SimulationEvent;
import org.eclipse.stem.jobs.simulation.SimulationListenerJob;
import org.eclipse.stem.jobs.simulation.SimulationListenerUIJob;
import org.eclipse.stem.jobs.simulation.SimulationState;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class Simulation
extends Executable
implements ISimulation,
IPropertyChangeListener {
    public final String DEFAULT_SOLVER_CLASS = "org.eclipse.stem.solvers.fd.impl.FiniteDifferenceImpl";
    private final List<ISimulationListener> listeners = new CopyOnWriteArrayList<ISimulationListener>();
    private final List<ISimulationListenerSync> listenersSync = new CopyOnWriteArrayList<ISimulationListenerSync>();
    private Map<String, SimulationListenerJob> listenerJobs = new HashMap<String, SimulationListenerJob>();
    private Map<String, SimulationListenerJob> listenerJobsSync = new HashMap<String, SimulationListenerJob>();
    public boolean simulationSleep = true;
    private int sleepMilliseconds = 0;
    private SimulationState simulationState;
    private Scenario scenario = null;
    private Adapter adapter = null;
    private GraphPartitioner partitioner;
    private boolean keepRunning = true;
    private boolean reset = false;
    private boolean stepping = false;
    private boolean stopping = false;
    ScenarioItemProviderAdapterFactory scenarioItemProviderAdapterFactory = new ScenarioItemProviderAdapterFactory();

    public Simulation(String title, int sequenceNumber) {
        super(title == null ? "" : title, sequenceNumber);
        this.simulationState = SimulationState.PAUSED;
    }

    public Simulation(Scenario scenario, int sequenceNumber, GraphPartitioner p) {
        this(scenario.produceTitle(), sequenceNumber);
        this.scenario = scenario;
        this.partitioner = p;
        this.setPreferences();
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected void setPreferences() {
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        this.simulationSleep = preferenceStore.getBoolean("cyclePause");
        this.sleepMilliseconds = preferenceStore.getInt("cyclePauseMilliSeconds");
        ScenarioImpl.reportEachUnresolvedIdentifiable = preferenceStore.getBoolean("reportEachUnresolvedIdentifiable");
        ScenarioImpl.reportDanglingAirTransportEdges = preferenceStore.getBoolean("reportDanglingAirTransportEdges");
        ScenarioImpl.reportNumberofUnresolvedIdentifiables = preferenceStore.getBoolean("reportNumberOfUnresolvedIdentifiable");
    }

    @Override
    public final SimulationState getSimulationState() {
        return this.simulationState;
    }

    private final void setSimulationState(SimulationState simulationState) {
        this.simulationState = simulationState;
        if (DisplaySafeExecutor.isRunningOnUIThread()) {
            new SimulationStateChangeJob(simulationState).schedule();
        } else {
            this.fireSimulationChanged(simulationState);
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus retValue = Status.OK_STATUS;
        try {
            this.setSimulationState(SimulationState.RUNNING);
            this.keepRunning = true;
            if (this.reset) {
                this.scenario.reset();
                this.reset = false;
            }
            assert (this.scenario.sane());
            monitor.beginTask(this.scenario.produceTitle(), 100);
            Sequencer sequencer = this.scenario.getSequencer();
            monitor.worked((int)sequencer.getWorkComplete());
            if (this.scenario.getSolver() == null) {
                Solver[] solvers;
                Solver[] solverArray = solvers = this.getSolvers();
                int n = solvers.length;
                int n2 = 0;
                while (n2 < n) {
                    Solver s = solverArray[n2];
                    if (s.getClass().getName().equals("org.eclipse.stem.solvers.fd.impl.FiniteDifferenceImpl")) {
                        this.scenario.setSolver(s);
                        break;
                    }
                    ++n2;
                }
            }
            this.scenario.getSolver().setPartitioner(this.partitioner);
            if (!sequencer.isTimeToStop()) {
                while (this.keepRunning && !this.reset) {
                    STEMTime currentTime = sequencer.getCurrentTime();
                    monitor.subTask(currentTime.toString());
                    if (this.scenario.getCanonicalGraph() == null) {
                        this.scenario.initialize();
                    }
                    this.scenario.getSolver().setCanonicalGraph(this.scenario.getCanonicalGraph());
                    boolean success = this.scenario.step();
                    if (!success) {
                        this.keepRunning = false;
                        retValue = Status.CANCEL_STATUS;
                    }
                    assert (this.scenario.sane());
                    monitor.worked(sequencer.getWorkIncrement());
                    if (sequencer.isTimeToStop()) {
                        this.keepRunning = false;
                        retValue = Status.OK_STATUS;
                    } else if (monitor.isCanceled()) {
                        this.keepRunning = false;
                        retValue = Status.CANCEL_STATUS;
                    } else if (this.stepping) {
                        this.keepRunning = false;
                    }
                    this.setSimulationState(SimulationState.COMPLETED_CYCLE);
                    if (!this.simulationSleep || !this.keepRunning) continue;
                    try {
                        Thread.sleep(this.sleepMilliseconds);
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                }
                if (sequencer.isTimeToStop() && retValue == Status.OK_STATUS) {
                    this.setSimulationState(SimulationState.COMPLETED_SEQUENCE);
                }
            } else {
                Activator.logInformation(MessageFormat.format(Messages.getString("Sim.Time_Error"), sequencer.getCurrentTime().toString(), sequencer.getEndTime().toString()), null);
            }
            if (this.reset) {
                this.scenario.reset();
                this.reset = false;
                this.setSimulationState(SimulationState.RESET);
            }
            monitor.done();
        }
        catch (ScenarioInitializationException sie) {
            Simulation.handleException(sie, true);
            this.keepRunning = false;
            this.stopping = true;
        }
        catch (SolverException se) {
            Simulation.handleException(se, true);
            this.keepRunning = false;
            this.stopping = true;
        }
        this.setSimulationState(this.stopping ? SimulationState.STOPPED : SimulationState.PAUSED);
        return retValue;
    }

    @Override
    public final void run() {
        this.stepping = false;
        this.schedule();
    }

    @Override
    public final void pause() {
        this.keepRunning = false;
    }

    @Override
    public final void reset() throws ScenarioInitializationException {
        this.reset = true;
        this.stepping = false;
        if (this.getSimulationState().equals((Object)SimulationState.PAUSED)) {
            this.scenario.reset();
            this.reset = false;
            this.setSimulationState(SimulationState.RESET);
            this.setSimulationState(SimulationState.PAUSED);
        }
    }

    @Override
    public final void step() {
        this.stepping = true;
        this.schedule();
    }

    @Override
    public final void stop() {
        this.stopping = true;
        this.keepRunning = false;
        this.setSimulationState(SimulationState.STOPPED);
    }

    @Override
    public boolean isRunning() {
        return !this.simulationState.equals((Object)SimulationState.PAUSED);
    }

    @Override
    public final Scenario getScenario() {
        return this.scenario;
    }

    protected final void setScenario(Scenario scenario) {
        this.scenario = scenario;
    }

    @Override
    public void addSimulationListener(ISimulationListener listener) {
        this.addSimulationListener(listener, false);
    }

    @Override
    public void addSimulationListenerSync(ISimulationListenerSync listener) {
        this.addSimulationListenerSync(listener, false);
    }

    @Override
    public void addSimulationListener(ISimulationListener listener, boolean headlessSafe) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
            this.createSimulationListenerJobs(listener, false, headlessSafe);
        }
    }

    @Override
    public void addSimulationListenerSync(ISimulationListenerSync listener, boolean headlessSafe) {
        if (!this.listenersSync.contains(listener)) {
            this.listenersSync.add(listener);
            this.createSimulationListenerJobs(listener, true, headlessSafe);
        }
    }

    @Override
    public void removeSimulationListener(ISimulationListener listener) {
        this.listeners.remove(listener);
        this.removeSimulationListenerJobs(listener, false);
    }

    @Override
    public void removeSimulationListenerSync(ISimulationListenerSync listener) {
        this.listenersSync.remove(listener);
        this.removeSimulationListenerJobs(listener, true);
    }

    protected void fireSimulationChanged(SimulationState simulationState) {
        SimulationEvent event = new SimulationEvent(this, simulationState);
        this.fireSimulationChangedEvent(event);
    }

    void fireSimulationChangedEvent(SimulationEvent event) {
        for (ISimulationListener iSimulationListener : this.listeners) {
            this.executeEvent(this.listenerJobs.get(this.getJobMapName(iSimulationListener, event.getSimulationState())), event);
        }
        for (ISimulationListenerSync iSimulationListenerSync : this.listenersSync) {
            this.executeEvent(this.listenerJobsSync.get(this.getJobMapName(iSimulationListenerSync, event.getSimulationState())), event);
        }
    }

    private void executeEvent(SimulationListenerJob job, SimulationEvent event) {
        if (job != null) {
            job.setSimulationEvent(event);
            job.schedule();
            if (job.isSynchronous()) {
                try {
                    job.join();
                }
                catch (InterruptedException ie) {
                    Activator.logInformation(Messages.getString("Sim.Sync_Listener_Interrupt"), ie);
                }
            }
        }
    }

    private String getJobMapName(IBaseListener listener, SimulationState state) {
        return String.valueOf(listener.hashCode()) + state.toString();
    }

    private void createSimulationListenerJobs(IBaseListener listener, boolean synchronous, boolean isHeadlessSafe) {
        SimulationState[] simulationStateArray = SimulationState.values();
        int n = simulationStateArray.length;
        int n2 = 0;
        while (n2 < n) {
            SimulationState state = simulationStateArray[n2];
            SimulationListenerJob job = null;
            job = isHeadlessSafe ? new SimulationListenerJob(this, listener, state, synchronous) : new SimulationListenerUIJob(this, listener, state, synchronous);
            if (listener instanceof IJobChangeListener) {
                job.addJobChangeListener((IJobChangeListener)listener);
            }
            if (synchronous) {
                this.listenerJobsSync.put(this.getJobMapName(listener, state), job);
            } else {
                this.listenerJobs.put(this.getJobMapName(listener, state), job);
            }
            ++n2;
        }
    }

    private void removeSimulationListenerJobs(IBaseListener listener, boolean synchronous) {
        SimulationState[] simulationStateArray = SimulationState.values();
        int n = simulationStateArray.length;
        int n2 = 0;
        while (n2 < n) {
            SimulationState state = simulationStateArray[n2];
            SimulationListenerJob job = null;
            job = synchronous ? this.listenerJobsSync.remove(this.getJobMapName(listener, state)) : this.listenerJobs.remove(this.getJobMapName(listener, state));
            if (job != null && listener instanceof IJobChangeListener) {
                job.removeJobChangeListener((IJobChangeListener)listener);
            }
            ++n2;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.setPreferences();
    }

    public String toString() {
        return this.scenario.produceTitle();
    }

    public boolean interruptRequested() {
        return !this.keepRunning && this.stopping;
    }

    @Override
    public void destroy() {
        ArrayList<ISimulationListener> tempList = new ArrayList<ISimulationListener>();
        tempList.addAll(this.listeners);
        for (ISimulationListener listener : tempList) {
            this.removeSimulationListener(listener);
        }
        this.listeners.clear();
        ArrayList<ISimulationListenerSync> tempListSync = new ArrayList<ISimulationListenerSync>();
        tempListSync.addAll(this.listenersSync);
        for (ISimulationListenerSync listener : tempListSync) {
            this.removeSimulationListenerSync(listener);
        }
        this.listenersSync.clear();
        tempList.clear();
        tempListSync.clear();
        this.scenario.eAdapters().remove((Object)this.adapter);
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    private Solver[] getSolvers() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] solverConfigElements = registry.getConfigurationElementsFor("org.eclipse.stem.core.solver");
        ArrayList<Solver> temp = new ArrayList<Solver>();
        int i = 0;
        while (i < solverConfigElements.length) {
            IConfigurationElement element = solverConfigElements[i];
            if (element.getName().equals("classdef")) {
                try {
                    temp.add((Solver)element.createExecutableExtension("class"));
                }
                catch (Exception e) {
                    CorePlugin.logError((String)"Can't create solver", (Throwable)e);
                }
            }
            ++i;
        }
        Solver[] solvers = temp.toArray(new Solver[0]);
        return solvers;
    }

    public static void handleException(final ScenarioInitializationException se, boolean promptUser) {
        Activator.logError(se.getErrorMessage(), se.getOriginalException());
        if (promptUser) {
            try {
                Display d = DisplaySafeExecutor.safeGetDefaultDisplay();
                if (d != null) {
                    d.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                                Status warning = new Status(2, "org.eclipse.stem.jobs", 1, se.getErrorMessage(), null);
                                ErrorDialog.openError((Shell)window.getShell(), null, null, (IStatus)warning);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
            catch (Error error) {
                // empty catch block
            }
        }
    }

    public static void handleException(final SolverException se, boolean promptUser) {
        Activator.logError(se.getErrorMessage(), se.getOriginalException());
        if (promptUser) {
            try {
                Display d = DisplaySafeExecutor.safeGetDefaultDisplay();
                if (d != null) {
                    d.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                                Status warning = new Status(2, "org.eclipse.stem.jobs", 1, se.getErrorMessage(), null);
                                ErrorDialog.openError((Shell)window.getShell(), null, null, (IStatus)warning);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
            catch (Error error) {
                // empty catch block
            }
        }
    }

    private class SimulationStateChangeJob
    extends Job {
        private SimulationState state;

        protected SimulationStateChangeJob(SimulationState state) {
            super(Messages.getString("Sim.StateChangeJobName"));
            this.state = state;
            this.setPriority(10);
        }

        protected IStatus run(IProgressMonitor monitor) {
            Simulation.this.fireSimulationChanged(this.state);
            return Status.OK_STATUS;
        }
    }
}

