/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.measles.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.common.DoubleValue;
import org.eclipse.stem.core.common.DoubleValueList;
import org.eclipse.stem.core.common.StringValue;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Exchange;
import org.eclipse.stem.core.graph.ExchangePool;
import org.eclipse.stem.core.graph.ExchangeType;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.IntegrationLabelValue;
import org.eclipse.stem.core.graph.Label;
import org.eclipse.stem.core.graph.LabelValue;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.diseasemodels.functions.CTDLFunctions;
import org.eclipse.stem.diseasemodels.measles.Measles;
import org.eclipse.stem.diseasemodels.measles.MeaslesFactory;
import org.eclipse.stem.diseasemodels.measles.MeaslesLabel;
import org.eclipse.stem.diseasemodels.measles.MeaslesLabelValue;
import org.eclipse.stem.diseasemodels.measles.MeaslesPackage;
import org.eclipse.stem.diseasemodels.multipopulation.impl.MultiPopulationSEIRDiseaseModelImpl;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.SEIRLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.populationmodels.standard.AgeGroup;
import org.eclipse.stem.populationmodels.standard.AgingPopulationModel;
import org.eclipse.stem.populationmodels.standard.PopulationGroup;

public class MeaslesImpl
extends MultiPopulationSEIRDiseaseModelImpl
implements Measles {
    protected static final double VACCINE_EFFICACY_EDEFAULT = 0.95;
    protected double vaccineEfficacy = 0.95;
    protected static final double INOCULATION_SCALING_EDEFAULT = 1.0;
    protected double inoculationScaling = 1.0;
    protected static final double PHASE_SHIFT_EDEFAULT = 0.0;
    protected double phaseShift = 0.0;
    protected static final double SEASONAL_MODULATION_EDEFAULT = 1.9;
    protected double seasonalModulation = 1.9;
    protected static final long SEASONAL_MODULATION_PERIOD_EDEFAULT = 31556925994L;
    protected long seasonalModulationPeriod = 31556925994L;
    protected static final double INOCULATED_IMMUNITY_RATE_EDEFAULT = 0.05;
    protected double inoculatedImmunityRate = 0.05;
    protected static final double NEWBORN_IMMUNITY_LOSS_RATE_EDEFAULT = 0.0027;
    protected double newbornImmunityLossRate = 0.0027;
    protected static final double TRANSMISSION_RATE_SCALING_EDEFAULT = 1.0;
    protected double transmissionRateScaling = 1.0;

    protected EClass eStaticClass() {
        return MeaslesPackage.Literals.MEASLES;
    }

    @Override
    public double getVaccineEfficacy() {
        return this.vaccineEfficacy;
    }

    @Override
    public void setVaccineEfficacy(double newVaccineEfficacy) {
        this.vaccineEfficacy = newVaccineEfficacy;
    }

    @Override
    public double getInoculationScaling() {
        return this.inoculationScaling;
    }

    @Override
    public void setInoculationScaling(double newInoculationScaling) {
        this.inoculationScaling = newInoculationScaling;
    }

    @Override
    public double getPhaseShift() {
        return this.phaseShift;
    }

    @Override
    public void setPhaseShift(double newPhaseShift) {
        this.phaseShift = newPhaseShift;
    }

    @Override
    public double getSeasonalModulation() {
        return this.seasonalModulation;
    }

    @Override
    public void setSeasonalModulation(double newSeasonalModulation) {
        this.seasonalModulation = newSeasonalModulation;
    }

    @Override
    public long getSeasonalModulationPeriod() {
        return this.seasonalModulationPeriod;
    }

    @Override
    public void setSeasonalModulationPeriod(long newSeasonalModulationPeriod) {
        this.seasonalModulationPeriod = newSeasonalModulationPeriod;
    }

    @Override
    public double getInoculatedImmunityRate() {
        return this.inoculatedImmunityRate;
    }

    @Override
    public void setInoculatedImmunityRate(double newInoculatedImmunityRate) {
        this.inoculatedImmunityRate = newInoculatedImmunityRate;
    }

    @Override
    public double getNewbornImmunityLossRate() {
        return this.newbornImmunityLossRate;
    }

    @Override
    public void setNewbornImmunityLossRate(double newNewbornImmunityLossRate) {
        this.newbornImmunityLossRate = newNewbornImmunityLossRate;
    }

    @Override
    public double getTransmissionRateScaling() {
        return this.transmissionRateScaling;
    }

    @Override
    public void setTransmissionRateScaling(double newTransmissionRateScaling) {
        this.transmissionRateScaling = newTransmissionRateScaling;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 25: {
                return this.getVaccineEfficacy();
            }
            case 26: {
                return this.getInoculationScaling();
            }
            case 27: {
                return this.getPhaseShift();
            }
            case 28: {
                return this.getSeasonalModulation();
            }
            case 29: {
                return this.getSeasonalModulationPeriod();
            }
            case 30: {
                return this.getInoculatedImmunityRate();
            }
            case 31: {
                return this.getNewbornImmunityLossRate();
            }
            case 32: {
                return this.getTransmissionRateScaling();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 25: {
                this.setVaccineEfficacy((Double)newValue);
                return;
            }
            case 26: {
                this.setInoculationScaling((Double)newValue);
                return;
            }
            case 27: {
                this.setPhaseShift((Double)newValue);
                return;
            }
            case 28: {
                this.setSeasonalModulation((Double)newValue);
                return;
            }
            case 29: {
                this.setSeasonalModulationPeriod((Long)newValue);
                return;
            }
            case 30: {
                this.setInoculatedImmunityRate((Double)newValue);
                return;
            }
            case 31: {
                this.setNewbornImmunityLossRate((Double)newValue);
                return;
            }
            case 32: {
                this.setTransmissionRateScaling((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 25: {
                this.setVaccineEfficacy(0.95);
                return;
            }
            case 26: {
                this.setInoculationScaling(1.0);
                return;
            }
            case 27: {
                this.setPhaseShift(0.0);
                return;
            }
            case 28: {
                this.setSeasonalModulation(1.9);
                return;
            }
            case 29: {
                this.setSeasonalModulationPeriod(31556925994L);
                return;
            }
            case 30: {
                this.setInoculatedImmunityRate(0.05);
                return;
            }
            case 31: {
                this.setNewbornImmunityLossRate(0.0027);
                return;
            }
            case 32: {
                this.setTransmissionRateScaling(1.0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 25: {
                return this.vaccineEfficacy != 0.95;
            }
            case 26: {
                return this.inoculationScaling != 1.0;
            }
            case 27: {
                return this.phaseShift != 0.0;
            }
            case 28: {
                return this.seasonalModulation != 1.9;
            }
            case 29: {
                return this.seasonalModulationPeriod != 31556925994L;
            }
            case 30: {
                return this.inoculatedImmunityRate != 0.05;
            }
            case 31: {
                return this.newbornImmunityLossRate != 0.0027;
            }
            case 32: {
                return this.transmissionRateScaling != 1.0;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (vaccineEfficacy: ");
        result.append(this.vaccineEfficacy);
        result.append(", inoculationScaling: ");
        result.append(this.inoculationScaling);
        result.append(", phaseShift: ");
        result.append(this.phaseShift);
        result.append(", seasonalModulation: ");
        result.append(this.seasonalModulation);
        result.append(", seasonalModulationPeriod: ");
        result.append(this.seasonalModulationPeriod);
        result.append(", inoculatedImmunityRate: ");
        result.append(this.inoculatedImmunityRate);
        result.append(", newbornImmunityLossRate: ");
        result.append(this.newbornImmunityLossRate);
        result.append(", transmissionRateScaling: ");
        result.append(this.transmissionRateScaling);
        result.append(')');
        return result.toString();
    }

    public void applyExternalDeltas(STEMTime currentTime, double continuousTime, long timeDelta, EList<DynamicLabel> labels) {
        super.applyExternalDeltas(currentTime, continuousTime, timeDelta, labels);
    }

    public void doStochasticProcess(IntegrationLabel label, long timeDelta) {
        super.doStochasticProcess(label, timeDelta);
        MeaslesLabelValue nextLV = (MeaslesLabelValue)label.getNextValue();
        MeaslesLabelValue previousV = (MeaslesLabelValue)label.getCurrentValue();
        this.addNoise((IntegrationLabelValue)previousV, (IntegrationLabelValue)nextLV, MeaslesPackage.eINSTANCE.getMeaslesLabelValue_Vaccinated(), MeaslesPackage.eINSTANCE.getMeaslesLabelValue_IncidenceV(), StandardPackage.eINSTANCE.getSEIRLabelValue_E(), 1.0);
    }

    public void calculateDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        int _i = 0;
        while (_i < labels.size()) {
            DynamicLabel label = (DynamicLabel)labels.get(_i);
            IntegrationLabel ilabel = (IntegrationLabel)label;
            MeaslesLabel diseaseLabel = (MeaslesLabel)ilabel;
            MeaslesLabelValue currentState = (MeaslesLabelValue)ilabel.getProbeValue();
            MeaslesLabelValue deltaValue = (MeaslesLabelValue)ilabel.getDeltaValue();
            for (EAttribute ea : currentState.eClass().getEAllAttributes()) {
                if (!(currentState.eGetDouble(ea.getFeatureID()) < 0.0)) continue;
                System.out.println("neg");
            }
            deltaValue.reset();
            MeaslesLabelValue currentSEIR = currentState;
            String thisPopulation = diseaseLabel.getPopulationModelLabel().getPopulationIdentifier();
            double adjustedInfectiousMortalityRate = this.getAdjustedInfectiousMortalityRate(timeDelta, thisPopulation);
            double diseaseDeaths = adjustedInfectiousMortalityRate * currentSEIR.getI();
            int populationIndex = this.getPopulationIndex(thisPopulation);
            EList transmissionVector = ((DoubleValueList)this.getTransmissionRate().getValueLists().get(populationIndex)).getValues();
            double thisRecoveryRate = 0.0;
            if (this.getRecoveryRate() != null) {
                thisRecoveryRate = ((DoubleValue)this.getRecoveryRate().getValues().get(populationIndex)).getValue();
            }
            double thisImmunityLossRate = 0.0;
            if (this.getImmunityLossRate() != null) {
                thisImmunityLossRate = ((DoubleValue)this.getImmunityLossRate().getValues().get(populationIndex)).getValue();
            }
            double thisIncubationRate = 0.0;
            if (this.getIncubationRate() != null) {
                thisIncubationRate = ((DoubleValue)this.getIncubationRate().getValues().get(populationIndex)).getValue();
            }
            double numberOfSusceptibleToExposed = 0.0;
            double numberOfVaccinatedToExposed = 0.0;
            double numberSusceptible = currentSEIR.getS();
            double numberVaccinatedNotYetImmune = currentSEIR.getVaccinated();
            Node thisNode = diseaseLabel.getNode();
            EList groupList = this.getPopulationGroups().getValues();
            int i = 0;
            while (i < transmissionVector.size()) {
                String nextPop = ((StringValue)groupList.get(i)).getValue();
                double specificTransmission = ((DoubleValue)transmissionVector.get(i)).getValue();
                double adjustedTransmission = this.getAdjustedTransmissionRate(specificTransmission, timeDelta);
                adjustedTransmission *= this.getTransmissionRateScaling();
                if (!this.isFrequencyDependent()) {
                    adjustedTransmission *= this.getTransmissionRateScaleFactor(diseaseLabel);
                }
                EList nodeLabels = thisNode.getLabels();
                int j = 0;
                while (j < nodeLabels.size()) {
                    MeaslesLabel otherDiseaseLabel;
                    String otherPopulation;
                    NodeLabel nlabel = (NodeLabel)nodeLabels.get(j);
                    if (nlabel instanceof MeaslesLabel && this == ((MeaslesLabel)label).getDecorator() && (otherPopulation = (otherDiseaseLabel = (MeaslesLabel)nlabel).getPopulationModelLabel().getPopulationIdentifier()).equals(nextPop)) {
                        double onsiteInfectious = ((SEIRLabelValue)otherDiseaseLabel.getTempValue()).getI();
                        double effectiveInfectious = this.getNormalizedEffectiveInfectious(thisNode, otherDiseaseLabel, onsiteInfectious, StandardPackage.Literals.SI_LABEL_VALUE__I, StandardPackage.Literals.STANDARD_DISEASE_MODEL__CHARACTERISTIC_MIXING_DISTANCE, StandardPackage.Literals.STANDARD_DISEASE_MODEL__ROAD_NETWORK_INFECTIOUS_PROPORTION);
                        double cosineMin = 1.0;
                        double cosineMax = this.getSeasonalModulation();
                        double mod = cosineMin + (cosineMax - cosineMin) * (1.0 + Math.cos(Math.PI * 2 * (this.getPhaseShift() + t * (double)timeDelta / (double)this.getSeasonalModulationPeriod()))) / 2.0;
                        numberOfSusceptibleToExposed += mod * adjustedTransmission * numberSusceptible * effectiveInfectious;
                        numberOfVaccinatedToExposed += mod * adjustedTransmission * numberVaccinatedNotYetImmune * effectiveInfectious;
                    }
                    ++j;
                }
                ++i;
            }
            double numberOfNewBornToSusceptible = (double)timeDelta / (double)this.getTimePeriod() * this.getNewbornImmunityLossRate() * currentSEIR.getM();
            double numberOfInfectedToRecovered = this.getAdjustedRecoveryRate(thisRecoveryRate, timeDelta) * currentSEIR.getI();
            double numberOfRecoveredToSusceptible = this.getAdjustedImmunityLossRate(thisImmunityLossRate, timeDelta) * currentSEIR.getR();
            double numberOfExposedToInfected = this.getAdjustedIncubationRate(thisIncubationRate, timeDelta) * currentSEIR.getE();
            double numberOfVaccinatedToRecovered = (double)timeDelta / (double)this.getTimePeriod() * this.getInoculatedImmunityRate() * currentSEIR.getVaccinated();
            Exchange msExchange = (Exchange)ExchangePool.POOL.get();
            msExchange.setSource(MeaslesPackage.eINSTANCE.getMeaslesLabelValue_M());
            msExchange.setTarget(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
            msExchange.setCount(numberOfNewBornToSusceptible);
            msExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)msExchange);
            Exchange seExchange = (Exchange)ExchangePool.POOL.get();
            seExchange.setSource(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
            seExchange.setTarget(StandardPackage.eINSTANCE.getSEIRLabelValue_E());
            seExchange.setCount(numberOfSusceptibleToExposed);
            seExchange.getForIncidence().add((Object)StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_Incidence());
            seExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)seExchange);
            Exchange eiExchange = (Exchange)ExchangePool.POOL.get();
            eiExchange.setSource(StandardPackage.eINSTANCE.getSEIRLabelValue_E());
            eiExchange.setTarget(StandardPackage.eINSTANCE.getSILabelValue_I());
            eiExchange.setCount(numberOfExposedToInfected);
            eiExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)eiExchange);
            Exchange irExchange = (Exchange)ExchangePool.POOL.get();
            irExchange.setSource(StandardPackage.eINSTANCE.getSILabelValue_I());
            irExchange.setTarget(StandardPackage.eINSTANCE.getSIRLabelValue_R());
            irExchange.setCount(numberOfInfectedToRecovered);
            irExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)irExchange);
            Exchange rsExchange = (Exchange)ExchangePool.POOL.get();
            rsExchange.setSource(StandardPackage.eINSTANCE.getSIRLabelValue_R());
            rsExchange.setTarget(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
            rsExchange.setCount(numberOfRecoveredToSusceptible);
            rsExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)rsExchange);
            Exchange vacEExchange = (Exchange)ExchangePool.POOL.get();
            vacEExchange.setSource(MeaslesPackage.eINSTANCE.getMeaslesLabelValue_Vaccinated());
            vacEExchange.setTarget(StandardPackage.eINSTANCE.getSEIRLabelValue_E());
            vacEExchange.getForIncidence().add((Object)MeaslesPackage.eINSTANCE.getMeaslesLabelValue_IncidenceV());
            vacEExchange.setCount(numberOfVaccinatedToExposed);
            vacEExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)vacEExchange);
            Exchange vacRExchange = (Exchange)ExchangePool.POOL.get();
            vacRExchange.setSource(MeaslesPackage.eINSTANCE.getMeaslesLabelValue_Vaccinated());
            vacRExchange.setTarget(StandardPackage.eINSTANCE.getSIRLabelValue_R());
            vacRExchange.setCount(numberOfVaccinatedToRecovered);
            vacRExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)vacRExchange);
            double deltaM = -numberOfNewBornToSusceptible;
            double deltaS = numberOfNewBornToSusceptible - numberOfSusceptibleToExposed + numberOfRecoveredToSusceptible;
            double deltaE = numberOfSusceptibleToExposed + numberOfVaccinatedToExposed - numberOfExposedToInfected;
            double deltaI = numberOfExposedToInfected - numberOfInfectedToRecovered - diseaseDeaths;
            double deltaR = numberOfInfectedToRecovered - numberOfRecoveredToSusceptible + numberOfVaccinatedToRecovered;
            double deltaVaccinations = -numberOfVaccinatedToRecovered - numberOfVaccinatedToExposed;
            double numEffectiveVaccinations = 0.0;
            double vaccinations = CTDLFunctions.vaccinations((Node)diseaseLabel.getNode(), (Label)diseaseLabel, (LabelValue)currentState, (STEMTime)time, (long)timeDelta, (double)t);
            double totalVaccinations = 0.0;
            if (vaccinations > 0.0) {
                int ageGroups = 1;
                if (diseaseLabel.getPopulationModelLabel().getDecorator() instanceof AgingPopulationModel) {
                    AgingPopulationModel apm = (AgingPopulationModel)diseaseLabel.getPopulationModelLabel().getDecorator();
                    EList groups = apm.getPopulationGroups();
                    for (PopulationGroup pg : groups) {
                        if (!pg.getIdentifier().equals(diseaseLabel.getPopulationModelLabel().getPopulationIdentifier())) continue;
                        AgeGroup ag = (AgeGroup)pg;
                        ageGroups = ag.getToAge() - ag.getFromAge() + 1;
                        break;
                    }
                }
                totalVaccinations = vaccinations /= (double)ageGroups;
                totalVaccinations *= this.getInoculationScaling();
                if ((totalVaccinations *= this.getVaccineEfficacy()) > currentState.getPopulationCount()) {
                    totalVaccinations = currentState.getPopulationCount();
                }
                MeaslesLabelValue copyState = (MeaslesLabelValue)currentState.copy();
                copyState.scale(totalVaccinations / currentState.getPopulationCount());
                deltaS -= copyState.getS();
                numEffectiveVaccinations = copyState.getS();
                deltaVaccinations += numEffectiveVaccinations;
                Exchange sVacExchange = (Exchange)ExchangePool.POOL.get();
                sVacExchange.setSource(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
                sVacExchange.setTarget(MeaslesPackage.eINSTANCE.getMeaslesLabelValue_Vaccinated());
                sVacExchange.setCount(copyState.getS());
                sVacExchange.getForIncidence().add((Object)MeaslesPackage.eINSTANCE.getMeaslesLabelValue_Immunisations());
                sVacExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
                deltaValue.getDepartures().add((Object)sVacExchange);
            }
            MeaslesLabelValue ret = deltaValue;
            ret.setM(deltaM);
            ret.setS(deltaS);
            ret.setE(deltaE);
            ret.setI(deltaI);
            ret.setR(deltaR);
            ret.setIncidence(numberOfSusceptibleToExposed);
            ret.setDiseaseDeaths(diseaseDeaths);
            ret.setImmunisations(numEffectiveVaccinations);
            ret.setVaccinated(deltaVaccinations);
            ret.setIncidenceV(numberOfVaccinatedToExposed);
            this.computeAdditionalDeltasAndExchanges(ilabel, time, t, timeDelta);
            ++_i;
        }
    }

    public EAttribute getBirthsCompartment() {
        return MeaslesPackage.eINSTANCE.getMeaslesLabelValue_M();
    }

    public DiseaseModelLabel createDiseaseModelLabel(String populationIdentifier) {
        MeaslesLabel label = MeaslesFactory.eINSTANCE.createMeaslesLabel();
        label.setTypeURI(DiseaseModelLabel.URI_TYPE_DYNAMIC_DISEASE_LABEL);
        return label;
    }

    public DiseaseModelLabelValue createDiseaseModelLabelValue(String populationIdentifier) {
        return MeaslesFactory.eINSTANCE.createMeaslesLabelValue();
    }
}

