/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.definitions.transport.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.EdgeLabel;
import org.eclipse.stem.core.graph.provider.EdgeLabelItemProvider;
import org.eclipse.stem.definitions.transport.PipeTransportEdgeLabel;
import org.eclipse.stem.definitions.transport.provider.TransportEditPlugin;
import org.eclipse.stem.geography.names.GeographicNames;

public class PipeTransportEdgeLabelItemProvider
extends EdgeLabelItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    private static String AIR_TRANSPORT_SYSTEM_STRING = "(S)";

    public PipeTransportEdgeLabelItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
        }
        return this.itemPropertyDescriptors;
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/custom16/airEdge.png"));
    }

    public String getTextGen(Object object) {
        URI labelValue = ((PipeTransportEdgeLabel)object).getURI();
        String label = labelValue == null ? null : labelValue.toString();
        return label == null || label.length() == 0 ? this.getString("_UI_PipeTransportEdgeLabel_type") : String.valueOf(this.getString("_UI_PipeTransportEdgeLabel_type")) + " " + label;
    }

    public String getText(Object object) {
        URI labelURI = ((PipeTransportEdgeLabel)object).getURI();
        String lastSegment = labelURI.lastSegment().toString();
        int i = lastSegment.indexOf("_");
        String firstISOKey = lastSegment.substring(0, i);
        String secondISOKey = lastSegment.substring(i + 1);
        String firstPrefix = "";
        String secondPrefix = "";
        if (firstISOKey.startsWith(AIR_TRANSPORT_SYSTEM_STRING)) {
            firstISOKey = firstISOKey.substring(3);
            firstPrefix = AIR_TRANSPORT_SYSTEM_STRING;
        }
        if (secondISOKey.startsWith(AIR_TRANSPORT_SYSTEM_STRING)) {
            secondISOKey = secondISOKey.substring(3);
            secondPrefix = AIR_TRANSPORT_SYSTEM_STRING;
        }
        String firstGeoName = GeographicNames.getName((String)firstISOKey);
        String secondGeoName = GeographicNames.getName((String)secondISOKey);
        StringBuilder sb = new StringBuilder(firstGeoName.startsWith("!") ? String.valueOf(firstPrefix) + firstISOKey : String.valueOf(firstPrefix) + firstGeoName);
        Edge edge = ((EdgeLabel)object).getEdge();
        sb.append(edge.isDirected() ? " -> " : " <-> ");
        sb.append(secondGeoName.startsWith("!") ? String.valueOf(secondPrefix) + secondISOKey : String.valueOf(secondPrefix) + secondGeoName);
        return sb.toString();
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public ResourceLocator getResourceLocator() {
        return TransportEditPlugin.INSTANCE;
    }
}

