/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.stem.jobs.Activator;
import org.eclipse.stem.ui.ge.Aspect;
import org.eclipse.stem.ui.ge.GEData;
import org.eclipse.stem.ui.ge.GELog;
import org.eclipse.stem.ui.ge.kml.StemKml;

public class GEJob
extends Thread {
    private String fn = null;
    private StemKml stemKml = null;
    private Map<String, GEData> stemMap = null;
    private Aspect aspect = null;
    private long cycle = 0L;
    private boolean launch = false;
    private boolean rename = false;
    private static Thread work = null;

    public GEJob(String name) {
        super(name);
    }

    @Override
    public void run() {
        GELog.debug(this, String.valueOf(this.fn) + " " + this.aspect + " " + this.cycle + " " + this.launch + " " + this.rename);
        try {
            if (this.rename) {
                File f = new File(this.fn);
                String parent = String.valueOf(f.getParent()) + File.separator;
                this.fn = f.getName();
                String newFile = String.valueOf(parent) + this.fn.replace(".", "_New.");
                String currentFile = String.valueOf(parent) + this.fn.replace(".", "_Current.");
                String oldFile = String.valueOf(parent) + this.fn.replace(".", "._Old");
                try {
                    File fileN = new File(newFile);
                    File fileO = new File(oldFile);
                    File fileC = new File(currentFile);
                    this.stemKml.generatePolygons(newFile, this.stemMap, this.aspect, this.cycle);
                    if (fileO.exists()) {
                        fileO.delete();
                    }
                    if (fileC.exists()) {
                        fileC.renameTo(fileO);
                    }
                    fileN.renameTo(fileC);
                }
                catch (RuntimeException e) {
                    GELog.error("Failure creating KML files.  newFile: " + newFile, e);
                }
            } else {
                this.stemKml.generatePolygons(this.fn, this.stemMap, this.aspect, this.cycle);
                if (this.launch) {
                    StemKml.launch(this.fn);
                    GELog.debug(this, "GoogleEarth Map  submitted");
                }
            }
        }
        catch (Throwable e) {
            GELog.error("Failure in interface to GoogleEarth. ", e);
        }
    }

    public void generateKML(String fn, StemKml stemKml, Map<String, GEData> stemMap, Aspect aspect, long cycle, boolean launch, boolean rename) {
        this.fn = fn;
        this.stemKml = stemKml;
        this.aspect = aspect;
        this.cycle = cycle;
        this.launch = launch;
        this.rename = rename;
        if (cycle == 0L) {
            this.checkPreferences();
        }
        int n = stemMap.size();
        this.stemMap = new HashMap<String, GEData>(n);
        this.stemMap.putAll(stemMap);
        try {
            if (work != null && work.getState() != Thread.State.TERMINATED) {
                GELog.debug(this, "Skip KML generation for cycle " + cycle);
                return;
            }
            work = new Thread((Runnable)this, "Job_" + cycle);
            work.start();
        }
        catch (Exception e) {
            GELog.error("Failure scheduling KML File generation", e);
        }
    }

    protected void checkPreferences() {
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        boolean simulationSleep = preferenceStore.getBoolean("cyclePause");
        int sleepMilliseconds = preferenceStore.getInt("cyclePauseMilliSeconds");
        if (!simulationSleep || sleepMilliseconds <= 1) {
            GELog.info("GEJob: Specified Sleep interval not specified \nor may be too short for GoogleEarth operation.\nCheck preferences.");
        }
    }
}

