/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.internal.databinding.IdentitySet;
import org.eclipse.core.internal.databinding.Pair;

public class ObservablesManager {
    private Set managedObservables = new IdentitySet();
    private Set excludedObservables = new IdentitySet();
    private Map<DataBindingContext, Pair> contexts = new HashMap<DataBindingContext, Pair>();

    public void addObservable(IObservable observable) {
        this.managedObservables.add(observable);
    }

    public void excludeObservable(IObservable observable) {
        this.excludedObservables.add(observable);
    }

    public void addObservablesFromContext(DataBindingContext context, boolean trackTargets, boolean trackModels) {
        if (trackTargets || trackModels) {
            this.contexts.put(context, new Pair(trackTargets, trackModels));
        }
    }

    public void runAndCollect(Runnable runnable) {
        IObservable[] collected;
        IObservable[] iObservableArray = collected = ObservableTracker.runAndCollect((Runnable)runnable);
        int n = collected.length;
        int n2 = 0;
        while (n2 < n) {
            IObservable observable = iObservableArray[n2];
            this.addObservable(observable);
            ++n2;
        }
    }

    public void dispose() {
        IdentitySet observables = new IdentitySet();
        observables.addAll(this.managedObservables);
        for (Map.Entry<DataBindingContext, Pair> entry : this.contexts.entrySet()) {
            DataBindingContext context = entry.getKey();
            Pair trackModelsOrTargets = entry.getValue();
            boolean disposeTargets = (Boolean)trackModelsOrTargets.a;
            boolean disposeModels = (Boolean)trackModelsOrTargets.b;
            for (Binding binding : context.getBindings()) {
                if (disposeTargets) {
                    observables.add(binding.getTarget());
                }
                if (!disposeModels) continue;
                observables.add(binding.getModel());
            }
        }
        observables.removeAll(this.excludedObservables);
        for (IObservable observable : observables) {
            observable.dispose();
        }
    }
}

