/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.stem.analysis.LogInitializationException;
import org.eclipse.stem.definitions.Activator;
import org.eclipse.stem.util.analysis.LinearLeastSquaresFit;

public class DataProcessor {
    private static final String INCIDENCE_FILE_NAME = "Incidence_2.csv";
    private static final String SUSCEPTIBLE_FILE_NAME = "S_2.csv";
    private static final String INFECTIOUS_FILE_NAME = "I_2.csv";
    private static final String RECOVERED_FILE_NAME = "R_2.csv";
    private static final String POPULATION_FILE_NAME = "P_2.csv";
    private static final String REPORTING_FRACTION_FILE_NAME = "reportingFraction.csv";
    private Map<String, List<Data>> incidenceMap = new HashMap<String, List<Data>>();
    private Map<String, Double> populationMap = new HashMap<String, Double>();
    private int maxIteration = 0;
    private long referencePopulationDay;
    private double fractChangePopulationPerDay;

    public void process(String sourceFolder, String targetFolder, Date startDate, Date endDate, String populationDataFile, long populationSizeStartYear, long populationSizeEndYear, double recoveryRate, double susceptibleRate, double immunityLossRate) throws LogInitializationException {
        this.readPopulationData(populationDataFile, startDate, endDate, populationSizeStartYear, populationSizeEndYear);
        this.readSourceData(sourceFolder);
        this.modelDiseaseState(recoveryRate, susceptibleRate, immunityLossRate);
        this.writeResults(targetFolder);
    }

    private void readPopulationData(String populationDataFile, Date startDate, Date endDate, long populationSizeStartYear, long populationSizeEndYear) throws LogInitializationException {
        String POPULATION_YEAR = "YEAR";
        File file = new File(populationDataFile);
        BufferedReader fileReader = DataProcessor.openReader(file);
        if (fileReader == null) {
            throw new LogInitializationException("Failed to open population data file " + populationDataFile);
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        int populationDataYear = cal.get(1);
        try {
            String buffer = null;
            while (!DataProcessor.EOF(buffer = fileReader.readLine())) {
                int idx = buffer.indexOf("=");
                if (idx < 0) continue;
                String id = buffer.substring(0, idx).trim();
                String value = buffer.substring(idx + 1, buffer.length()).trim();
                if (id.equals("YEAR")) {
                    try {
                        populationDataYear = Integer.parseInt(value);
                    }
                    catch (NumberFormatException ex) {
                        Activator.logInformation((String)"Failed to read population year", (Throwable)ex);
                    }
                    continue;
                }
                if (id.indexOf("-") < 0) continue;
                try {
                    this.populationMap.put(id, new Double(value));
                }
                catch (NumberFormatException ex) {
                    Activator.logInformation((String)("Failed to read population for " + id), (Throwable)ex);
                }
            }
            if (this.populationMap.isEmpty()) {
                throw new LogInitializationException("Failed to read population data from " + file.getName());
            }
            cal = Calendar.getInstance();
            cal.set(6, 1);
            cal.set(1, populationDataYear);
            long offset = cal.getTimeInMillis() - startDate.getTime();
            this.referencePopulationDay = offset / 86400000L;
            offset = endDate.getTime() - startDate.getTime();
            long offsetDays = offset / 86400000L;
            double changePopulationPerDay = ((double)populationSizeEndYear - (double)populationSizeStartYear) / (double)(offsetDays + 1L);
            this.fractChangePopulationPerDay = changePopulationPerDay / (double)populationSizeStartYear;
        }
        catch (IOException ex) {
            throw new LogInitializationException((Throwable)ex);
        }
    }

    private void readSourceData(String sourceFolder) throws LogInitializationException {
        File file = new File(sourceFolder);
        int numFiles = 0;
        File[] allFiles = file.listFiles();
        int i = 0;
        while (i < allFiles.length) {
            try {
                this.readDataFromSourceFile(allFiles[i]);
                ++numFiles;
            }
            catch (LogInitializationException ex) {
                Activator.logInformation((String)("Failed to read data from " + allFiles[i].getName()), (Throwable)ex);
            }
            ++i;
        }
        if (numFiles == 0) {
            throw new LogInitializationException("Failed to read source data from " + sourceFolder);
        }
    }

    private void readDataFromSourceFile(File file) throws LogInitializationException {
        List<Object> incList;
        String fileName = file.getName();
        if (fileName.indexOf(".txt") < 0) {
            return;
        }
        BufferedReader fileReader = DataProcessor.openReader(file);
        if (fileReader == null) {
            throw new LogInitializationException("Failed to open file " + fileName);
        }
        int idx = fileName.indexOf(".txt");
        String idInput = fileName.substring(0, idx);
        String id = this.convertID(idInput);
        if (id == null) {
            throw new LogInitializationException("Failed to convert " + idInput + " to STEM ID");
        }
        Double population = this.populationMap.get(id);
        if (population == null) {
            throw new LogInitializationException("No population found for " + id + " from " + idInput);
        }
        if (!this.incidenceMap.containsKey(id)) {
            incList = new ArrayList();
            this.incidenceMap.put(id, incList);
        }
        incList = this.incidenceMap.get(id);
        try {
            String buffer = null;
            fileReader.readLine();
            while (!DataProcessor.EOF(buffer = fileReader.readLine())) {
                StringTokenizer tokenizer = new StringTokenizer(buffer, ",");
                String iteration = tokenizer.nextToken(",");
                String time = tokenizer.nextToken(",");
                String inc = tokenizer.nextToken(",");
                Integer count = new Integer(iteration.trim());
                double reports = new Double(inc);
                double pop = this.getPopulation(count, population);
                Data data = new Data(count, time, reports, pop);
                incList.add(data);
                if (incList.size() <= this.maxIteration) continue;
                this.maxIteration = incList.size();
            }
        }
        catch (IOException ex) {
            throw new LogInitializationException((Throwable)ex);
        }
    }

    private void modelDiseaseState(double recoveryRate, double susceptibleRate, double immunityLossRate) {
        List<Data> dataList;
        for (String id : this.populationMap.keySet()) {
            if (!this.incidenceMap.containsKey(id)) continue;
            dataList = this.incidenceMap.get(id);
            double minFraction = 10.0;
            double bestFraction = 1.0;
            double minSlope = Double.MAX_VALUE;
            boolean valid = true;
            boolean pointOK = true;
            int maxdelta = 1000;
            int idelta = 1000;
            double scale = 100000.0;
            int ifraction = (int)scale;
            while (ifraction > 1 && valid) {
                double slope;
                pointOK = true;
                if (ifraction <= idelta && idelta >= 10) {
                    idelta /= 10;
                }
                double fraction = (double)ifraction / scale;
                double integratedInfectious = 0.0;
                double integratedRecoveries = 0.0;
                double[] ydataS = new double[this.maxIteration];
                double[] ydataR = new double[this.maxIteration];
                double[] xdata = new double[this.maxIteration];
                int i = 0;
                while (i < this.maxIteration) {
                    ydataS[i] = 0.0;
                    ydataR[i] = 0.0;
                    xdata[i] = 0.0;
                    ++i;
                }
                i = 0;
                while (i < dataList.size() && valid) {
                    Data data = dataList.get(i);
                    double incidence = data.reports / fraction;
                    double population = data.population;
                    double recoveries = (integratedInfectious += incidence) * recoveryRate;
                    integratedRecoveries += recoveries;
                    if (i == 0) {
                        integratedRecoveries += (1.0 - susceptibleRate) * population;
                    }
                    double infectious = integratedInfectious -= recoveries;
                    double recovered = integratedRecoveries *= 1.0 - immunityLossRate;
                    double susceptible = population - (infectious + recovered);
                    ydataS[i] = susceptible / population;
                    ydataR[i] = recovered / population;
                    xdata[i] = i;
                    if (!(susceptible >= 0.0 && recovered >= 0.0 && infectious >= 0.0)) {
                        pointOK = false;
                        if (idelta > 1) {
                            ifraction += idelta;
                            idelta /= 10;
                            break;
                        }
                        valid = false;
                        idelta = 1000;
                        break;
                    }
                    data.reportingFraction = minFraction = fraction;
                    if (!valid || !pointOK) break;
                    ++i;
                }
                if (valid && pointOK && Math.abs(slope = this.getSlopeLinear(xdata, ydataS)) <= minSlope) {
                    minSlope = Math.abs(slope);
                    bestFraction = fraction;
                }
                ifraction -= idelta;
            }
            int i = 0;
            while (i < dataList.size() && valid) {
                Data data = dataList.get(i);
                if (bestFraction < 0.9 && bestFraction >= data.reportingFraction) {
                    data.reportingFraction = bestFraction;
                }
                ++i;
            }
        }
        for (String id : this.populationMap.keySet()) {
            if (!this.incidenceMap.containsKey(id)) continue;
            dataList = this.incidenceMap.get(id);
            double integratedInfectious = 0.0;
            double integratedRecoveries = 0.0;
            int i = 0;
            while (i < dataList.size()) {
                Data data = dataList.get(i);
                double fraction = data.reportingFraction;
                double incidence = data.reports / fraction;
                double population = data.population;
                double recoveries = (integratedInfectious += incidence) * recoveryRate;
                integratedRecoveries += recoveries;
                if (i == 0) {
                    integratedRecoveries += (1.0 - susceptibleRate) * population;
                }
                data.infectious = integratedInfectious -= recoveries;
                data.recovered = integratedRecoveries *= 1.0 - immunityLossRate;
                data.susceptible = population - (data.infectious + data.recovered);
                ++i;
            }
        }
    }

    private void writeResults(String targetFolder) throws LogInitializationException {
        try {
            if (!targetFolder.endsWith(File.separator)) {
                targetFolder = String.valueOf(targetFolder) + File.separator;
            }
            FileWriter fw1 = new FileWriter(String.valueOf(targetFolder) + INCIDENCE_FILE_NAME);
            FileWriter fw2 = new FileWriter(String.valueOf(targetFolder) + SUSCEPTIBLE_FILE_NAME);
            FileWriter fw3 = new FileWriter(String.valueOf(targetFolder) + INFECTIOUS_FILE_NAME);
            FileWriter fw4 = new FileWriter(String.valueOf(targetFolder) + RECOVERED_FILE_NAME);
            FileWriter fw5 = new FileWriter(String.valueOf(targetFolder) + POPULATION_FILE_NAME);
            FileWriter fw6 = new FileWriter(String.valueOf(targetFolder) + REPORTING_FRACTION_FILE_NAME);
            Object[] keys = new String[this.populationMap.keySet().size()];
            Iterator<String> iter = this.populationMap.keySet().iterator();
            int counter = 0;
            while (iter.hasNext()) {
                keys[counter++] = iter.next();
            }
            Arrays.sort(keys);
            String headerText = "iteration,time";
            StringBuilder strBldr = new StringBuilder(headerText);
            int i = 0;
            while (i < keys.length) {
                if (this.incidenceMap.containsKey(keys[i])) {
                    strBldr.append(",");
                    strBldr.append((String)keys[i]);
                }
                ++i;
            }
            strBldr.append("\n");
            String header = strBldr.toString();
            fw1.write(header);
            fw2.write(header);
            fw3.write(header);
            fw4.write(header);
            fw5.write(header);
            fw6.write(header);
            int i2 = 0;
            while (i2 < this.maxIteration) {
                String line1 = "";
                String line2 = "";
                String line3 = "";
                String line4 = "";
                String line5 = "";
                String line6 = "0,0";
                int j = 0;
                while (j < keys.length) {
                    Object id = keys[j];
                    if (this.incidenceMap.containsKey(id)) {
                        List<Data> dataList = this.incidenceMap.get(id);
                        if (i2 >= dataList.size()) break;
                        Data data = dataList.get(i2);
                        if (i2 == 0) {
                            line6 = String.valueOf(line6) + "," + data.reportingFraction;
                        }
                        if (j == 0) {
                            line1 = String.valueOf(line1) + data.iteration + "," + data.time;
                            line2 = String.valueOf(line2) + data.iteration + "," + data.time;
                            line3 = String.valueOf(line3) + data.iteration + "," + data.time;
                            line4 = String.valueOf(line4) + data.iteration + "," + data.time;
                            line5 = String.valueOf(line5) + data.iteration + "," + data.time;
                        }
                        line1 = String.valueOf(line1) + "," + data.reports;
                        line2 = String.valueOf(line2) + "," + data.susceptible;
                        line3 = String.valueOf(line3) + "," + data.infectious;
                        line4 = String.valueOf(line4) + "," + data.recovered;
                        line5 = String.valueOf(line5) + "," + data.population;
                    }
                    ++j;
                }
                line1 = String.valueOf(line1) + "\n";
                line2 = String.valueOf(line2) + "\n";
                line3 = String.valueOf(line3) + "\n";
                line4 = String.valueOf(line4) + "\n";
                line5 = String.valueOf(line5) + "\n";
                if (i2 == 0) {
                    line6 = String.valueOf(line6) + "\n";
                }
                fw1.write(line1);
                fw2.write(line2);
                fw3.write(line3);
                fw4.write(line4);
                fw5.write(line5);
                if (i2 == 0) {
                    fw6.write(line6);
                }
                ++i2;
            }
            ((Writer)fw1).flush();
            ((Writer)fw1).close();
            ((Writer)fw2).flush();
            ((Writer)fw2).close();
            ((Writer)fw3).flush();
            ((Writer)fw3).close();
            ((Writer)fw4).flush();
            ((Writer)fw4).close();
            ((Writer)fw5).flush();
            ((Writer)fw5).close();
            ((Writer)fw6).flush();
            ((Writer)fw6).close();
        }
        catch (IOException ex) {
            throw new LogInitializationException((Throwable)ex);
        }
    }

    public String convertID(String inputID) {
        String inputCode2 = DataProcessor.getAdmin2Code(inputID);
        for (String id : this.populationMap.keySet()) {
            if (!DataProcessor.getAdmin2Code(id).equalsIgnoreCase(inputCode2)) continue;
            return id;
        }
        return null;
    }

    public static String getAdmin2Code(String id) {
        int idx = id.lastIndexOf("-");
        return id.substring(idx + 1, id.length());
    }

    private double getSlopeLinear(double[] xData, double[] yData) {
        LinearLeastSquaresFit linFit = new LinearLeastSquaresFit(xData, yData);
        return linFit.getSlope();
    }

    private double getPopulation(int iteration, double refPop) {
        double increase = (double)((long)iteration - this.referencePopulationDay) * this.fractChangePopulationPerDay;
        return refPop * (1.0 + increase);
    }

    public static BufferedReader openReader(File f) {
        block3: {
            try {
                if (f.exists()) break block3;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return new BufferedReader(new FileReader(f));
    }

    public static boolean EOF(String buffer) {
        return buffer == null || buffer.length() == 0;
    }

    public static class Data {
        public double reports;
        public double reportingFraction = -1.0;
        public double susceptible = 0.0;
        public double infectious = 0.0;
        public double recovered = 0.0;
        public double population = 0.0;
        public Integer iteration;
        public String time;

        public Data(Integer iter, String time, double reported, double pop) {
            this.iteration = iter;
            this.time = time;
            this.reports = reported;
            this.population = pop;
        }

        public double getReferencePopulation() {
            return this.population;
        }

        public void setLocalPopulation(double localPopulation) {
            this.population = localPopulation;
            this.susceptible = localPopulation;
        }
    }
}

