/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.core.AbstractClassFile;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.ModularClassFile;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.jdt.internal.core.util.Util;

public class PossibleMatch
implements ICompilationUnit {
    public static final String NO_SOURCE_FILE_NAME = "NO SOURCE FILE NAME";
    public static final char[] NO_SOURCE_FILE = new char[0];
    public IResource resource;
    public Openable openable;
    public MatchingNodeSet nodeSet;
    public char[][] compoundName;
    CompilationUnitDeclaration parsedUnit;
    public SearchDocument document;
    private String sourceFileName;
    private char[] source;
    private PossibleMatch similarMatch;
    public String autoModuleName;

    public PossibleMatch(MatchLocator locator, IResource resource, Openable openable, SearchDocument document, boolean mustResolve) {
        this.resource = resource;
        this.openable = openable;
        this.document = document;
        this.nodeSet = new MatchingNodeSet(mustResolve);
        char[] qualifiedName = this.getQualifiedName();
        if (qualifiedName != null) {
            this.compoundName = CharOperation.splitOn('.', qualifiedName);
        }
    }

    public void cleanUp() {
        this.source = null;
        if (this.parsedUnit != null) {
            this.parsedUnit.cleanUp();
            this.parsedUnit = null;
        }
        this.nodeSet = null;
    }

    public boolean equals(Object obj) {
        if (this.compoundName == null) {
            return super.equals(obj);
        }
        if (!(obj instanceof PossibleMatch)) {
            return false;
        }
        return CharOperation.equals(this.compoundName, ((PossibleMatch)obj).compoundName);
    }

    @Override
    public char[] getContents() {
        char[] contents;
        char[] cArray = contents = this.source == NO_SOURCE_FILE ? null : this.source;
        if (this.source == null) {
            if (this.openable instanceof AbstractClassFile) {
                String fileName = this.getSourceFileName();
                if (fileName == NO_SOURCE_FILE_NAME) {
                    return CharOperation.NO_CHAR;
                }
                SourceMapper sourceMapper = this.openable.getSourceMapper();
                if (sourceMapper != null) {
                    if (this.openable instanceof ClassFile) {
                        IType type = ((ClassFile)this.openable).getType();
                        contents = sourceMapper.findSource(type, fileName);
                    } else if (this.openable instanceof ModularClassFile) {
                        try {
                            IModuleDescription module = ((ModularClassFile)this.openable).getModule();
                            contents = module != null ? sourceMapper.findSource(module) : CharOperation.NO_CHAR;
                        }
                        catch (JavaModelException javaModelException) {
                            return CharOperation.NO_CHAR;
                        }
                    }
                }
            } else if (this.autoModuleName != null) {
                contents = new String("module " + this.autoModuleName + "{}").toCharArray();
                this.sourceFileName = "module-info.java";
                this.compoundName = new char[][]{"module-info".toCharArray()};
            } else {
                contents = this.document.getCharContents();
            }
            this.source = contents == null ? NO_SOURCE_FILE : contents;
        }
        return contents;
    }

    @Override
    public char[] getFileName() {
        return this.openable.getElementName().toCharArray();
    }

    @Override
    public char[] getMainTypeName() {
        return this.compoundName[this.compoundName.length - 1];
    }

    @Override
    public char[][] getPackageName() {
        int length = this.compoundName.length;
        if (length <= 1) {
            return CharOperation.NO_CHAR_CHAR;
        }
        return CharOperation.subarray(this.compoundName, 0, length - 1);
    }

    private char[] getQualifiedName() {
        if (this.openable instanceof CompilationUnit) {
            String fileName = this.openable.getElementName();
            char[] mainTypeName = Util.getNameWithoutJavaLikeExtension(fileName).toCharArray();
            CompilationUnit cu = (CompilationUnit)this.openable;
            return cu.getType(new String(mainTypeName)).getFullyQualifiedName().toCharArray();
        }
        if (this.openable instanceof ClassFile) {
            String fileName = this.getSourceFileName();
            if (fileName == NO_SOURCE_FILE_NAME) {
                return ((ClassFile)this.openable).getType().getFullyQualifiedName('.').toCharArray();
            }
            int index = Util.indexOfJavaLikeExtension(fileName);
            String simpleName = index == -1 ? fileName : fileName.substring(0, index);
            PackageFragment pkg = (PackageFragment)this.openable.getParent();
            return Util.concatWith(pkg.names, simpleName, '.').toCharArray();
        }
        if (this.openable instanceof ModularClassFile) {
            String simpleName = "module-info";
            PackageFragment pkg = (PackageFragment)this.openable.getParent();
            return Util.concatWith(pkg.names, simpleName, '.').toCharArray();
        }
        return null;
    }

    PossibleMatch getSimilarMatch() {
        return this.similarMatch;
    }

    private String getSourceFileName() {
        if (this.sourceFileName != null) {
            return this.sourceFileName;
        }
        this.sourceFileName = NO_SOURCE_FILE_NAME;
        if (this.openable.getSourceMapper() != null) {
            if (this.openable instanceof ClassFile) {
                BinaryType type = (BinaryType)((ClassFile)this.openable).getType();
                IBinaryType reader = MatchLocator.classFileReader(type);
                if (reader != null) {
                    String fileName = type.sourceFileName(reader);
                    this.sourceFileName = fileName == null ? NO_SOURCE_FILE_NAME : fileName;
                }
            } else if (this.openable instanceof ModularClassFile) {
                this.sourceFileName = "module-info.java";
            }
        }
        return this.sourceFileName;
    }

    boolean hasSimilarMatch() {
        return this.similarMatch != null && (this.source == NO_SOURCE_FILE || this.isModuleInfo(this));
    }

    public int hashCode() {
        if (this.compoundName == null) {
            return super.hashCode();
        }
        int hashCode = 0;
        int i = 0;
        int length = this.compoundName.length;
        while (i < length) {
            hashCode += CharOperation.hashCode(this.compoundName[i]);
            ++i;
        }
        return hashCode;
    }

    @Override
    public boolean ignoreOptionalProblems() {
        return false;
    }

    private boolean isModuleInfo(PossibleMatch possibleMatch) {
        return CharOperation.equals(this.getMainTypeName(), TypeConstants.MODULE_INFO_NAME);
    }

    void setSimilarMatch(PossibleMatch possibleMatch) {
        possibleMatch.source = this.isModuleInfo(possibleMatch) ? null : NO_SOURCE_FILE;
        this.similarMatch = possibleMatch;
    }

    public String toString() {
        return this.openable == null ? "Fake PossibleMatch" : this.openable.toString();
    }

    @Override
    public char[] getModuleName() {
        IModuleDescription moduleDescription;
        if (this.openable instanceof CompilationUnit) {
            return ((CompilationUnit)this.openable).getModuleName();
        }
        if (this.openable instanceof ClassFile && (moduleDescription = this.openable.getPackageFragmentRoot().getModuleDescription()) != null) {
            return moduleDescription.getElementName().toCharArray();
        }
        return null;
    }
}

