/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.loggers.views;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.model.IntegrationDecorator;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationListenerSync;
import org.eclipse.stem.jobs.simulation.SimulationManager;
import org.eclipse.stem.util.loggers.views.IRemoveListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class LoggerControl
extends Composite
implements ISimulationListenerSync,
ISelectionProvider {
    protected RelativeValueProviderAdapter rvp;
    protected Label simulationNameLabel;
    protected ISimulation simulation = null;
    protected IntegrationDecorator diseaseModel = null;
    protected Map<Node, Integer> nodeLevels;
    protected final List<ISelectionChangedListener> listeners = new CopyOnWriteArrayList<ISelectionChangedListener>();
    protected final List<IRemoveListener> removeListeners = new CopyOnWriteArrayList<IRemoveListener>();
    ISelection selection = null;
    protected static final int MARGIN_WIDTH = 5;
    protected static final int MARGIN_HEIGHT = 5;

    public LoggerControl(Composite parent, int style) {
        super(parent, style);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LoggerControl.this.dispose();
            }
        });
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.setLayout((Layout)layout);
    }

    protected Composite createTopComposite(Composite parent) {
        return parent;
    }

    public abstract void remove();

    public void addIRemoveListener(IRemoveListener listener) {
        this.removeListeners.add(listener);
    }

    public void removeIRemoveListener(IRemoveListener listener) {
        this.removeListeners.remove(listener);
    }

    public void fireRemoveEvent(Identifiable ident) {
        for (IRemoveListener listener : this.removeListeners) {
            listener.identifiableRemoved(ident);
        }
    }

    public final void setSimulation(ISimulation simulation) {
        if (this.simulation == simulation) {
            return;
        }
        if (this.simulation != null) {
            this.simulation.removeSimulationListenerSync((ISimulationListenerSync)this);
        }
        this.nodeLevels = this.getNodeLevels(simulation);
        this.simulation = simulation;
        this.selection = null;
        if (this.simulation != null) {
            this.simulation.addSimulationListenerSync((ISimulationListenerSync)this, false);
            this.initializeFromSimulation(this.simulation);
        } else {
            this.initializeFromSimulation(null);
        }
        this.refresh2();
    }

    public void setDiseaseModel(IntegrationDecorator dm) {
        this.diseaseModel = dm;
    }

    protected abstract void initializeFromSimulation(ISimulation var1);

    protected abstract void refresh2();

    public final ISelection getSelection() {
        return this.selection;
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
        this.fireSelection(selection);
    }

    public void fireSelection(ISelection selection) {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        for (ISelectionChangedListener listener : this.listeners) {
            listener.selectionChanged(event);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public Map<Node, Integer> getNodeLevels(ISimulation simulation) {
        HashMap<Node, Integer> result = new HashMap<Node, Integer>();
        Graph graph = simulation.getScenario().getCanonicalGraph();
        if (graph != null) {
            EMap allNodes = graph.getNodes();
            Set allGraphURIs = allNodes.keySet();
            Iterator graphIter2 = allGraphURIs.iterator();
            while (graphIter2 != null && graphIter2.hasNext()) {
                URI uri = (URI)graphIter2.next();
                Node node = (Node)allNodes.get((Object)uri);
                if (!SimulationManager.getManager().getGraphPartitioner().isManaged((Identifiable)node) || node.getLabels().size() == 0) continue;
                String id = node.getURI().toString();
                int level = this.getAdminLevel(id);
                result.put(node, level);
            }
        }
        return result;
    }

    private int getAdminLevel(String uriKey) {
        int retVal = 0;
        String test = uriKey;
        while (test.contains("-")) {
            String test2;
            ++retVal;
            int idx1 = test.indexOf("-");
            test = test2 = test.substring(idx1 + 1, test.length());
        }
        return retVal;
    }
}

