/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.loggers.views;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.stem.adapters.time.TimeProvider;
import org.eclipse.stem.core.STEMObjectPool;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.common.CommonPackage;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.IntegrationLabelValue;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.IntegrationDecorator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.populationmodels.standard.PopulationModel;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabel;
import org.eclipse.stem.util.loggers.Activator;
import org.eclipse.stem.util.loggers.views.LogWriter;

public class NewCSVLogWriter
extends LogWriter {
    private static final int BUFSZ = 0x100000;
    private static final String CSV_EXT = ".csv";
    private static final String AIR_TRANSPORT_URI_DUPLICATE_FEATURE = "node/transport/pipe";
    private String directoryName;
    private String logDataObjectName;
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("EEE d MMM yy", Locale.getDefault());
    public static final String TIME_LABEL = "time";
    public static final String ITERATION_LABEL = "iteration";
    public static final String RUN_PARAMETER_FILE_NAME = "runparameters.csv";
    public static final String DECORATOR_FILE_NAME = "decorator.XMI";
    public static final String DECORATOR_RUNPARAM_COLUMN_HEADER = "decorator";
    private int icount = 0;
    private final Map<StateLevelMap, BufferedWriter> fileWriters;
    private boolean logIntegers;
    STEMObjectPool sbPool = new STEMObjectPool(5, 5){

        protected Object createNewObject() {
            return new StringBuilder();
        }

        protected void resetObject(Object o) {
        }
    };
    Map<IntegrationLabelValue, RelativeValueProviderAdapter> labelRelativeValueProviderMap = new HashMap<IntegrationLabelValue, RelativeValueProviderAdapter>();
    Map<Node, Integer> currentNodeLevels = null;
    List<Integer> currentResolutionList = null;
    Map<Integer, List<Node>> currentSortedNodeListMap = null;

    public NewCSVLogWriter(String dirName, ISimulation simulation, IntegrationDecorator dm, boolean logParameters) {
        boolean success;
        this.logIntegers = Activator.getDefault().getPreferenceStore().getBoolean("org.eclipse.stem.logging.integers");
        this.fileWriters = new HashMap<StateLevelMap, BufferedWriter>();
        this.directoryName = dirName;
        this.needsHeader = true;
        this.done = false;
        this.icount = 0;
        if (dm instanceof DiseaseModel) {
            this.logDataObjectName = ((DiseaseModel)dm).getDiseaseName().trim();
        } else if (dm instanceof PopulationModel) {
            this.logDataObjectName = ((PopulationModel)dm).getName().trim();
        }
        if (this.logDataObjectName == null) {
            Activator.logError("Failed to find a disease or population model.  Cannot create CSV Logger", null);
            return;
        }
        this.directoryName = String.valueOf(this.directoryName) + this.logDataObjectName + sep;
        this.directoryName = this.directoryName.replaceAll("\"", "");
        File dir = new File(this.directoryName);
        if (!(dir.exists() && dir.isDirectory() || (success = dir.mkdirs()))) {
            Activator.logError("Failed to Create Driectory" + this.directoryName, new IOException("Failed to Create Driectory" + this.directoryName));
        }
        if (logParameters) {
            this.logRunParameters(dm);
        }
    }

    @Override
    public void logHeader(RelativeValueProviderAdapter rvp) {
    }

    @Override
    public void logHeader(ISimulation sim, IntegrationDecorator dm, Map<Node, Integer> nodeLevels, TimeProvider timeProvider) {
        boolean success;
        int headerItemCount = 0;
        String dirs = this.directoryName;
        File dir = new File(dirs);
        if (!dir.exists() && !(success = dir.mkdirs())) {
            Activator.logError("Failed to Create Driectory" + this.directoryName, new IOException("Failed to Create Driectory" + this.directoryName));
        }
        int minLevel = Integer.MAX_VALUE;
        int maxLevel = -1;
        for (int level : nodeLevels.values()) {
            if (level < minLevel) {
                minLevel = level;
            }
            if (level <= maxLevel) continue;
            maxLevel = level;
        }
        try {
            List<String> populationIdentifiers = this.getPopulationIdentifiers(dm);
            for (String pid : populationIdentifiers) {
                IntegrationLabel label = null;
                for (DynamicLabel l : dm.getLabelsToUpdate()) {
                    if (!(l instanceof IntegrationLabel)) continue;
                    label = (IntegrationLabel)this.getMatchingLabel(dm, ((IntegrationLabel)l).getNode(), pid);
                    break;
                }
                if (label == null) {
                    Activator.logError("Cannot log, no label found for decorator!", new Exception());
                    return;
                }
                IntegrationLabelValue lval = (IntegrationLabelValue)label.getCurrentValue();
                RelativeValueProviderAdapter rvp = (RelativeValueProviderAdapter)RelativeValueProviderAdapterFactory.INSTANCE.adapt((Notifier)lval, RelativeValueProvider.class);
                rvp.setTarget((Notifier)lval);
                List properties = rvp.getProperties();
                lval.eAdapters().clear();
                if (properties == null) {
                    Activator.logError("Cannot retrieve properties for " + label, null);
                }
                for (IItemPropertyDescriptor property : properties) {
                    int level = minLevel;
                    while (level <= maxLevel) {
                        boolean fileHasData = false;
                        StateLevelMap slm = new StateLevelMap(pid, property.getDisplayName((Object)property), level);
                        File pdir = new File(String.valueOf(dirs) + pid + sep);
                        if (!pdir.exists() && !pdir.mkdir()) {
                            throw new IOException("Error creating log store directories: " + pdir.getAbsolutePath());
                        }
                        String file = String.valueOf(dirs) + pid + sep + property.getDisplayName((Object)property) + "_" + level + CSV_EXT;
                        BufferedWriter fw = new BufferedWriter(new FileWriter(file), 0x100000);
                        List<Node> nodeList = this.getNodeList(level, nodeLevels);
                        fw.write(ITERATION_LABEL);
                        fw.write(",");
                        fw.write(TIME_LABEL);
                        int nodeCount = 0;
                        int i = 0;
                        while (i < nodeList.size()) {
                            Node node = nodeList.get(i);
                            NodeLabel mLabel = this.getMatchingLabel(dm, node, pid);
                            if (mLabel != null) {
                                this.labelRelativeValueProviderMap.put((IntegrationLabelValue)mLabel.getCurrentValue(), rvp);
                                String nodeURI = node.getURI().toString();
                                if (nodeURI.indexOf(AIR_TRANSPORT_URI_DUPLICATE_FEATURE) < 0) {
                                    fileHasData = true;
                                    String id = this.filterLocationId(node.getURI().toString());
                                    fw.write(",");
                                    fw.write(id);
                                    ++headerItemCount;
                                    ++nodeCount;
                                }
                            }
                            ++i;
                        }
                        fw.write("\n");
                        if (fileHasData) {
                            this.fileWriters.put(slm, fw);
                        } else {
                            fw.flush();
                            fw.close();
                            File toDelete = new File(file);
                            toDelete.delete();
                            fw = null;
                        }
                        ++level;
                    }
                }
            }
            this.needsHeader = false;
        }
        catch (IOException ioe) {
            Activator.logError("Error writing log header ", ioe);
        }
    }

    private NodeLabel getMatchingLabel(IntegrationDecorator dm, Node n, String popId) {
        for (NodeLabel label : n.getLabels()) {
            if (dm instanceof DiseaseModel && label instanceof DiseaseModelLabel && ((DiseaseModelLabel)label).getDecorator().equals(dm) && ((DiseaseModelLabel)label).getPopulationModelLabel().getPopulationIdentifier().equals(popId)) {
                return label;
            }
            if (!(dm instanceof PopulationModel) || !(label instanceof PopulationModelLabel) || !((PopulationModelLabel)label).getDecorator().equals(dm) || !((PopulationModelLabel)label).getPopulationIdentifier().equals(popId)) continue;
            return label;
        }
        return null;
    }

    private List<String> getPopulationIdentifiers(IntegrationDecorator id) {
        if (id instanceof DiseaseModel) {
            return ((DiseaseModel)id).getAllLabelIdentifiers();
        }
        if (id instanceof PopulationModel) {
            return ((PopulationModel)id).getAllLabelIdentifiers();
        }
        return null;
    }

    public void logRunParameters(IntegrationDecorator dm) {
        if (dm == null) {
            return;
        }
        try {
            FileWriter fwp = new FileWriter(String.valueOf(this.directoryName) + RUN_PARAMETER_FILE_NAME);
            ComposedAdapterFactory itemProviderFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            IItemPropertySource propertySource = (IItemPropertySource)itemProviderFactory.adapt((Notifier)dm, IItemPropertySource.class);
            List properties = propertySource.getPropertyDescriptors((Object)dm);
            StringBuilder header = new StringBuilder();
            StringBuilder values = new StringBuilder();
            int i = 0;
            while (i < properties.size()) {
                IItemPropertyDescriptor descriptor = (IItemPropertyDescriptor)properties.get(i);
                EStructuralFeature feature = (EStructuralFeature)descriptor.getFeature(null);
                EClass containingClass = feature.getEContainingClass();
                if (!containingClass.equals(CommonPackage.eINSTANCE.getDublinCore())) {
                    Object value = dm.eGet(feature);
                    header.append(feature.getName());
                    header.append(",");
                    value = value.toString().replace(',', ' ');
                    value = value.toString().replace('\n', ' ');
                    values.append(value.toString().replace(',', ' '));
                    values.append(",");
                }
                ++i;
            }
            header.setLength(header.length() - 1);
            values.setLength(values.length() - 1);
            header.insert(0, "decorator,");
            String className = dm.getClass().getName();
            values.insert(0, String.valueOf(className) + ",");
            fwp.write(header.toString());
            fwp.write("\n");
            fwp.write(values.toString());
            fwp.flush();
            fwp.close();
            URI serializationURI = URI.createFileURI((String)(String.valueOf(this.directoryName) + DECORATOR_FILE_NAME));
            Decorator copyDM = (Decorator)EcoreUtil.copy((EObject)dm);
            Utility.serializeIdentifiableKeepDefaults((Identifiable)copyDM, (URI)serializationURI);
            copyDM = null;
        }
        catch (IOException e) {
            Activator.logError("Error creating file writer for RUNPARAMETER ", e);
        }
    }

    @Override
    public void logData(RelativeValueProviderAdapter rvp, TimeProvider timeProvider) {
    }

    @Override
    public void logData(ISimulation sim, IntegrationDecorator dm, Map<Node, Integer> nodeLevels, TimeProvider timeProvider, boolean beforeStart) {
        ++this.icount;
        List<String> decoratorPopulations = this.getPopulationIdentifiers(dm);
        HashSet<StateLevelMap> firstNode = new HashSet<StateLevelMap>();
        firstNode.addAll(this.fileWriters.keySet());
        try {
            List properties;
            RelativeValueProviderAdapter rvp;
            Node n;
            int j;
            List<Node> nodeList;
            int resolution;
            List<Integer> resolutionList = this.getResolutionList(nodeLevels);
            int i = 0;
            while (i < resolutionList.size()) {
                resolution = resolutionList.get(i);
                nodeList = this.getNodeList(resolution, nodeLevels);
                j = 0;
                while (j < nodeList.size()) {
                    n = nodeList.get(j);
                    for (String popId : decoratorPopulations) {
                        NodeLabel mLabel = this.getMatchingLabel(dm, n, popId);
                        if (mLabel == null || !(mLabel instanceof IntegrationLabel)) continue;
                        IntegrationLabel dmLabel = (IntegrationLabel)mLabel;
                        IntegrationLabelValue dmlv = (IntegrationLabelValue)dmLabel.getCurrentValue();
                        rvp = this.labelRelativeValueProviderMap.get(dmlv);
                        if (rvp == null) {
                            Activator.logError("Error no rvp found for label " + mLabel, new Exception());
                        }
                        rvp.setTarget((Notifier)dmlv);
                        properties = rvp.getProperties();
                        dmlv.eAdapters().clear();
                        StringBuilder sb = (StringBuilder)this.sbPool.get();
                        int k = 0;
                        while (k < properties.size()) {
                            sb.setLength(0);
                            IItemPropertyDescriptor itemDescriptor = (IItemPropertyDescriptor)properties.get(k);
                            StateLevelMap slm = new StateLevelMap(popId, itemDescriptor.getDisplayName((Object)itemDescriptor), resolution);
                            BufferedWriter fw = this.fileWriters.get(slm);
                            if (fw == null) {
                                Activator.logError("Error, no file writer found for " + slm, null);
                            } else {
                                if (firstNode.contains(slm)) {
                                    firstNode.remove(slm);
                                    sb.append(this.icount);
                                    sb.append(",");
                                    STEMTime time = timeProvider.getTime();
                                    if (time == null) {
                                        time = sim.getScenario().getSequencer().getStartTime();
                                    }
                                    if (!beforeStart) {
                                        time = time.addIncrement(sim.getScenario().getSequencer().getTimeDelta());
                                    }
                                    String timeString = dateFormat.format(time.getTime());
                                    sb.append(timeString);
                                }
                                EStructuralFeature feature = (EStructuralFeature)itemDescriptor.getFeature(null);
                                double value = dmlv.eGetDouble(((EAttribute)feature).getFeatureID());
                                sb.append(",");
                                if (this.logIntegers) {
                                    sb.append(Math.rint(value));
                                } else {
                                    sb.append(value);
                                }
                                int sbLength = sb.length();
                                int l = 0;
                                while (l < sbLength) {
                                    fw.write(sb.charAt(l));
                                    ++l;
                                }
                            }
                            ++k;
                        }
                        this.sbPool.release((Object)sb);
                    }
                    ++j;
                }
                ++i;
            }
            resolutionList = this.getResolutionList(nodeLevels);
            i = 0;
            while (i < resolutionList.size()) {
                resolution = resolutionList.get(i);
                nodeList = this.getNodeList(resolution, nodeLevels);
                j = 0;
                while (j < nodeList.size()) {
                    n = nodeList.get(j);
                    boolean wroteEOL = false;
                    for (String popId : decoratorPopulations) {
                        NodeLabel mLabel = this.getMatchingLabel(dm, n, popId);
                        if (mLabel == null || !(mLabel instanceof IntegrationLabel)) continue;
                        IntegrationLabelValue lval = (IntegrationLabelValue)mLabel.getCurrentValue();
                        rvp = this.labelRelativeValueProviderMap.get(lval);
                        if (rvp == null) {
                            Activator.logError("Error no rvp found for label " + mLabel, new Exception());
                        }
                        rvp.setTarget((Notifier)lval);
                        properties = rvp.getProperties();
                        int k = 0;
                        while (k < properties.size()) {
                            StateLevelMap slm = new StateLevelMap(popId, ((IItemPropertyDescriptor)properties.get(k)).getDisplayName(properties.get(k)), resolution);
                            BufferedWriter fw = this.fileWriters.get(slm);
                            fw.write("\n");
                            ++k;
                        }
                        wroteEOL = true;
                    }
                    if (wroteEOL) break;
                    ++j;
                }
                ++i;
            }
            this.needsHeader = false;
        }
        catch (IOException ioe) {
            Activator.logError("Error writing log header ", ioe);
        }
        this.currentNodeLevels = nodeLevels;
    }

    @Override
    public void flushLoggerData() {
        Collection<BufferedWriter> writers = this.fileWriters.values();
        for (BufferedWriter writer : writers) {
            try {
                writer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void closeLoggerData() {
        Collection<BufferedWriter> writers = this.fileWriters.values();
        for (BufferedWriter writer : writers) {
            try {
                writer.close();
            }
            catch (IOException ioe) {
                Activator.logError("Cannot close log file", ioe);
            }
        }
    }

    private List<Integer> getResolutionList(Map<Node, Integer> nodeLevels) {
        if (nodeLevels == this.currentNodeLevels) {
            return this.currentResolutionList;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        Collection<Integer> vals = nodeLevels.values();
        for (int level : vals) {
            if (list.contains(level)) continue;
            list.add(level);
        }
        this.currentResolutionList = list;
        return list;
    }

    private List<Node> getNodeList(int level, Map<Node, Integer> nodeLevels) {
        if (nodeLevels == this.currentNodeLevels) {
            return this.currentSortedNodeListMap.get(level);
        }
        ArrayList<Node> list = new ArrayList<Node>();
        for (Map.Entry<Node, Integer> entry : nodeLevels.entrySet()) {
            if (entry.getValue() != level) continue;
            boolean write = false;
            for (NodeLabel s : entry.getKey().getLabels()) {
                if (!(s instanceof IntegrationLabel)) continue;
                write = true;
                break;
            }
            if (!write || entry.getKey().getURI().toString().indexOf(AIR_TRANSPORT_URI_DUPLICATE_FEATURE) != -1) continue;
            list.add(entry.getKey());
        }
        Collections.sort(list, new Comparator<Node>(){

            @Override
            public int compare(Node n1, Node n2) {
                String s1 = n1.getURI().toString();
                String s2 = n2.getURI().toString();
                return s1.compareTo(s2);
            }
        });
        if (this.currentSortedNodeListMap == null) {
            this.currentSortedNodeListMap = new HashMap<Integer, List<Node>>();
        }
        this.currentSortedNodeListMap.put(level, list);
        return list;
    }

    private String filterLocationId(String unfiltered) {
        int last = unfiltered.indexOf("/node/geo/region/");
        if (last >= 0) {
            return unfiltered.substring(last += "/node/geo/region/".length(), unfiltered.length());
        }
        return unfiltered;
    }

    @Override
    public String getDirectoryName() {
        return this.directoryName;
    }

    @Override
    public String getLogDataObjectName() {
        return this.logDataObjectName;
    }

    private static class StateLevelMap {
        private final String popId;
        private final String state;
        private final int level;

        public StateLevelMap(String popId, String state, int level) {
            this.popId = popId;
            this.state = state;
            this.level = level;
        }

        public String getPopulationId() {
            return this.popId;
        }

        public int getLevel() {
            return this.level;
        }

        public String getState() {
            return this.state;
        }

        public int hashCode() {
            return this.state.hashCode() + this.popId.hashCode() + this.level;
        }

        public boolean equals(Object o) {
            if (!(o instanceof StateLevelMap)) {
                return false;
            }
            StateLevelMap slm = (StateLevelMap)o;
            return slm.getState().equals(this.state) && slm.getPopulationId().equals(this.popId) && slm.getLevel() == this.level;
        }

        public String toString() {
            return String.valueOf(this.popId) + " - " + this.state + "_" + this.level;
        }
    }
}

