/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.update;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.provisional.AbstractModelProxy;
import org.eclipse.debug.internal.ui.viewers.update.DebugEventHandler;

public abstract class EventHandlerModelProxy
extends AbstractModelProxy
implements IDebugEventSetListener {
    private Map fTimerTasks = new HashMap();
    private Timer fTimer = new Timer(true);
    private Map fPendingSuspends = new HashMap();
    private DebugEventHandler[] fHandlers = new DebugEventHandler[0];

    protected abstract DebugEventHandler[] createEventHandlers();

    public synchronized void dispose() {
        super.dispose();
        this.fTimer.cancel();
        this.fTimerTasks.clear();
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        int i = 0;
        while (i < this.fHandlers.length) {
            DebugEventHandler handler = this.fHandlers[i];
            handler.dispose();
            ++i;
        }
    }

    public void init(IPresentationContext context) {
        super.init(context);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        this.fHandlers = this.createEventHandlers();
    }

    public final void handleDebugEvents(DebugEvent[] events) {
        if (this.isDisposed()) {
            return;
        }
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (this.containsEvent(event)) {
                int j = 0;
                while (j < this.fHandlers.length) {
                    DebugEventHandler handler = this.fHandlers[j];
                    if (this.isDisposed()) {
                        return;
                    }
                    if (handler.handlesEvent(event)) {
                        switch (event.getKind()) {
                            case 4: {
                                this.dispatchCreate(handler, event);
                                break;
                            }
                            case 8: {
                                this.dispatchTerminate(handler, event);
                                break;
                            }
                            case 2: {
                                this.dispatchSuspend(handler, event);
                                break;
                            }
                            case 1: {
                                this.dispatchResume(handler, event);
                                break;
                            }
                            case 16: {
                                this.dispatchChange(handler, event);
                                break;
                            }
                            default: {
                                this.dispatchOther(handler, event);
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    protected boolean containsEvent(DebugEvent event) {
        return true;
    }

    protected void dispatchCreate(DebugEventHandler handler, DebugEvent event) {
        handler.handleCreate(event);
    }

    protected void dispatchTerminate(DebugEventHandler handler, DebugEvent event) {
        handler.handleTerminate(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchSuspend(DebugEventHandler handler, DebugEvent event) {
        EventHandlerModelProxy eventHandlerModelProxy = this;
        synchronized (eventHandlerModelProxy) {
            TimerTask task = (TimerTask)this.fTimerTasks.remove(event.getSource());
            if (task != null) {
                task.cancel();
            }
        }
        DebugEvent resume = null;
        EventHandlerModelProxy eventHandlerModelProxy2 = this;
        synchronized (eventHandlerModelProxy2) {
            resume = (DebugEvent)this.fPendingSuspends.remove(event.getSource());
        }
        if (resume == null) {
            handler.handleSuspend(event);
        } else {
            handler.handleLateSuspend(event, resume);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchResume(DebugEventHandler handler, DebugEvent event) {
        if (event.isEvaluation() || event.isStepStart()) {
            EventHandlerModelProxy eventHandlerModelProxy = this;
            synchronized (eventHandlerModelProxy) {
                if (!this.isDisposed()) {
                    PendingSuspendTask task = new PendingSuspendTask(handler, event);
                    this.fTimerTasks.put(event.getSource(), task);
                    this.fTimer.schedule((TimerTask)task, 500L);
                }
            }
            if (!this.isDisposed()) {
                handler.handleResumeExpectingSuspend(event);
            }
        } else {
            handler.handleResume(event);
        }
    }

    protected void dispatchChange(DebugEventHandler handler, DebugEvent event) {
        handler.handleChange(event);
    }

    protected void dispatchOther(DebugEventHandler handler, DebugEvent event) {
        handler.handleOther(event);
    }

    protected void dispatchSuspendTimeout(DebugEventHandler handler, DebugEvent resume) {
        handler.handleSuspendTimeout(resume);
    }

    protected int indexOf(Object[] list, Object element) {
        int i = 0;
        while (i < list.length) {
            if (element.equals(list[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private class PendingSuspendTask
    extends TimerTask {
        private DebugEvent fEvent;
        private DebugEventHandler fHandler;

        public PendingSuspendTask(DebugEventHandler handler, DebugEvent resume) {
            this.fHandler = handler;
            this.fEvent = resume;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Map map = EventHandlerModelProxy.this.fPendingSuspends;
            synchronized (map) {
                EventHandlerModelProxy.this.fPendingSuspends.put(this.fEvent.getSource(), this.fEvent);
            }
            EventHandlerModelProxy.this.dispatchSuspendTimeout(this.fHandler, this.fEvent);
        }
    }
}

