/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.apt.pluggable.core;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class Apt6Plugin
extends Plugin {
    private static final SimpleDateFormat TRACE_DATE_FORMAT = new SimpleDateFormat("HH:mm:ss.SSS");
    public static final String PLUGIN_ID = "org.eclipse.jdt.apt.pluggable.core";
    public static final int STATUS_EXCEPTION = 1;
    public static boolean DEBUG = false;
    public static final String APT_DEBUG_OPTION = "org.eclipse.jdt.apt.pluggable.core/debug";
    private static Apt6Plugin thePlugin = null;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        thePlugin = this;
        this.initDebugTracing();
    }

    private void initDebugTracing() {
        String option = Platform.getDebugOption((String)APT_DEBUG_OPTION);
        if (option != null) {
            DEBUG = option.equalsIgnoreCase("true");
        }
    }

    public static Apt6Plugin getPlugin() {
        return thePlugin;
    }

    public static void log(IStatus status) {
        thePlugin.getLog().log(status);
    }

    public static void log(Throwable e, String message) {
        Apt6Plugin.log((IStatus)new Status(4, PLUGIN_ID, 1, message, e));
    }

    public static void logWarning(Throwable e, String message) {
        Apt6Plugin.log((IStatus)Apt6Plugin.createWarningStatus(e, message));
    }

    public static Status createStatus(Throwable e, String message) {
        return new Status(4, PLUGIN_ID, 1, message, e);
    }

    public static Status createWarningStatus(Throwable e, String message) {
        return new Status(2, PLUGIN_ID, 1, message, e);
    }

    public static Status createInfoStatus(Throwable e, String message) {
        return new Status(1, PLUGIN_ID, 1, message, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void trace(String msg) {
        if (DEBUG) {
            StringBuffer sb = new StringBuffer();
            sb.append('[');
            SimpleDateFormat simpleDateFormat = TRACE_DATE_FORMAT;
            synchronized (simpleDateFormat) {
                sb.append(TRACE_DATE_FORMAT.format(new Date()));
            }
            sb.append('-');
            String threadName = Thread.currentThread().getName();
            int dot = threadName.lastIndexOf(46);
            if (dot < 0) {
                sb.append(threadName);
            } else {
                sb.append(threadName.substring(dot + 1));
            }
            sb.append(']');
            sb.append(msg);
            System.out.println(sb);
        }
    }
}

