/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.graphmap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.stem.core.scenario.Scenario;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.SimulationManager;
import org.eclipse.stem.ui.Activator;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class GraphMapPreferences {
    private static final IPath PATH = Activator.getDefault().getStateLocation();
    private static GraphMapPreferences instance;
    public static final String GRAPHVIEWPREFERENCES_FILENAME = "GraphMapCanvas_Preferences.txt";
    private static final String ROOT_KEY = "root";
    public static final String SCENARIO_KEY = "scenario.uri";
    private DialogSettings masterSettings = null;

    private GraphMapPreferences() {
        this.readMasterSettingsFromFile();
        PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                GraphMapPreferences.this.saveMasterSettingsToFile();
                return true;
            }

            public void postShutdown(IWorkbench workbench) {
            }
        });
    }

    public static synchronized GraphMapPreferences getInstance() {
        if (instance == null) {
            instance = new GraphMapPreferences();
        }
        return instance;
    }

    public int getNoOfPreferencesForScenario(String scenario) {
        IDialogSettings[] sections = this.masterSettings.getSections();
        int counter = 0;
        int i = 0;
        while (i < sections.length) {
            if (scenario.equals(sections[i].get(SCENARIO_KEY))) {
                ++counter;
            }
            ++i;
        }
        return counter;
    }

    public void updatePreferenceState(int viewId, ISimulation sim, String key, Object value) {
        IDialogSettings section = this.getPreferencesFor(viewId, sim.getScenario());
        while (section == null) {
            section = this.masterSettings.addNewSection(UUID.randomUUID().toString());
            section.put(SCENARIO_KEY, sim.getScenario().getURI().toString());
            section = this.getPreferencesFor(viewId, sim.getScenario());
        }
        section.put(key, value.toString());
    }

    public void disposePreferencesForActiveSimulations(int viewId) {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            StringWriter s = new StringWriter();
            this.masterSettings.save((Writer)s);
            Document doc = docBuilder.parse(new ByteArrayInputStream(s.toString().getBytes()));
            for (ISimulation sim : SimulationManager.getManager().getActiveSimulations()) {
                IDialogSettings scenarioSec = this.getPreferencesFor(viewId, sim.getScenario());
                if (scenarioSec == null) continue;
                String name = scenarioSec.getName();
                XPath xpath = XPathFactory.newInstance().newXPath();
                String expression = String.format("/section/section[@name=\"%s\"]", name);
                Node secNode = (Node)xpath.evaluate(expression, doc, XPathConstants.NODE);
                Node p = secNode.getParentNode();
                p.removeChild(secNode);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(out);
            transformer.transform(source, result);
            this.masterSettings = new DialogSettings(ROOT_KEY);
            this.masterSettings.load((Reader)new StringReader(new String(out.toByteArray())));
        }
        catch (ParserConfigurationException e) {
            Activator.logError("Unable to dispose preferences", e);
        }
        catch (IOException e) {
            Activator.logError("Unable to dispose preferences", e);
            e.printStackTrace();
        }
        catch (SAXException e) {
            Activator.logError("Unable to dispose preferences", e);
            e.printStackTrace();
        }
        catch (XPathExpressionException e) {
            Activator.logError("Unable to dispose preferences", e);
            e.printStackTrace();
        }
        catch (TransformerConfigurationException e) {
            Activator.logError("Unable to dispose preferences", e);
            e.printStackTrace();
        }
        catch (TransformerException e) {
            Activator.logError("Unable to dispose preferences", e);
            e.printStackTrace();
        }
    }

    public IDialogSettings getPreferencesFor(int viewId, Scenario scenario) {
        IDialogSettings[] sections = this.masterSettings.getSections();
        int counter = 0;
        int i = 0;
        while (i < sections.length) {
            if (scenario.getURI().toString().equals(sections[i].get(SCENARIO_KEY)) && counter++ == viewId) {
                return sections[i];
            }
            ++i;
        }
        return null;
    }

    public void saveMasterSettingsToFile() {
        try {
            this.masterSettings.save(this.getPrefFileName());
        }
        catch (IOException e) {
            Activator.logError("Unable to save preferences", e);
        }
    }

    public void readMasterSettingsFromFile() {
        this.masterSettings = new DialogSettings(ROOT_KEY);
        String filename = this.getPrefFileName();
        File f = new File(filename);
        if (f.exists()) {
            try {
                this.masterSettings.load(filename);
            }
            catch (IOException ioe) {
                Activator.logError("exception loading file [" + ioe.getMessage() + "]", ioe);
            }
        } else {
            try {
                this.masterSettings.save(filename);
            }
            catch (IOException ioe) {
                Activator.logError("exception creating file [" + ioe.getMessage() + "]", ioe);
            }
        }
    }

    public String getPrefFileName() {
        String filename = PATH.append(GRAPHVIEWPREFERENCES_FILENAME).toOSString();
        return filename;
    }

    public class PreferencesChangedEvent {
        private int viewId;
        private IDialogSettings settings;

        public PreferencesChangedEvent(int viewId, IDialogSettings settings) {
            this.viewId = viewId;
            this.settings = settings;
        }

        public int getViewId() {
            return this.viewId;
        }

        public IDialogSettings getNewSettings() {
            return this.settings;
        }
    }
}

