/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.xbase.scoping.batch.FeatureScopeProvider;
import org.eclipse.xtext.xbase.scoping.batch.IBatchScopeProvider;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.TypeScopeProvider;
import org.eclipse.xtext.xbase.scoping.batch.XbaseScopeSessionProvider;
import org.eclipse.xtext.xbase.scoping.batch.XtypeScopeProvider;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;

public class XbaseBatchScopeProvider
extends XtypeScopeProvider
implements IBatchScopeProvider {
    @Inject
    private XbaseScopeSessionProvider scopeSession;
    @Inject
    private TypeScopeProvider typeScopeProvider;
    @Inject
    private FeatureScopeProvider featureScopeProvider;
    @Inject
    @Named(value="org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider.delegate")
    private IScopeProvider delegate;

    public IScope getScope(EObject context, EReference reference) {
        if (this.isConstructorCallScope(reference)) {
            return this.delegateGetScope(context, reference);
        }
        if (this.isTypeScope(reference)) {
            IScope parent = this.delegateGetScope(context, reference);
            return this.typeScopeProvider.createTypeScope(parent, context, reference);
        }
        if (this.isFeatureCallScope(reference)) {
            IFeatureScopeSession session = this.newSession(context.eResource());
            session = session.recursiveInitialize(context);
            return session.createFeatureCallScope(context, reference, IResolvedTypes.NULL);
        }
        return this.delegateGetScope(context, reference);
    }

    public IFeatureScopeSession newSession(Resource context) {
        return this.scopeSession.withContext(context);
    }

    protected IScope delegateGetScope(EObject context, EReference reference) {
        return this.getDelegate().getScope(context, reference);
    }

    public void setDelegate(IScopeProvider delegate) {
        this.delegate = delegate;
    }

    public IScopeProvider getDelegate() {
        return this.delegate;
    }

    protected boolean isTypeScope(EReference reference) {
        return TypesPackage.Literals.JVM_TYPE.isSuperTypeOf(reference.getEReferenceType());
    }

    protected boolean isConstructorCallScope(EReference reference) {
        return reference.getEReferenceType() == TypesPackage.Literals.JVM_CONSTRUCTOR;
    }

    public boolean isFeatureCallScope(EReference reference) {
        return this.featureScopeProvider.isFeatureCallScope(reference);
    }
}

