/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.util.IdentityHashMap;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenWrapper;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.index.Payload;
import org.apache.lucene.util.Attribute;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeSource;

public abstract class TokenStream
extends AttributeSource {
    private static final AttributeSource.AttributeFactory DEFAULT_TOKEN_WRAPPER_ATTRIBUTE_FACTORY;
    private final TokenWrapper tokenWrapper;
    private static boolean onlyUseNewAPI;
    private final MethodSupport supportedMethods = TokenStream.getSupportedMethods(this.getClass());
    private static final IdentityHashMap knownMethodSupport;
    static /* synthetic */ Class class$org$apache$lucene$analysis$Token;
    static /* synthetic */ Class class$org$apache$lucene$analysis$TokenWrapper;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MethodSupport getSupportedMethods(Class clazz) {
        MethodSupport supportedMethods;
        IdentityHashMap identityHashMap = knownMethodSupport;
        synchronized (identityHashMap) {
            supportedMethods = (MethodSupport)knownMethodSupport.get(clazz);
            if (supportedMethods == null) {
                supportedMethods = new MethodSupport(clazz);
                knownMethodSupport.put(clazz, supportedMethods);
            }
        }
        return supportedMethods;
    }

    protected TokenStream() {
        super(onlyUseNewAPI ? AttributeSource.AttributeFactory.DEFAULT_ATTRIBUTE_FACTORY : DEFAULT_TOKEN_WRAPPER_ATTRIBUTE_FACTORY);
        this.tokenWrapper = this.initTokenWrapper(null);
        this.check();
    }

    protected TokenStream(AttributeSource input) {
        super(input);
        this.tokenWrapper = this.initTokenWrapper(input);
        this.check();
    }

    protected TokenStream(AttributeSource.AttributeFactory factory) {
        super(onlyUseNewAPI ? factory : new TokenWrapperAttributeFactory(factory));
        this.tokenWrapper = this.initTokenWrapper(null);
        this.check();
    }

    private TokenWrapper initTokenWrapper(AttributeSource input) {
        if (onlyUseNewAPI) {
            return null;
        }
        if (input instanceof TokenStream && ((TokenStream)input).tokenWrapper != null) {
            return ((TokenStream)input).tokenWrapper;
        }
        Attribute att = this.addAttribute(TermAttribute.class);
        if (att instanceof TokenWrapper && this.addAttribute(TypeAttribute.class) == att && this.addAttribute(PositionIncrementAttribute.class) == att && this.addAttribute(FlagsAttribute.class) == att && this.addAttribute(OffsetAttribute.class) == att && this.addAttribute(PayloadAttribute.class) == att) {
            return (TokenWrapper)att;
        }
        throw new UnsupportedOperationException("If onlyUseNewAPI is disabled, all basic Attributes must be implemented by the internal class TokenWrapper. Please make sure, that all TokenStreams/TokenFilters in this chain have been instantiated with this flag disabled and do not add any custom instances for the basic Attributes!");
    }

    private void check() {
        if (onlyUseNewAPI && !this.supportedMethods.hasIncrementToken) {
            throw new UnsupportedOperationException(this.getClass().getName() + " does not implement incrementToken() which is needed for onlyUseNewAPI.");
        }
        if (!(this.supportedMethods.hasIncrementToken || this.supportedMethods.hasNext || this.supportedMethods.hasReusableNext)) {
            throw new UnsupportedOperationException(this.getClass().getName() + " does not implement any of incrementToken(), next(Token), next().");
        }
    }

    public static void setOnlyUseNewAPI(boolean onlyUseNewAPI) {
        TokenStream.onlyUseNewAPI = onlyUseNewAPI;
    }

    public static boolean getOnlyUseNewAPI() {
        return onlyUseNewAPI;
    }

    public boolean incrementToken() throws IOException {
        Token token;
        if (!$assertionsDisabled && this.tokenWrapper == null) {
            throw new AssertionError();
        }
        if (this.supportedMethods.hasReusableNext) {
            token = this.next(this.tokenWrapper.delegate);
        } else {
            if (!$assertionsDisabled && !this.supportedMethods.hasNext) {
                throw new AssertionError();
            }
            token = this.next();
        }
        if (token == null) {
            return false;
        }
        this.tokenWrapper.delegate = token;
        return true;
    }

    public void end() throws IOException {
    }

    public Token next(Token reusableToken) throws IOException {
        if (!$assertionsDisabled && reusableToken == null) {
            throw new AssertionError();
        }
        if (this.tokenWrapper == null) {
            throw new UnsupportedOperationException("This TokenStream only supports the new Attributes API.");
        }
        if (this.supportedMethods.hasIncrementToken) {
            this.tokenWrapper.delegate = reusableToken;
            return this.incrementToken() ? this.tokenWrapper.delegate : null;
        }
        if (!$assertionsDisabled && !this.supportedMethods.hasNext) {
            throw new AssertionError();
        }
        return this.next();
    }

    public Token next() throws IOException {
        Payload p;
        Token nextToken;
        if (this.tokenWrapper == null) {
            throw new UnsupportedOperationException("This TokenStream only supports the new Attributes API.");
        }
        if (this.supportedMethods.hasIncrementToken) {
            Token savedDelegate = this.tokenWrapper.delegate;
            this.tokenWrapper.delegate = new Token();
            nextToken = this.incrementToken() ? this.tokenWrapper.delegate : null;
            this.tokenWrapper.delegate = savedDelegate;
        } else {
            if (!$assertionsDisabled && !this.supportedMethods.hasReusableNext) {
                throw new AssertionError();
            }
            nextToken = this.next(new Token());
        }
        if (nextToken != null && (p = nextToken.getPayload()) != null) {
            nextToken.setPayload((Payload)p.clone());
        }
        return nextToken;
    }

    public void reset() throws IOException {
    }

    public void close() throws IOException {
    }

    static {
        $assertionsDisabled = !TokenStream.class.desiredAssertionStatus();
        DEFAULT_TOKEN_WRAPPER_ATTRIBUTE_FACTORY = new TokenWrapperAttributeFactory(AttributeSource.AttributeFactory.DEFAULT_ATTRIBUTE_FACTORY);
        onlyUseNewAPI = false;
        knownMethodSupport = new IdentityHashMap();
    }

    private static final class MethodSupport {
        final boolean hasIncrementToken;
        final boolean hasReusableNext;
        final boolean hasNext;
        private static final Class[] METHOD_NO_PARAMS = new Class[0];
        private static final Class[] METHOD_TOKEN_PARAM = new Class[]{class$org$apache$lucene$analysis$Token == null ? (class$org$apache$lucene$analysis$Token = TokenStream.class$("org.apache.lucene.analysis.Token")) : class$org$apache$lucene$analysis$Token};

        MethodSupport(Class clazz) {
            this.hasIncrementToken = MethodSupport.isMethodOverridden(clazz, "incrementToken", METHOD_NO_PARAMS);
            this.hasReusableNext = MethodSupport.isMethodOverridden(clazz, "next", METHOD_TOKEN_PARAM);
            this.hasNext = MethodSupport.isMethodOverridden(clazz, "next", METHOD_NO_PARAMS);
        }

        private static boolean isMethodOverridden(Class clazz, String name, Class[] params) {
            try {
                return clazz.getMethod(name, params).getDeclaringClass() != (class$org$apache$lucene$analysis$TokenStream == null ? (class$org$apache$lucene$analysis$TokenStream = TokenStream.class$("org.apache.lucene.analysis.TokenStream")) : class$org$apache$lucene$analysis$TokenStream);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static final class TokenWrapperAttributeFactory
    extends AttributeSource.AttributeFactory {
        private final AttributeSource.AttributeFactory delegate;

        private TokenWrapperAttributeFactory(AttributeSource.AttributeFactory delegate) {
            this.delegate = delegate;
        }

        public AttributeImpl createAttributeInstance(Class attClass) {
            return attClass.isAssignableFrom(class$org$apache$lucene$analysis$TokenWrapper == null ? (class$org$apache$lucene$analysis$TokenWrapper = TokenStream.class$("org.apache.lucene.analysis.TokenWrapper")) : class$org$apache$lucene$analysis$TokenWrapper) ? new TokenWrapper() : this.delegate.createAttributeInstance(attClass);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof TokenWrapperAttributeFactory) {
                TokenWrapperAttributeFactory af = (TokenWrapperAttributeFactory)other;
                return this.delegate.equals(af.delegate);
            }
            return false;
        }

        public int hashCode() {
            return this.delegate.hashCode() ^ 0xA45FF31;
        }
    }
}

