/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.Property;
import org.eclipse.ant.internal.ui.preferences.AntObjectLabelProvider;
import org.eclipse.ant.internal.ui.preferences.AntPreferencesMessages;
import org.eclipse.ant.internal.ui.preferences.AntPropertiesBlock;
import org.eclipse.ant.internal.ui.preferences.AntRuntimePreferencePage;
import org.eclipse.ant.internal.ui.preferences.IAntBlockContainer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.PlatformUI;

public class AntPropertiesPage
implements IAntBlockContainer {
    private AntPropertiesBlock antPropertiesBlock = new AntPropertiesBlock(this);
    private AntRuntimePreferencePage preferencePage;

    public AntPropertiesPage(AntRuntimePreferencePage preferencePage) {
        this.preferencePage = preferencePage;
    }

    protected TabItem createTabItem(TabFolder folder) {
        TabItem item = new TabItem(folder, 0);
        item.setText(AntPreferencesMessages.AntPropertiesPage_title);
        item.setImage(AntObjectLabelProvider.getPropertyImage());
        item.setData((Object)this);
        item.setControl((Control)this.createContents((Composite)folder));
        return item;
    }

    protected Composite createContents(Composite parent) {
        Font font = parent.getFont();
        Composite top = new Composite(parent, 0);
        top.setFont(font);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)top, "org.eclipse.ant.ui.ant_properties_page_context");
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        top.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        top.setLayoutData((Object)gridData);
        this.antPropertiesBlock.createControl(top, AntPreferencesMessages.AntPropertiesPage__Global_properties__1, AntPreferencesMessages.AntPropertiesPage_Glo_bal_property_files__2);
        return top;
    }

    protected void initialize() {
        List allProperties = AntCorePlugin.getPlugin().getPreferences().getDefaultProperties();
        allProperties.addAll(Arrays.asList(AntCorePlugin.getPlugin().getPreferences().getCustomProperties()));
        this.antPropertiesBlock.setPropertiesInput(allProperties.toArray(new Property[allProperties.size()]));
        this.antPropertiesBlock.setPropertyFilesInput(AntCorePlugin.getPlugin().getPreferences().getCustomPropertyFiles(false));
        this.antPropertiesBlock.update();
    }

    protected void performDefaults() {
        List defaultProperties = AntCorePlugin.getPlugin().getPreferences().getDefaultProperties();
        this.antPropertiesBlock.setPropertiesInput(defaultProperties.toArray(new Property[defaultProperties.size()]));
        this.antPropertiesBlock.setPropertyFilesInput(new String[0]);
        this.antPropertiesBlock.update();
    }

    public void saveAdditionalSettings() {
        this.antPropertiesBlock.saveSettings();
    }

    protected String[] getPropertyFiles() {
        Object[] elements = this.antPropertiesBlock.getPropertyFiles();
        String[] files = new String[elements.length];
        int i = 0;
        while (i < elements.length) {
            files[i] = (String)elements[i];
            ++i;
        }
        return files;
    }

    public void setMessage(String message) {
        this.preferencePage.setMessage(message);
    }

    public void setErrorMessage(String message) {
        this.preferencePage.setErrorMessage(message);
    }

    public Button createPushButton(Composite parent, String buttonText) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(buttonText);
        this.preferencePage.setButtonLayoutData(button);
        return button;
    }

    public void update() {
    }

    protected List getProperties() {
        Object[] allProperties = this.antPropertiesBlock.getProperties();
        ArrayList<Property> properties = new ArrayList<Property>(allProperties.length);
        int i = 0;
        while (i < allProperties.length) {
            Property property = (Property)allProperties[i];
            if (!property.isDefault()) {
                properties.add(property);
            }
            ++i;
        }
        return properties;
    }
}

