/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.contentassist;

import java.util.HashMap;
import java.util.TreeSet;
import org.eclipse.pde.internal.core.ischema.ISchemaComplexType;
import org.eclipse.pde.internal.core.ischema.ISchemaCompositor;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.ui.editor.contentassist.XMLElementProposalComparator;

public class XMLElementProposalComputer {
    public static TreeSet computeElementProposal(ISchemaElement sElement, IDocumentElementNode node) {
        HashMap tagNameMap = XMLElementProposalComputer.countXMLChildrenByTagName(node);
        return XMLElementProposalComputer.computeElementProposal(sElement, tagNameMap);
    }

    private static TreeSet computeElementProposal(ISchemaElement sElement, HashMap tagNameMap) {
        TreeSet elementSet = new TreeSet(new XMLElementProposalComparator());
        ISchemaCompositor compositor = ((ISchemaComplexType)sElement.getType()).getCompositor();
        int multiplicityTracker = 1;
        XMLElementProposalComputer.computeCompositorChildProposal(compositor, elementSet, tagNameMap, multiplicityTracker);
        return elementSet;
    }

    private static HashMap countXMLChildrenByTagName(IDocumentElementNode node) {
        IDocumentElementNode[] children = node.getChildNodes();
        HashMap<String, Integer> tagNameMap = new HashMap<String, Integer>();
        int i = 0;
        while (i < children.length) {
            String key = children[i].getXMLTagName();
            if (tagNameMap.containsKey(key)) {
                int value = (Integer)tagNameMap.get(key);
                tagNameMap.put(key, new Integer(++value));
            } else {
                tagNameMap.put(key, new Integer(1));
            }
            ++i;
        }
        return tagNameMap;
    }

    private static void computeCompositorChildProposal(ISchemaCompositor compositor, TreeSet elementSet, HashMap siblings, int multiplicityTracker) {
        if (compositor == null) {
            return;
        }
        if (compositor.getKind() == 1) {
            XMLElementProposalComputer.computeCompositorChoiceProposal(compositor, elementSet, siblings, multiplicityTracker);
        } else if (compositor.getKind() == 2) {
            XMLElementProposalComputer.computeCompositorSequenceProposal(compositor, elementSet, siblings, multiplicityTracker);
        }
    }

    private static void computeCompositorSequenceProposal(ISchemaCompositor compositor, TreeSet elementSet, HashMap siblings, int multiplicityTracker) {
        ISchemaObject[] schemaObject = compositor.getChildren();
        if (multiplicityTracker < Integer.MAX_VALUE) {
            multiplicityTracker = compositor.getMaxOccurs() * multiplicityTracker;
        }
        int i = 0;
        while (i < compositor.getChildCount()) {
            XMLElementProposalComputer.computeObjectChildProposal(schemaObject[i], elementSet, siblings, multiplicityTracker);
            ++i;
        }
    }

    private static void computeCompositorChoiceProposal(ISchemaCompositor compositor, TreeSet elementSet, HashMap siblings, int multiplicityTracker) {
        if (multiplicityTracker < Integer.MAX_VALUE) {
            multiplicityTracker = compositor.getMaxOccurs() * multiplicityTracker;
        }
        XMLElementProposalComputer.adjustChoiceSiblings(compositor, siblings);
        ISchemaObject[] schemaObject = compositor.getChildren();
        int i = 0;
        while (i < compositor.getChildCount()) {
            XMLElementProposalComputer.computeObjectChildProposal(schemaObject[i], elementSet, siblings, multiplicityTracker);
            ++i;
        }
    }

    private static void adjustChoiceSiblings(ISchemaCompositor compositor, HashMap siblings) {
        String name;
        ISchemaObject[] schemaObject = compositor.getChildren();
        int childElementCount = 0;
        int i = 0;
        while (i < compositor.getChildCount()) {
            if (schemaObject[i] instanceof ISchemaElement && siblings.containsKey(name = schemaObject[i].getName())) {
                int occurences = (Integer)siblings.get(name);
                childElementCount += occurences;
            }
            ++i;
        }
        i = 0;
        while (i < compositor.getChildCount()) {
            if (schemaObject[i] instanceof ISchemaElement) {
                name = schemaObject[i].getName();
                siblings.put(name, new Integer(childElementCount));
            }
            ++i;
        }
    }

    private static void computeObjectChildProposal(ISchemaObject schemaObject, TreeSet elementSet, HashMap siblings, int multiplicityTracker) {
        if (schemaObject instanceof ISchemaElement) {
            ISchemaElement schemaElement = (ISchemaElement)schemaObject;
            XMLElementProposalComputer.computeElementChildProposal(schemaElement, elementSet, siblings, multiplicityTracker);
        } else if (schemaObject instanceof ISchemaCompositor) {
            ISchemaCompositor sCompositor = (ISchemaCompositor)schemaObject;
            XMLElementProposalComputer.computeCompositorChildProposal(sCompositor, elementSet, siblings, multiplicityTracker);
        }
    }

    private static void computeElementChildProposal(ISchemaElement schemaElement, TreeSet elementSet, HashMap siblings, int multiplicityTracker) {
        int occurrences = 0;
        if (siblings.containsKey(schemaElement.getName())) {
            occurrences = (Integer)siblings.get(schemaElement.getName());
        }
        if (multiplicityTracker < Integer.MAX_VALUE) {
            multiplicityTracker = schemaElement.getMaxOccurs() * multiplicityTracker;
        }
        if (occurrences < multiplicityTracker) {
            elementSet.add(schemaElement);
        }
    }
}

