/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.grapheditor;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTEventDispatcher;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.EdgeLabel;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.LabelValue;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.graph.impl.EdgeImpl;
import org.eclipse.stem.core.model.Model;
import org.eclipse.stem.definitions.adapters.spatial.geo.InlineLatLongDataProvider;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLong;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProvider;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProviderAdapterFactory;
import org.eclipse.stem.definitions.adapters.spatial.geo.PlatformLatLongDataProvider;
import org.eclipse.stem.definitions.edges.EdgesFactory;
import org.eclipse.stem.definitions.edges.EdgesPackage;
import org.eclipse.stem.definitions.edges.MigrationEdge;
import org.eclipse.stem.definitions.edges.MigrationEdgeLabel;
import org.eclipse.stem.definitions.edges.MigrationEdgeLabelValue;
import org.eclipse.stem.definitions.labels.AreaLabel;
import org.eclipse.stem.definitions.labels.CommonBorderRelationshipLabel;
import org.eclipse.stem.definitions.labels.CommonBorderRelationshipLabelValue;
import org.eclipse.stem.definitions.labels.LabelsFactory;
import org.eclipse.stem.definitions.labels.LabelsPackage;
import org.eclipse.stem.definitions.labels.PopulationLabel;
import org.eclipse.stem.definitions.labels.RelativePhysicalRelationshipLabel;
import org.eclipse.stem.definitions.labels.RoadTransportRelationshipLabel;
import org.eclipse.stem.definitions.labels.RoadTransportRelationshipLabelValue;
import org.eclipse.stem.definitions.labels.impl.RoadTransportRelationshipLabelImpl;
import org.eclipse.stem.definitions.nodes.NodesFactory;
import org.eclipse.stem.definitions.nodes.Region;
import org.eclipse.stem.definitions.transport.PipeTransportEdge;
import org.eclipse.stem.definitions.transport.PipeTransportEdgeLabel;
import org.eclipse.stem.definitions.transport.PipeTransportEdgeLabelValue;
import org.eclipse.stem.definitions.transport.TransportFactory;
import org.eclipse.stem.definitions.transport.TransportPackage;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.grapheditor.ConnectionData;
import org.eclipse.stem.ui.grapheditor.DynamicText;
import org.eclipse.stem.ui.grapheditor.GraphEditorMessages;
import org.eclipse.stem.ui.grapheditor.GraphicsToAWT;
import org.eclipse.stem.ui.grapheditor.NodeData;
import org.eclipse.stem.ui.grapheditor.Polygon;
import org.eclipse.stem.ui.grapheditor.SpatialGmlExporter;
import org.eclipse.stem.ui.grapheditor.TextAndButtonModifyListener;
import org.eclipse.stem.ui.grapheditor.handlers.NewNodeDialog;
import org.eclipse.stem.ui.grapheditor.handlers.SaveInProjectDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphItem;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.core.widgets.IContainer;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class GraphEditorCanvas {
    private final int NODE_SIZE = 10;
    private final double INITIAL_SCALE_FACTOR = 0.95;
    private Shell shell;
    private IProject project;
    private List<Model> modelList;
    private List<Graph> graphList;
    private Graph stemGraph;
    private org.eclipse.zest.core.widgets.Graph zestGraph;
    private double scaleX;
    private double scaleY;
    private double translationX;
    private double translationY;
    private double zoomFactor;
    private int lastCursorX;
    private int lastCursorY;
    private boolean leftMouseButtonPressed;
    private Map<URI, GraphNode> graphNodes;
    private Map<URI, GraphConnection> graphConnections;
    private Map<URI, Set<Polygon>> graphPolygons;
    private Deque<Map<URI, Point2D.Double>> centersHistory;
    private Map<URI, Point2D.Double> currentCenters;
    private boolean centersMoved;
    private DynamicText nodeCoordinatesText;
    private DynamicText coordinatesText;
    private DynamicText zoomText;
    private Button undoButton;
    private Combo nodeLabelTypeCombo;
    private Menu removeLabelMenu;

    /*
     * Unable to fully structure code
     */
    public GraphEditorCanvas(String fileName, IProject project, List<Graph> graphList, List<Model> modelList) {
        super();
        this.project = project;
        this.graphList = new ArrayList<Graph>();
        this.modelList = modelList;
        this.stemGraph = null;
        this.zoomFactor = 1.0;
        this.leftMouseButtonPressed = false;
        this.graphNodes = new HashMap<URI, GraphNode>();
        this.graphConnections = new HashMap<URI, GraphConnection>();
        this.graphPolygons = new HashMap<URI, Set<Polygon>>();
        this.centersHistory = new LinkedList<Map<URI, Point2D.Double>>();
        if (graphList == null || graphList.isEmpty()) {
            window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            warning = new Status(4, "org.eclipse.stem.ui", 1, "Error opening GraphEditor: " + fileName + " does not contain graphs", null);
            ErrorDialog.openError((Shell)window.getShell(), null, null, (IStatus)warning);
            return;
        }
        for (Graph graph : graphList) {
            this.graphList.add((Graph)EcoreUtil.copy((EObject)graph));
        }
        for (Graph graph : graphList) {
            if (this.stemGraph == null) {
                this.stemGraph = (Graph)EcoreUtil.copy((EObject)graph);
                continue;
            }
            this.stemGraph.addGraph((Graph)EcoreUtil.copy((EObject)graph), null);
        }
        for (NodeLabel nodeLabel : this.stemGraph.getNodeLabels().values()) {
            node = this.stemGraph.getNode(nodeLabel.getURIOfIdentifiableToBeLabeled());
            if (node.getLabels().contains((Object)nodeLabel)) continue;
            node.getLabels().add((Object)nodeLabel);
        }
        this.createShell(String.valueOf(fileName) + " - STEM Graph Editor");
        for (Node node : this.stemGraph.getNodes().values()) {
            this.processNode(node);
        }
        for (Edge edge : this.stemGraph.getEdges().values()) {
            this.processEdge(edge);
        }
        if (this.graphNodes.isEmpty()) {
            window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            warning = new Status(4, "org.eclipse.stem.ui", 1, "Error opening GraphEditor: " + fileName + " does not contain nodes", null);
            ErrorDialog.openError((Shell)window.getShell(), null, null, warning);
            return;
        }
        this.setInitialTransform();
        this.redraw();
        this.shell.open();
        ** GOTO lbl59
        {
            Activator.getDefault().getWorkbench().getDisplay().sleep();
            do {
                if (!Activator.getDefault().getWorkbench().getDisplay().readAndDispatch()) continue block5;
lbl59:
                // 2 sources

            } while (!this.shell.isDisposed());
        }
    }

    private void createShell(String title) {
        Listener l;
        this.shell = new Shell(Activator.getDefault().getWorkbench().getDisplay());
        this.shell.setText(title);
        this.shell.setLayout((Layout)new GridLayout(1, true));
        this.zestGraph = new org.eclipse.zest.core.widgets.Graph((Composite)this.shell, 0);
        this.zestGraph.setLayoutData((Object)new GridData(4, 4, true, true));
        this.zestGraph.setVerticalScrollBarVisibility(org.eclipse.zest.core.widgets.Graph.NEVER);
        this.zestGraph.setHorizontalScrollBarVisibility(org.eclipse.zest.core.widgets.Graph.NEVER);
        this.zestGraph.getViewport().setIgnoreScroll(true);
        this.zestGraph.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setLineWidth(0);
                e.gc.setClipping(GraphEditorCanvas.this.zestGraph.getBounds());
                e.gc.setForeground(ColorConstants.lightGray);
                for (Set polySet : GraphEditorCanvas.this.graphPolygons.values()) {
                    for (Polygon displayPolygon : polySet) {
                        e.gc.drawPolygon(GraphEditorCanvas.this.polygon2IntArray(displayPolygon));
                    }
                }
            }
        });
        Listener[] listenerArray = this.zestGraph.getVerticalBar().getListeners(13);
        int n = listenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            l = listenerArray[n2];
            this.zestGraph.getVerticalBar().removeListener(13, l);
            this.zestGraph.getVerticalBar().removeListener(13, l);
            ++n2;
        }
        listenerArray = this.zestGraph.getHorizontalBar().getListeners(13);
        n = listenerArray.length;
        n2 = 0;
        while (n2 < n) {
            l = listenerArray[n2];
            this.zestGraph.getHorizontalBar().removeListener(13, l);
            this.zestGraph.getHorizontalBar().removeListener(13, l);
            ++n2;
        }
        Composite dataComposite = new Composite((Composite)this.shell, 0);
        Composite infoComposite = this.createInfoComposite(dataComposite);
        Composite bottomComposite = this.createButtonsComposite(dataComposite);
        dataComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        dataComposite.setLayout((Layout)new GridLayout(1, true));
        infoComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        bottomComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.addMenuBar();
        this.addZestGraphListeners();
        this.addZestGraphContextMenu();
        this.shell.setSize(800, 600);
    }

    private void updateShell(int selectedNodeLabel) {
        boolean showNodeComposite = false;
        boolean showEdgeComposite = false;
        if (this.zestGraph.getSelection().size() == 1) {
            if (this.zestGraph.getSelection().get(0) instanceof GraphNode) {
                showNodeComposite = true;
            } else if (this.zestGraph.getSelection().get(0) instanceof GraphConnection) {
                showEdgeComposite = true;
            }
        }
        this.shell.getChildren()[1].dispose();
        Composite bottomComposite = new Composite((Composite)this.shell, 0);
        bottomComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        bottomComposite.setLayout((Layout)new GridLayout(1, true));
        if (showNodeComposite) {
            GraphNode selectedNode = (GraphNode)this.zestGraph.getSelection().get(0);
            NodeData nodeData = (NodeData)selectedNode.getData();
            Composite nodeComposite = this.createNodeComposite(bottomComposite);
            nodeData.setActiveLabel(selectedNodeLabel);
            nodeComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            if (!nodeData.getNodeLabels().isEmpty()) {
                Composite nodeLabelComposite = this.createNodeLabelComposite(bottomComposite);
                nodeLabelComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            }
        }
        if (showEdgeComposite) {
            Composite edgeComposite = this.createEdgeComposite(bottomComposite);
            Composite edgeLabelComposite = this.createEdgeLabelComposite(bottomComposite);
            edgeComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            edgeLabelComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        }
        Composite infoComposite = this.createInfoComposite(bottomComposite);
        Composite buttonsComposite = this.createButtonsComposite(bottomComposite);
        infoComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        buttonsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.addZestGraphContextMenu();
        this.shell.layout(true);
        if (showNodeComposite || showEdgeComposite) {
            this.checkSelectionVisible();
        }
    }

    private Composite createNodeComposite(Composite parent) {
        GraphNode selectedNode = (GraphNode)this.zestGraph.getSelection().get(0);
        NodeData nodeData = (NodeData)selectedNode.getData();
        Group nodeComposite = new Group(parent, 0);
        nodeComposite.setText(GraphEditorMessages.getString("node"));
        nodeComposite.setLayout((Layout)new RowLayout(256));
        DynamicText nodeTitleText = new DynamicText((Composite)nodeComposite, GraphEditorMessages.getString("title"), true);
        nodeTitleText.setText(nodeData.getNodeTitle());
        nodeTitleText.addModifyListener(new TextAndButtonModifyListener(this.zestGraph, 1));
        DynamicText nodeURIText = new DynamicText((Composite)nodeComposite, GraphEditorMessages.getString("uri"), false);
        nodeURIText.setText(nodeData.getNodeURI().toString());
        this.nodeCoordinatesText = new DynamicText((Composite)nodeComposite, GraphEditorMessages.getString("coordinates"), false);
        this.nodeCoordinatesText.setText(this.formatLatLon(nodeData.getOrigY(), nodeData.getOrigX()));
        return nodeComposite;
    }

    private Composite createNodeLabelComposite(Composite parent) {
        GraphNode selectedNode = (GraphNode)this.zestGraph.getSelection().get(0);
        NodeData nodeData = (NodeData)selectedNode.getData();
        EList<NodeLabel> nodeLabels = nodeData.getNodeLabels();
        NodeLabel nodeLabel = (NodeLabel)nodeLabels.get(nodeData.getActiveLabel());
        Group nodeLabelComposite = new Group(parent, 0);
        nodeLabelComposite.setText(GraphEditorMessages.getString("nodeLabel"));
        nodeLabelComposite.setLayout((Layout)new RowLayout(256));
        Composite nodeLabelTypeComposite = new Composite((Composite)nodeLabelComposite, 2048);
        nodeLabelTypeComposite.setLayout((Layout)new GridLayout(2, false));
        Label nodeLabelTypeLabel = new Label(nodeLabelTypeComposite, 0);
        nodeLabelTypeLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        nodeLabelTypeLabel.setText(String.valueOf(GraphEditorMessages.getString("labelType")) + ":");
        this.nodeLabelTypeCombo = new Combo(nodeLabelTypeComposite, 8);
        this.nodeLabelTypeCombo.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        this.nodeLabelTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GraphEditorCanvas.this.updateShell(((Combo)e.getSource()).getSelectionIndex());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        for (NodeLabel label : nodeLabels) {
            if (label instanceof AreaLabel) {
                this.nodeLabelTypeCombo.add(GraphEditorMessages.getString("areaLabel"));
                continue;
            }
            if (!(label instanceof PopulationLabel)) continue;
            this.nodeLabelTypeCombo.add(String.valueOf(GraphEditorMessages.getString("populationLabel")) + " (" + ((PopulationLabel)label).getPopulationIdentifier() + ")");
        }
        this.nodeLabelTypeCombo.select(nodeData.getActiveLabel());
        if (nodeLabel instanceof AreaLabel) {
            AreaLabel areaLabel = (AreaLabel)nodeLabel;
            DynamicText labelAreaEdit = new DynamicText((Composite)nodeLabelComposite, GraphEditorMessages.getString("areaKM"), true);
            labelAreaEdit.setText("" + areaLabel.getCurrentAreaValue().getArea());
            labelAreaEdit.addModifyListener(new TextAndButtonModifyListener(this.zestGraph, 8));
        } else if (nodeLabel instanceof PopulationLabel) {
            PopulationLabel populationLabel = (PopulationLabel)nodeLabel;
            DynamicText labelPopulationText = new DynamicText((Composite)nodeLabelComposite, GraphEditorMessages.getString("population"), true);
            labelPopulationText.setText(populationLabel.getPopulationIdentifier());
            labelPopulationText.addModifyListener(new TextAndButtonModifyListener(this.zestGraph, 9));
            labelPopulationText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    GraphEditorCanvas.this.populationIdentifierChanged(GraphEditorCanvas.this.nodeLabelTypeCombo.getSelectionIndex(), ((Text)e.getSource()).getText());
                }
            });
            DynamicText labelCountEdit = new DynamicText((Composite)nodeLabelComposite, GraphEditorMessages.getString("populationCount"), true);
            labelCountEdit.setText("" + populationLabel.getCurrentPopulationValue().getCount());
            labelCountEdit.addModifyListener(new TextAndButtonModifyListener(this.zestGraph, 10));
            DynamicText labelPopulatedEdit = new DynamicText((Composite)nodeLabelComposite, GraphEditorMessages.getString("populatedArea"), true);
            labelPopulatedEdit.setText("" + populationLabel.getPopulatedArea());
            labelPopulatedEdit.addModifyListener(new TextAndButtonModifyListener(this.zestGraph, 11));
        }
        return nodeLabelComposite;
    }

    private Composite createEdgeComposite(Composite parent) {
        GraphConnection selectedEdge = (GraphConnection)this.zestGraph.getSelection().get(0);
        ConnectionData edgeData = (ConnectionData)selectedEdge.getData();
        Group edgeComposite = new Group(parent, 0);
        edgeComposite.setText(GraphEditorMessages.getString("edge"));
        edgeComposite.setLayout((Layout)new RowLayout(256));
        DynamicText edgeTitleText = new DynamicText((Composite)edgeComposite, GraphEditorMessages.getString("title"), true);
        edgeTitleText.setText(edgeData.getEdgeTitle());
        edgeTitleText.addModifyListener(new TextAndButtonModifyListener(this.zestGraph, 2));
        DynamicText nodeAURIText = new DynamicText((Composite)edgeComposite, GraphEditorMessages.getString("nodeA"), false);
        nodeAURIText.setText(edgeData.getNodeAURI().lastSegment());
        DynamicText nodeBURIText = new DynamicText((Composite)edgeComposite, GraphEditorMessages.getString("nodeB"), false);
        nodeBURIText.setText(edgeData.getNodeBURI().lastSegment());
        return edgeComposite;
    }

    private Composite createEdgeLabelComposite(Composite parent) {
        GraphConnection selectedEdge = (GraphConnection)this.zestGraph.getSelection().get(0);
        ConnectionData edgeData = (ConnectionData)selectedEdge.getData();
        EdgeLabel edgeLabel = edgeData.getEdgeLabel();
        Group edgeLabelComposite = new Group(parent, 0);
        edgeLabelComposite.setText(GraphEditorMessages.getString("edgeLabel"));
        edgeLabelComposite.setLayout((Layout)new RowLayout(256));
        if (edgeLabel instanceof MigrationEdgeLabel) {
            DynamicText edgeTypeText = new DynamicText((Composite)edgeLabelComposite, GraphEditorMessages.getString("edgeType"), true);
            edgeTypeText.setText(GraphEditorMessages.getString("migrationEdge"));
            edgeTypeText.setEditable(false);
            DynamicText edgePopulationText = new DynamicText((Composite)edgeLabelComposite, GraphEditorMessages.getString("population"), true);
            edgePopulationText.setText(edgeData.getMigrationPopulation());
            edgePopulationText.addModifyListener(new TextAndButtonModifyListener(this.zestGraph, 4));
            Composite edgeAbsoluteComposite = new Composite((Composite)edgeLabelComposite, 2048);
            edgeAbsoluteComposite.setLayout((Layout)new GridLayout());
            Button edgeAbsoluteButton = new Button(edgeAbsoluteComposite, 32);
            edgeAbsoluteButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
            edgeAbsoluteButton.setText(GraphEditorMessages.getString("migrationAbsolute"));
            edgeAbsoluteButton.setSelection(edgeData.getMigrationAbsolute());
            edgeAbsoluteButton.addSelectionListener((SelectionListener)new TextAndButtonModifyListener(this.zestGraph, 5));
            DynamicText edgeRateText = new DynamicText((Composite)edgeLabelComposite, GraphEditorMessages.getString("migrationRate"), true);
            edgeRateText.setText("" + edgeData.getMigrationRate());
            edgeRateText.addModifyListener(new TextAndButtonModifyListener(this.zestGraph, 3));
            DynamicText edgePeriodText = new DynamicText((Composite)edgeLabelComposite, GraphEditorMessages.getString("period"), true);
            edgePeriodText.setText("" + edgeData.getMigrationPeriod());
            edgePeriodText.addModifyListener(new TextAndButtonModifyListener(this.zestGraph, 6));
        } else if (edgeLabel instanceof CommonBorderRelationshipLabel) {
            DynamicText edgeTypeText = new DynamicText((Composite)edgeLabelComposite, GraphEditorMessages.getString("edgeType"), false);
            edgeTypeText.setText(GraphEditorMessages.getString("commonBorderEdge"));
            DynamicText edgeBorderText = new DynamicText((Composite)edgeLabelComposite, GraphEditorMessages.getString("borderLength"), true);
            edgeBorderText.setText("" + edgeData.getCommonBorderLength());
            edgeBorderText.addModifyListener(new TextAndButtonModifyListener(this.zestGraph, 7));
        } else if (edgeLabel instanceof RoadTransportRelationshipLabel) {
            DynamicText edgeTypeText = new DynamicText((Composite)edgeLabelComposite, GraphEditorMessages.getString("edgeType"), false);
            edgeTypeText.setText(GraphEditorMessages.getString("roadEdge"));
            DynamicText edgeNameText = new DynamicText((Composite)edgeLabelComposite, GraphEditorMessages.getString("roadName"), true);
            edgeNameText.setText(edgeData.getRoadName());
            edgeNameText.addModifyListener(new TextAndButtonModifyListener(this.zestGraph, 12));
            DynamicText edgeClassText = new DynamicText((Composite)edgeLabelComposite, GraphEditorMessages.getString("roadClass"), true);
            edgeClassText.setText(edgeData.getRoadClass());
            edgeClassText.addModifyListener(new TextAndButtonModifyListener(this.zestGraph, 13));
            DynamicText edgeCrossingsText = new DynamicText((Composite)edgeLabelComposite, GraphEditorMessages.getString("numberCrossing"), true);
            edgeCrossingsText.setText("" + edgeData.getRoadCrossings());
            edgeCrossingsText.addModifyListener(new TextAndButtonModifyListener(this.zestGraph, 14));
        } else if (edgeLabel instanceof PipeTransportEdgeLabel) {
            DynamicText edgeTypeText = new DynamicText((Composite)edgeLabelComposite, GraphEditorMessages.getString("edgeType"), false);
            edgeTypeText.setText(GraphEditorMessages.getString("pipeEdge"));
            DynamicText edgePopulationText = new DynamicText((Composite)edgeLabelComposite, GraphEditorMessages.getString("population"), true);
            edgePopulationText.setText(edgeData.getPipePopulation());
            edgePopulationText.addModifyListener(new TextAndButtonModifyListener(this.zestGraph, 15));
            DynamicText edgeFlowText = new DynamicText((Composite)edgeLabelComposite, GraphEditorMessages.getString("pipeFlow"), true);
            edgeFlowText.setText("" + edgeData.getPipeFlow());
            edgeFlowText.addModifyListener(new TextAndButtonModifyListener(this.zestGraph, 16));
            DynamicText edgePeriodText = new DynamicText((Composite)edgeLabelComposite, GraphEditorMessages.getString("period"), true);
            edgePeriodText.setText("" + edgeData.getPipePeriod());
            edgePeriodText.addModifyListener(new TextAndButtonModifyListener(this.zestGraph, 17));
        } else if (edgeLabel instanceof RelativePhysicalRelationshipLabel) {
            DynamicText edgeTypeText = new DynamicText((Composite)edgeLabelComposite, GraphEditorMessages.getString("edgeType"), false);
            edgeTypeText.setText(String.valueOf(GraphEditorMessages.getString("containmentEdge")) + ":");
        }
        return edgeLabelComposite;
    }

    private Composite createInfoComposite(Composite parent) {
        Group infoComposite = new Group(parent, 0);
        Point2D.Double latLong = this.getLatLongFromCursorLocation(this.zestGraph.toControl(Display.getCurrent().getCursorLocation()));
        infoComposite.setText(GraphEditorMessages.getString("displayInformation"));
        infoComposite.setLayout((Layout)new RowLayout(256));
        this.coordinatesText = new DynamicText((Composite)infoComposite, GraphEditorMessages.getString("coordinates"), false);
        this.coordinatesText.setText(this.formatLatLon(latLong.y, latLong.x));
        this.zoomText = new DynamicText((Composite)infoComposite, GraphEditorMessages.getString("zoom"), false);
        this.zoomText.setText(this.formatDouble(this.zoomFactor));
        return infoComposite;
    }

    private Composite createButtonsComposite(Composite parent) {
        Composite toolBar = new Composite(parent, 0);
        this.undoButton = new Button(toolBar, 8);
        Button saveButton = new Button(toolBar, 8);
        Button saveAsButton = new Button(toolBar, 8);
        Button quitButton = new Button(toolBar, 8);
        toolBar.setLayout((Layout)new RowLayout(256));
        this.undoButton.setText(GraphEditorMessages.getString("undoTranslation"));
        saveButton.setText(GraphEditorMessages.getString("saveGraph"));
        saveAsButton.setText(GraphEditorMessages.getString("saveGraphAs"));
        quitButton.setText(GraphEditorMessages.getString("quit"));
        if (this.centersHistory.isEmpty()) {
            this.undoButton.setEnabled(false);
        }
        this.undoButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Map lastCenters = (Map)GraphEditorCanvas.this.centersHistory.pollLast();
                if (lastCenters == null) {
                    return;
                }
                if (GraphEditorCanvas.this.centersHistory.isEmpty()) {
                    GraphEditorCanvas.this.undoButton.setEnabled(false);
                }
                for (GraphNode node : GraphEditorCanvas.this.graphNodes.values()) {
                    NodeData nodeData = (NodeData)node.getData();
                    Point2D.Double lastCenter = (Point2D.Double)lastCenters.get(nodeData.getNodeURI());
                    double diffX = lastCenter.x - nodeData.getOrigX();
                    double diffY = lastCenter.y - nodeData.getOrigY();
                    if (diffX == 0.0 && diffY == 0.0) continue;
                    GraphEditorCanvas.this.addTranslationToNode(node, diffX, diffY);
                }
                GraphEditorCanvas.this.redraw();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        saveButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GraphEditorCanvas.this.saveGraphList();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        saveAsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GraphEditorCanvas.this.saveStemGraphAs();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        quitButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GraphEditorCanvas.this.shell.dispose();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return toolBar;
    }

    private void addMenuBar() {
        Menu menuBar = new Menu((Decorations)this.shell, 2);
        MenuItem fileMenuItem = new MenuItem(menuBar, 64);
        Menu fileMenu = new Menu((Decorations)this.shell, 4);
        MenuItem fileSaveItem = new MenuItem(fileMenu, 8);
        fileMenuItem.setText(GraphEditorMessages.getString("file"));
        fileMenuItem.setMenu(fileMenu);
        fileSaveItem.setText(GraphEditorMessages.getString("saveAs"));
        fileSaveItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(GraphEditorCanvas.this.shell, 8192);
                dialog.setFilterNames(new String[]{"SVG Files"});
                dialog.setFilterExtensions(new String[]{"*.svg"});
                dialog.setFileName("graph.svg");
                String fileName = dialog.open();
                if (fileName != null) {
                    GraphEditorCanvas.this.saveZestGraphAsSVG(fileName);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.shell.setMenuBar(menuBar);
    }

    private void addZestGraphListeners() {
        this.zestGraph.getLightweightSystem().setEventDispatcher((EventDispatcher)new SWTEventDispatcher(){

            public void dispatchMouseMoved(MouseEvent me) {
            }
        });
        this.zestGraph.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    IFigure figureUnderMouse = GraphEditorCanvas.this.zestGraph.getFigureAt(e.x, e.y);
                    if (figureUnderMouse == null) {
                        GraphEditorCanvas.this.zestGraph.setSelection(new GraphItem[0]);
                        GraphEditorCanvas.this.updateShell(0);
                    }
                    GraphEditorCanvas.this.lastCursorX = Display.getCurrent().getCursorLocation().x;
                    GraphEditorCanvas.this.lastCursorY = Display.getCurrent().getCursorLocation().y;
                    GraphEditorCanvas.this.leftMouseButtonPressed = true;
                    GraphEditorCanvas.this.currentCenters = new HashMap();
                    GraphEditorCanvas.this.centersMoved = false;
                    for (GraphNode node : GraphEditorCanvas.this.graphNodes.values()) {
                        NodeData nodeData = (NodeData)node.getData();
                        Point2D.Double center = new Point2D.Double(nodeData.getOrigX(), nodeData.getOrigY());
                        GraphEditorCanvas.this.currentCenters.put(nodeData.getNodeURI(), center);
                    }
                }
            }

            public void mouseUp(MouseEvent e) {
                if (e.button == 1) {
                    GraphEditorCanvas.this.leftMouseButtonPressed = false;
                    if (GraphEditorCanvas.this.centersMoved) {
                        GraphEditorCanvas.this.centersHistory.add(GraphEditorCanvas.this.currentCenters);
                        GraphEditorCanvas.this.undoButton.setEnabled(true);
                    }
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.zestGraph.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                Point xy = GraphEditorCanvas.this.zestGraph.toControl(Display.getCurrent().getCursorLocation());
                Point2D.Double latLong = GraphEditorCanvas.this.getLatLongFromCursorLocation(xy);
                GraphEditorCanvas.this.coordinatesText.setText(GraphEditorCanvas.this.formatLatLon(latLong.y, latLong.x));
                if (!GraphEditorCanvas.this.leftMouseButtonPressed) {
                    return;
                }
                int x = Display.getCurrent().getCursorLocation().x;
                int y = Display.getCurrent().getCursorLocation().y;
                int diffX = x - GraphEditorCanvas.this.lastCursorX;
                int diffY = y - GraphEditorCanvas.this.lastCursorY;
                GraphEditorCanvas.this.lastCursorX = x;
                GraphEditorCanvas.this.lastCursorY = y;
                if (diffX == 0 && diffY == 0) {
                    return;
                }
                if (GraphEditorCanvas.this.zestGraph.getSelection().isEmpty()) {
                    GraphEditorCanvas graphEditorCanvas = GraphEditorCanvas.this;
                    graphEditorCanvas.translationX = graphEditorCanvas.translationX + (double)diffX;
                    GraphEditorCanvas graphEditorCanvas2 = GraphEditorCanvas.this;
                    graphEditorCanvas2.translationY = graphEditorCanvas2.translationY + (double)diffY;
                    GraphEditorCanvas.this.redraw();
                } else {
                    ArrayList<GraphNode> selectedNodes = new ArrayList<GraphNode>();
                    for (Object selectedItem : GraphEditorCanvas.this.zestGraph.getSelection()) {
                        if (!(selectedItem instanceof GraphNode)) continue;
                        selectedNodes.add((GraphNode)selectedItem);
                    }
                    for (GraphNode node : selectedNodes) {
                        GraphEditorCanvas.this.addTranslationToNode(node, (double)diffX / GraphEditorCanvas.this.scaleX, (double)diffY / GraphEditorCanvas.this.scaleY);
                    }
                    if (!selectedNodes.isEmpty()) {
                        GraphEditorCanvas.this.centersMoved = true;
                        GraphEditorCanvas.this.redraw();
                    }
                    if (GraphEditorCanvas.this.zestGraph.getSelection().size() == 1 && GraphEditorCanvas.this.zestGraph.getSelection().get(0) instanceof GraphNode) {
                        GraphNode selectedNode = (GraphNode)GraphEditorCanvas.this.zestGraph.getSelection().get(0);
                        NodeData nodeData = (NodeData)selectedNode.getData();
                        GraphEditorCanvas.this.nodeCoordinatesText.setText(GraphEditorCanvas.this.formatLatLon(nodeData.getOrigY(), nodeData.getOrigX()));
                    }
                }
            }
        });
        this.zestGraph.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GraphEditorCanvas.this.updateShell(0);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.zestGraph.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                Point2D.Double p = GraphEditorCanvas.this.getLatLongFromCursorLocation(GraphEditorCanvas.this.zestGraph.toControl(Display.getCurrent().getCursorLocation()));
                if (e.count >= 0) {
                    GraphEditorCanvas graphEditorCanvas = GraphEditorCanvas.this;
                    graphEditorCanvas.translationX = graphEditorCanvas.translationX - 0.1 * GraphEditorCanvas.this.scaleX * p.x;
                    GraphEditorCanvas graphEditorCanvas2 = GraphEditorCanvas.this;
                    graphEditorCanvas2.translationY = graphEditorCanvas2.translationY - 0.1 * GraphEditorCanvas.this.scaleY * p.y;
                    GraphEditorCanvas graphEditorCanvas3 = GraphEditorCanvas.this;
                    graphEditorCanvas3.scaleX = graphEditorCanvas3.scaleX * 1.1;
                    GraphEditorCanvas graphEditorCanvas4 = GraphEditorCanvas.this;
                    graphEditorCanvas4.scaleY = graphEditorCanvas4.scaleY * 1.1;
                    GraphEditorCanvas graphEditorCanvas5 = GraphEditorCanvas.this;
                    graphEditorCanvas5.zoomFactor = graphEditorCanvas5.zoomFactor * 1.1;
                } else {
                    GraphEditorCanvas graphEditorCanvas = GraphEditorCanvas.this;
                    graphEditorCanvas.scaleX = graphEditorCanvas.scaleX / 1.1;
                    GraphEditorCanvas graphEditorCanvas6 = GraphEditorCanvas.this;
                    graphEditorCanvas6.scaleY = graphEditorCanvas6.scaleY / 1.1;
                    GraphEditorCanvas graphEditorCanvas7 = GraphEditorCanvas.this;
                    graphEditorCanvas7.translationX = graphEditorCanvas7.translationX + 0.1 * GraphEditorCanvas.this.scaleX * p.x;
                    GraphEditorCanvas graphEditorCanvas8 = GraphEditorCanvas.this;
                    graphEditorCanvas8.translationY = graphEditorCanvas8.translationY + 0.1 * GraphEditorCanvas.this.scaleY * p.y;
                    GraphEditorCanvas graphEditorCanvas9 = GraphEditorCanvas.this;
                    graphEditorCanvas9.zoomFactor = graphEditorCanvas9.zoomFactor / 1.1;
                }
                Point xy = GraphEditorCanvas.this.zestGraph.toControl(Display.getCurrent().getCursorLocation());
                Point2D.Double latLong = GraphEditorCanvas.this.getLatLongFromCursorLocation(xy);
                GraphEditorCanvas.this.coordinatesText.setText(GraphEditorCanvas.this.formatLatLon(latLong.y, latLong.x));
                GraphEditorCanvas.this.zoomText.setText(GraphEditorCanvas.this.formatDouble(GraphEditorCanvas.this.zoomFactor));
                GraphEditorCanvas.this.redraw();
            }
        });
    }

    private void addZestGraphContextMenu() {
        List selection = this.zestGraph.getSelection();
        Menu menu = new Menu((Decorations)this.zestGraph.getShell(), 8);
        if (selection.isEmpty()) {
            this.createAddNodeItem(menu);
        } else if (selection.size() == 1 && selection.get(0) instanceof GraphNode) {
            this.createRemoveNodeItem(menu);
            this.createAddLabelItem(menu);
            this.createRemoveLabelItem(menu);
        } else if (selection.size() == 1 && selection.get(0) instanceof GraphConnection) {
            this.createRemoveEdgeItem(menu);
        } else if (selection.size() == 2 && selection.get(0) instanceof GraphNode && selection.get(1) instanceof GraphNode) {
            this.createAddEdgeItem(menu);
        } else {
            MenuItem noOptionsItem = new MenuItem(menu, 64);
            noOptionsItem.setText(GraphEditorMessages.getString("noActions"));
        }
        this.zestGraph.setMenu(menu);
    }

    private void createAddNodeItem(Menu menu) {
        MenuItem addNode = new MenuItem(menu, 8);
        addNode.setText(GraphEditorMessages.getString("addNode"));
        addNode.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Point2D.Double p = GraphEditorCanvas.this.getLatLongFromCursorLocation(GraphEditorCanvas.this.zestGraph.toControl(Display.getCurrent().getCursorLocation()));
                NewNodeDialog dialog = new NewNodeDialog(GraphEditorCanvas.this.shell);
                if (!dialog.hasResult()) {
                    return;
                }
                String identifier = dialog.getIdentifier();
                double size = dialog.getSize();
                Region node = NodesFactory.eINSTANCE.createRegion();
                LatLong latlon = new LatLong();
                LatLong.SegmentBuilder builder = new LatLong.SegmentBuilder();
                builder.add(p.y - size / 2.0, p.x - size / 2.0);
                builder.add(p.y + size / 2.0, p.x - size / 2.0);
                builder.add(p.y + size / 2.0, p.x + size / 2.0);
                builder.add(p.y - size / 2.0, p.x + size / 2.0);
                builder.add(p.y - size / 2.0, p.x - size / 2.0);
                latlon.add(builder.toSegment());
                node.getDublinCore().setTitle("");
                node.setURI(STEMURI.createURI((String)("node/geo/region/" + identifier)));
                node.getDublinCore().setSpatial(InlineLatLongDataProvider.createSpatialInlineURIString((LatLong)latlon));
                GraphNode gn = GraphEditorCanvas.this.processNode((Node)node);
                GraphEditorCanvas.this.addNodeToStemGraph((Node)node);
                GraphEditorCanvas.this.zestGraph.setSelection(new GraphItem[]{gn});
                GraphEditorCanvas.this.redraw();
                GraphEditorCanvas.this.updateShell(0);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createAddLabelItem(Menu menu) {
        MenuItem addLabelItem = new MenuItem(menu, 64);
        Menu addLabelMenu = new Menu((Decorations)this.zestGraph.getShell(), 4);
        MenuItem addAreaLabelItem = new MenuItem(addLabelMenu, 8);
        MenuItem addPopulationLabelItem = new MenuItem(addLabelMenu, 8);
        addLabelItem.setText(GraphEditorMessages.getString("addLabel"));
        addAreaLabelItem.setText(GraphEditorMessages.getString("addAreaLabel"));
        addPopulationLabelItem.setText(GraphEditorMessages.getString("addPopulationLabel"));
        addLabelItem.setMenu(addLabelMenu);
        addAreaLabelItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GraphEditorCanvas.this.addNodeLabel(LabelsPackage.Literals.AREA_LABEL);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        addPopulationLabelItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GraphEditorCanvas.this.addNodeLabel(LabelsPackage.Literals.POPULATION_LABEL);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createAddEdgeItem(Menu menu) {
        MenuItem addEdgeItem = new MenuItem(menu, 64);
        Menu addEdgeMenu = new Menu((Decorations)this.zestGraph.getShell(), 4);
        MenuItem addMigrationEdge = new MenuItem(addEdgeMenu, 8);
        MenuItem addCommonBorderEdge = new MenuItem(addEdgeMenu, 8);
        MenuItem addRoadTransportEdge = new MenuItem(addEdgeMenu, 8);
        MenuItem addPipeTransportEdge = new MenuItem(addEdgeMenu, 8);
        addEdgeItem.setText(GraphEditorMessages.getString("addEdge"));
        addMigrationEdge.setText(GraphEditorMessages.getString("addMigrationEdge"));
        addCommonBorderEdge.setText(GraphEditorMessages.getString("addCommonBorderEdge"));
        addRoadTransportEdge.setText(GraphEditorMessages.getString("addRoadEdge"));
        addPipeTransportEdge.setText(GraphEditorMessages.getString("addPipeEdge"));
        addEdgeItem.setMenu(addEdgeMenu);
        addCommonBorderEdge.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GraphEditorCanvas.this.addEdge(LabelsPackage.Literals.COMMON_BORDER_RELATIONSHIP_LABEL);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        addMigrationEdge.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GraphEditorCanvas.this.addEdge(EdgesPackage.Literals.MIGRATION_EDGE_LABEL);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        addRoadTransportEdge.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GraphEditorCanvas.this.addEdge(LabelsPackage.Literals.ROAD_TRANSPORT_RELATIONSHIP_LABEL);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        addPipeTransportEdge.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GraphEditorCanvas.this.addEdge(TransportPackage.Literals.PIPE_TRANSPORT_EDGE_LABEL);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createRemoveNodeItem(Menu menu) {
        MenuItem removeNode = new MenuItem(menu, 8);
        removeNode.setText(GraphEditorMessages.getString("removeNode"));
        removeNode.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GraphNode selectedNode = (GraphNode)GraphEditorCanvas.this.zestGraph.getSelection().get(0);
                NodeData nodeData = (NodeData)selectedNode.getData();
                ArrayList<URI> edgesToRemove = new ArrayList<URI>();
                for (Map.Entry entry : GraphEditorCanvas.this.graphConnections.entrySet()) {
                    if (selectedNode != ((GraphConnection)entry.getValue()).getSource() && selectedNode != ((GraphConnection)entry.getValue()).getDestination()) continue;
                    ((GraphConnection)entry.getValue()).dispose();
                    edgesToRemove.add((URI)entry.getKey());
                }
                for (URI edgeURI : edgesToRemove) {
                    GraphEditorCanvas.this.graphConnections.remove(edgeURI);
                }
                GraphEditorCanvas.this.zestGraph.setSelection(new GraphItem[0]);
                GraphEditorCanvas.this.graphNodes.remove(nodeData.getNodeURI());
                GraphEditorCanvas.this.graphPolygons.remove(nodeData.getNodeURI());
                selectedNode.dispose();
                GraphEditorCanvas.this.removeNodeFromStemGraph(nodeData.getNode());
                GraphEditorCanvas.this.updateShell(0);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createRemoveLabelItem(Menu menu) {
        MenuItem removeLabelItem = new MenuItem(menu, 64);
        GraphNode selectedNode = (GraphNode)this.zestGraph.getSelection().get(0);
        NodeData nodeData = (NodeData)selectedNode.getData();
        this.removeLabelMenu = new Menu((Decorations)this.zestGraph.getShell(), 4);
        removeLabelItem.setText(GraphEditorMessages.getString("removeLabel"));
        removeLabelItem.setMenu(this.removeLabelMenu);
        for (NodeLabel label : nodeData.getNodeLabels()) {
            MenuItem item = new MenuItem(this.removeLabelMenu, 8);
            if (label instanceof AreaLabel) {
                item.setText(GraphEditorMessages.getString("areaLabel"));
            } else if (label instanceof PopulationLabel) {
                String population = ((PopulationLabel)label).getPopulationIdentifier();
                item.setText(String.valueOf(GraphEditorMessages.getString("populationLabel")) + " (" + population + ")");
            }
            item.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    MenuItem item = (MenuItem)e.getSource();
                    Menu menu = item.getParent();
                    List<MenuItem> allItems = Arrays.asList(menu.getItems());
                    int index = allItems.indexOf(item);
                    List selection = GraphEditorCanvas.this.zestGraph.getSelection();
                    GraphNode selectedNode = (GraphNode)selection.get(0);
                    NodeData nodeData = (NodeData)selectedNode.getData();
                    NodeLabel label = (NodeLabel)nodeData.getNodeLabels().get(index);
                    GraphEditorCanvas.this.removeNodeLabelFromStemGraph(label);
                    GraphEditorCanvas.this.updateShell(0);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }

    private void createRemoveEdgeItem(Menu menu) {
        MenuItem removeEdge = new MenuItem(menu, 8);
        removeEdge.setText(GraphEditorMessages.getString("removeEdge"));
        removeEdge.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                List selectedItems = GraphEditorCanvas.this.zestGraph.getSelection();
                GraphConnection selectedEdge = (GraphConnection)selectedItems.get(0);
                ConnectionData edgeData = (ConnectionData)selectedEdge.getData();
                GraphEditorCanvas.this.zestGraph.setSelection(new GraphItem[0]);
                selectedEdge.dispose();
                GraphEditorCanvas.this.removeEdgeFromStemGraph(edgeData.getEdge());
                GraphEditorCanvas.this.updateShell(0);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void populationIdentifierChanged(int index, String newValue) {
        String newString = String.valueOf(GraphEditorMessages.getString("populationLabel")) + " (" + newValue + ")";
        this.nodeLabelTypeCombo.setItem(index, newString);
        this.removeLabelMenu.getItems()[index].setText(newString);
    }

    private GraphNode processNode(Node node) {
        LatLongProvider latLongProvider = (LatLongProvider)LatLongProviderAdapterFactory.INSTANCE.adaptNew((Notifier)node, LatLongProvider.class);
        List segments = latLongProvider.getLatLong().getSegments();
        HashSet<Polygon> displayPolys = new HashSet<Polygon>();
        int graphListIndex = 0;
        double largestPolygonArea = 0.0;
        Point2D.Double center = null;
        int i = 0;
        while (i < this.graphList.size()) {
            if (this.graphList.get(i).getNodes().get((Object)node.getURI()) != null) {
                graphListIndex = i;
                break;
            }
            ++i;
        }
        for (LatLong.Segment segment_tmp : segments) {
            Polygon dPolygon = new Polygon(segment_tmp);
            displayPolys.add(dPolygon);
            if (!(dPolygon.getArea() > largestPolygonArea)) continue;
            largestPolygonArea = dPolygon.getArea();
            center = dPolygon.getCentroid();
        }
        node.eAdapters().remove((Object)latLongProvider);
        if (center != null) {
            GraphNode graphCenterNode = new GraphNode((IContainer)this.zestGraph, 0, "");
            graphCenterNode.setData((Object)new NodeData(node, center.x, center.y, 0, graphListIndex));
            this.setNodeColor(graphCenterNode);
            this.graphPolygons.put(node.getURI(), displayPolys);
            this.graphNodes.put(node.getURI(), graphCenterNode);
            return graphCenterNode;
        }
        return null;
    }

    private GraphConnection processEdge(Edge edge) {
        URI nodeAURI = edge.getNodeAURI();
        URI nodeBURI = edge.getNodeBURI();
        URI edgeURI = edge.getURI();
        if (nodeAURI.toString().compareTo(nodeBURI.toString()) > 0) {
            URI mem = nodeAURI;
            nodeAURI = nodeBURI;
            nodeBURI = mem;
        }
        if (this.graphNodes.get(nodeAURI) != null && this.graphNodes.get(nodeBURI) != null) {
            GraphConnection gc = new GraphConnection(this.zestGraph, 0, this.graphNodes.get(nodeAURI), this.graphNodes.get(nodeBURI));
            gc.setData((Object)new ConnectionData(edge, 0));
            this.setEdgeColor(gc);
            this.preventOverlay(gc);
            this.graphConnections.put(edgeURI, gc);
            return gc;
        }
        return null;
    }

    private void addNodeLabel(EClass labelClass) {
        List selectedItems = this.zestGraph.getSelection();
        GraphItem selectedNode = (GraphItem)selectedItems.get(0);
        NodeData nodeData = (NodeData)selectedNode.getData();
        AreaLabel label = null;
        if (labelClass == LabelsPackage.Literals.AREA_LABEL) {
            label = LabelsFactory.eINSTANCE.createAreaLabel();
            label.getCurrentAreaValue().setArea(0.0);
            label.setURIOfIdentifiableToBeLabeled(nodeData.getNodeURI());
            label.setNode(nodeData.getNode());
        } else if (labelClass == LabelsPackage.Literals.POPULATION_LABEL) {
            label = LabelsFactory.eINSTANCE.createPopulationLabel();
            ((PopulationLabel)label).setPopulationIdentifier("");
            ((PopulationLabel)label).setPopulatedArea(0.0);
            ((PopulationLabel)label).getCurrentPopulationValue().setCount(0.0);
            label.setURIOfIdentifiableToBeLabeled(nodeData.getNodeURI());
            label.setNode(nodeData.getNode());
        }
        this.addNodeLabelToStemGraph((NodeLabel)label);
        this.updateShell(nodeData.getNodeLabels().size() - 1);
    }

    private void addEdge(EClass labelClass) {
        List selectedItems = this.zestGraph.getSelection();
        GraphNode selectedNodeA = (GraphNode)selectedItems.get(0);
        GraphNode selectedNodeB = (GraphNode)selectedItems.get(1);
        NodeData nodeDataA = (NodeData)selectedNodeA.getData();
        NodeData nodeDataB = (NodeData)selectedNodeB.getData();
        Node nodeA = nodeDataA.getNode();
        Node nodeB = nodeDataB.getNode();
        MigrationEdge edge = null;
        if (labelClass == EdgesPackage.Literals.MIGRATION_EDGE_LABEL) {
            edge = this.createMigrationEdge(nodeA, nodeB);
        } else if (labelClass == LabelsPackage.Literals.COMMON_BORDER_RELATIONSHIP_LABEL) {
            edge = this.createCommonBorderEdge(nodeA, nodeB);
        } else if (labelClass == LabelsPackage.Literals.ROAD_TRANSPORT_RELATIONSHIP_LABEL) {
            edge = this.createRoadTransportEdge(nodeA, nodeB);
        } else if (labelClass == TransportPackage.Literals.PIPE_TRANSPORT_EDGE_LABEL) {
            edge = this.createPipeTransportEdge(nodeA, nodeB);
        }
        GraphConnection gc = this.processEdge((Edge)edge);
        this.addEdgeToStemGraph((Edge)edge);
        this.zestGraph.setSelection(new GraphItem[]{gc});
        this.updateShell(0);
    }

    private Edge createCommonBorderEdge(Node nodeA, Node nodeB) {
        Edge cbrEdge = EdgeImpl.createEdge((Node)nodeA, (Node)nodeB);
        CommonBorderRelationshipLabel cbrLabel = LabelsFactory.eINSTANCE.createCommonBorderRelationshipLabel();
        CommonBorderRelationshipLabelValue cbrLabelValue = (CommonBorderRelationshipLabelValue)cbrLabel.getCurrentValue();
        cbrEdge.setURI(this.getRandomURI("edge/relationship/commonborder"));
        cbrEdge.setLabel((EdgeLabel)cbrLabel);
        cbrEdge.getDublinCore().setTitle(this.createEdgeTitle(nodeA, nodeB, "Edge", false));
        cbrLabel.setURIOfIdentifiableToBeLabeled(cbrEdge.getURI());
        cbrLabelValue.setBorderLength(0.0);
        return cbrEdge;
    }

    private MigrationEdge createMigrationEdge(Node nodeA, Node nodeB) {
        MigrationEdge mEdge = EdgesFactory.eINSTANCE.createMigrationEdge();
        mEdge.setURI(this.getRandomURI("edge/migration"));
        mEdge.setNodeAURI(nodeA.getURI());
        mEdge.setNodeBURI(nodeB.getURI());
        mEdge.getLabel().setURIOfIdentifiableToBeLabeled(mEdge.getURI());
        mEdge.getLabel().getCurrentValue().setMigrationRate(0.0);
        mEdge.getDublinCore().setTitle(this.createEdgeTitle(nodeA, nodeB, "MigrationEdge", true));
        mEdge.setPopulationIdentifier("");
        return mEdge;
    }

    private Edge createRoadTransportEdge(Node nodeA, Node nodeB) {
        Edge edge = RoadTransportRelationshipLabelImpl.createRoadTransportRelationship((Node)nodeA, (Node)nodeB, (String)"", (String)"", (int)0);
        edge.setURI(this.getRandomURI("edge/road"));
        edge.getLabel().setURIOfIdentifiableToBeLabeled(edge.getURI());
        edge.getDublinCore().setTitle(this.createEdgeTitle(nodeA, nodeB, "RoadEdge", false));
        return edge;
    }

    private Edge createPipeTransportEdge(Node nodeA, Node nodeB) {
        PipeTransportEdge edge = TransportFactory.eINSTANCE.createPipeTransportEdge();
        PipeTransportEdgeLabelValue edgeValue = TransportFactory.eINSTANCE.createPipeTransportEdgeLabelValue();
        edge.setURI(this.getRandomURI("edge/pipetransport"));
        edge.setA(nodeA);
        edge.setB(nodeB);
        edge.setNodeAURI(nodeA.getURI());
        edge.setNodeBURI(nodeB.getURI());
        edge.getLabel().setURIOfIdentifiableToBeLabeled(edge.getURI());
        edge.getLabel().setCurrentValue((LabelValue)edgeValue);
        edge.getDublinCore().setTitle(this.createEdgeTitle(nodeA, nodeB, "Pipe", true));
        edge.setPopulationIdentifier("");
        edgeValue.setMaxFlow(0.0);
        edgeValue.setTimePeriod(86400000L);
        return edge;
    }

    private void addNodeToStemGraph(Node node) {
        this.stemGraph.getNodes().put((Object)node.getURI(), (Object)node);
        this.graphList.get(0).getNodes().put((Object)node.getURI(), (Object)((Node)EcoreUtil.copy((EObject)node)));
    }

    private void addEdgeToStemGraph(Edge edge) {
        this.stemGraph.getEdges().put((Object)edge.getURI(), (Object)edge);
        for (Graph graph : this.graphList) {
            if (!graph.getNodes().containsKey((Object)edge.getNodeAURI())) continue;
            graph.getEdges().put((Object)edge.getURI(), (Object)((Edge)EcoreUtil.copy((EObject)edge)));
        }
    }

    private void addNodeLabelToStemGraph(NodeLabel nodeLabel) {
        NodeLabel nodeLabelCopy = (NodeLabel)EcoreUtil.copy((EObject)nodeLabel);
        URI nodeURI = nodeLabel.getURIOfIdentifiableToBeLabeled();
        this.stemGraph.getNodeLabels().put((Object)nodeLabel.getURI(), (Object)nodeLabel);
        this.stemGraph.getNode(nodeURI).getLabels().add((Object)nodeLabel);
        for (Graph graph : this.graphList) {
            if (!graph.getNodes().containsKey((Object)nodeURI)) continue;
            graph.getNodeLabels().put((Object)nodeLabel.getURI(), (Object)nodeLabelCopy);
            graph.getNode(nodeURI).getLabels().add((Object)nodeLabelCopy);
        }
    }

    private void removeNodeFromStemGraph(Node node) {
        URI nodeURI = node.getURI();
        ArrayList<URI> nodeLabelsToRemove = new ArrayList<URI>();
        ArrayList<URI> edgesToRemove = new ArrayList<URI>();
        for (NodeLabel nodeLabel : node.getLabels()) {
            nodeLabelsToRemove.add(nodeLabel.getURI());
        }
        for (Edge edge : this.stemGraph.getEdges().values()) {
            if (!edge.getNodeAURI().equals((Object)nodeURI) && !edge.getNodeBURI().equals((Object)nodeURI)) continue;
            edgesToRemove.add(edge.getURI());
        }
        for (URI nodeLabelURI : nodeLabelsToRemove) {
            this.stemGraph.getNodeLabels().removeKey((Object)nodeLabelURI);
        }
        for (URI edgeURI : edgesToRemove) {
            this.stemGraph.getEdges().removeKey((Object)edgeURI);
        }
        this.stemGraph.getNodes().removeKey((Object)nodeURI);
        for (Graph graph : this.graphList) {
            for (URI nodeLabelURI : nodeLabelsToRemove) {
                graph.getNodeLabels().removeKey((Object)nodeLabelURI);
            }
            for (URI edgeURI : edgesToRemove) {
                graph.getEdges().removeKey((Object)edgeURI);
            }
            graph.getNodes().removeKey((Object)nodeURI);
        }
    }

    private void removeEdgeFromStemGraph(Edge edge) {
        URI edgeURI = edge.getURI();
        this.stemGraph.getEdges().removeKey((Object)edgeURI);
        for (Graph graph : this.graphList) {
            graph.getEdges().removeKey((Object)edgeURI);
        }
    }

    private void removeNodeLabelFromStemGraph(NodeLabel nodeLabel) {
        URI labelURI = nodeLabel.getURI();
        URI nodeURI = nodeLabel.getURIOfIdentifiableToBeLabeled();
        this.stemGraph.getNode(nodeURI).getLabels().remove((Object)this.stemGraph.getNodeLabel(labelURI));
        this.stemGraph.getNodeLabels().removeKey((Object)labelURI);
        NodeLabel labelToRemove = null;
        for (Graph graph : this.graphList) {
            labelToRemove = (NodeLabel)graph.getNodeLabels().removeKey((Object)labelURI);
        }
        for (Graph graph : this.graphList) {
            if (!graph.getNodes().containsKey((Object)nodeURI)) continue;
            graph.getNode(nodeURI).getLabels().remove((Object)labelToRemove);
        }
    }

    private void saveZestGraphAsSVG(String fileName) {
        try {
            Rectangle area = this.zestGraph.getClientArea();
            DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
            Document document = domImpl.createDocument(null, "svg", null);
            SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
            OutputStreamWriter outsvg = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "UTF-8");
            GraphicsToAWT swtGraphics = new GraphicsToAWT((Graphics2D)svgGenerator, new Dimension(area.width, area.height));
            svgGenerator.setSVGCanvasSize(new java.awt.Dimension(area.width, area.height));
            this.zestGraph.getRootLayer().paint((Graphics)swtGraphics);
            swtGraphics.setLineWidth(0);
            swtGraphics.setLineStyle(1);
            swtGraphics.setForegroundColor(ColorConstants.lightGray);
            for (Set<Polygon> polySet : this.graphPolygons.values()) {
                for (Polygon displayPolygon : polySet) {
                    swtGraphics.drawPolygon(this.polygon2IntArray(displayPolygon));
                }
            }
            svgGenerator.stream((Writer)outsvg, true);
            ((Writer)outsvg).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveStemGraphAs() {
        SaveInProjectDialog saveAsDialog = new SaveInProjectDialog(Activator.getDefault().getWorkbench().getDisplay().getActiveShell());
        saveAsDialog.open();
        if (saveAsDialog.getResult() == null) {
            return;
        }
        IFile saveAsFile = ResourcesPlugin.getWorkspace().getRoot().getFile(saveAsDialog.getResult());
        this.saveGraph(this.stemGraph, saveAsFile.getProject(), URI.createPlatformResourceURI((String)saveAsFile.getFullPath().toString(), (boolean)false));
        PlatformLatLongDataProvider.flush();
        try {
            this.project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            Activator.logError((String)e.getMessage(), (Throwable)e);
        }
    }

    private void saveGraphList() {
        for (Model model : this.modelList) {
            EList modelGraphs = model.getGraphs();
            int i = 0;
            while (i < modelGraphs.size()) {
                URI graphURI = ((Graph)modelGraphs.get(i)).getURI();
                for (Graph graph : this.graphList) {
                    if (!graph.getURI().equals((Object)graphURI)) continue;
                    modelGraphs.set(i, (Object)graph);
                    break;
                }
                ++i;
            }
        }
        for (Graph graph : this.graphList) {
            this.saveGraph(graph, this.project, graph.getURI());
        }
        for (Model model : this.modelList) {
            if (!model.getURI().isPlatformResource()) continue;
            ArrayList<Identifiable> identifiables = new ArrayList<Identifiable>();
            URI uri = model.getURI();
            identifiables.add((Identifiable)model);
            this.addContainments(identifiables, model);
            try {
                Utility.serializeIdentifiables(identifiables, (URI)uri);
            }
            catch (IOException e) {
                Activator.logError((String)e.getMessage(), (Throwable)e);
            }
        }
        PlatformLatLongDataProvider.flush();
        try {
            this.project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            Activator.logError((String)e.getMessage(), (Throwable)e);
        }
    }

    private void addContainments(List<Identifiable> identifiables, Model model) {
        for (Graph subGraph : model.getGraphs()) {
            if (subGraph.getURI().isPlatformResource()) continue;
            identifiables.add((Identifiable)subGraph);
        }
        for (Model subModel : model.getModels()) {
            if (subModel.getURI().isPlatformResource()) continue;
            identifiables.add((Identifiable)subModel);
            this.addContainments(identifiables, subModel);
        }
    }

    private void saveGraph(Graph graph, IProject project, URI newURI) {
        HashMap<URI, Set<Polygon>> currentGraphPolygons;
        String tail;
        block14: {
            graph.setURI(newURI);
            this.updateGraph(graph);
            graph.getDublinCore().setTitle("");
            String fileBaseName = graph.getURI().lastSegment().substring(0, graph.getURI().lastSegment().lastIndexOf("."));
            tail = String.valueOf(project.getName()) + "/.gml/" + fileBaseName + "_MAP.xml";
            currentGraphPolygons = new HashMap<URI, Set<Polygon>>();
            if (!project.getFolder(".gml").exists()) {
                NullProgressMonitor monitor = new NullProgressMonitor();
                try {
                    try {
                        project.getFolder(".gml").create(false, true, (IProgressMonitor)monitor);
                    }
                    catch (CoreException e) {
                        Activator.logError((String)e.getMessage(), (Throwable)e);
                        monitor.done();
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }
        }
        for (Node n : graph.getNodes().values()) {
            Set<Polygon> displayPolygons = this.graphPolygons.get(n.getURI());
            String spatialString = n.getDublinCore().getSpatial();
            if (spatialString.contains("stemspatial:inline")) {
                LatLong latlon = new LatLong();
                for (Polygon p : displayPolygons) {
                    LatLong.SegmentBuilder sb = new LatLong.SegmentBuilder();
                    int i = 0;
                    while (i < p.npoints) {
                        sb.add(p.y[i], p.x[i]);
                        ++i;
                    }
                    latlon.add(sb.toSegment());
                }
                n.getDublinCore().setSpatial(InlineLatLongDataProvider.createSpatialInlineURIString((LatLong)latlon));
                continue;
            }
            if (!spatialString.contains("stemspatial:platform")) continue;
            String newSpatialString = "stemspatial:platform:/resource/" + tail + "#" + n.getURI().lastSegment();
            n.getDublinCore().setSpatial(newSpatialString);
            currentGraphPolygons.put(n.getURI(), this.graphPolygons.get(n.getURI()));
        }
        if (!currentGraphPolygons.isEmpty()) {
            String spatialString = "stemspatial:platform:/resource/" + tail;
            String fileName = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString().concat("/" + tail);
            SpatialGmlExporter.writeGML(fileName, graph.getURI(), currentGraphPolygons);
            graph.getDublinCore().setSpatial(spatialString);
        }
        if (graph.getURI().isPlatformResource()) {
            try {
                Utility.serializeIdentifiable((Identifiable)graph, (URI)graph.getURI());
            }
            catch (IOException e) {
                Activator.logError((String)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void redraw() {
        for (GraphNode gn : this.graphNodes.values()) {
            NodeData nodeData = (NodeData)gn.getData();
            double origX = nodeData.getOrigX();
            double origY = nodeData.getOrigY();
            double displayX = origX * this.scaleX + this.translationX;
            double displayY = origY * this.scaleY + this.translationY;
            gn.setSize(10.0, 10.0);
            gn.setLocation(displayX - 5.0, displayY - 5.0);
        }
        this.zestGraph.redraw();
    }

    private void setInitialTransform() {
        Rectangle zestBounds = this.zestGraph.getClientArea();
        Rectangle2D.Double stemBounds = null;
        for (Set<Polygon> polygons : this.graphPolygons.values()) {
            for (Polygon p : polygons) {
                stemBounds = stemBounds == null ? p.getBounds() : (Rectangle2D.Double)stemBounds.createUnion(p.getBounds());
            }
        }
        double scaleFactor = Math.min((double)zestBounds.width / stemBounds.width, (double)zestBounds.height / stemBounds.height) * 0.95;
        double zestCenterX = zestBounds.x + zestBounds.width / 2;
        double zestCenterY = zestBounds.y + zestBounds.height / 2;
        double stemCenterX = stemBounds.getCenterX();
        double stemCenterY = stemBounds.getCenterY();
        this.scaleX = scaleFactor;
        this.scaleY = -scaleFactor;
        this.translationX = zestCenterX - this.scaleX * stemCenterX;
        this.translationY = zestCenterY - this.scaleY * stemCenterY;
    }

    private void updateGraph(Graph graph) {
        for (Node graphNode : graph.getNodes().values()) {
            Node stemGraphNode = this.stemGraph.getNode(graphNode.getURI());
            graphNode.getDublinCore().setTitle(stemGraphNode.getDublinCore().getTitle());
        }
        for (Edge graphEdge : graph.getEdges().values()) {
            MigrationEdgeLabelValue stemGraphLabelValue;
            MigrationEdgeLabelValue graphLabelValue;
            CommonBorderRelationshipLabelValue stemGraphLabelValue2;
            CommonBorderRelationshipLabelValue graphLabelValue2;
            Edge stemGraphEdge = this.stemGraph.getEdge(graphEdge.getURI());
            EdgeLabel graphLabel = graphEdge.getLabel();
            EdgeLabel stemGraphLabel = stemGraphEdge.getLabel();
            graphEdge.getDublinCore().setTitle(stemGraphEdge.getDublinCore().getTitle());
            if (graphLabel instanceof CommonBorderRelationshipLabel) {
                graphLabelValue2 = (CommonBorderRelationshipLabelValue)graphLabel.getCurrentValue();
                stemGraphLabelValue2 = (CommonBorderRelationshipLabelValue)stemGraphLabel.getCurrentValue();
                graphLabelValue2.setBorderLength(stemGraphLabelValue2.getBorderLength());
                continue;
            }
            if (graphLabel instanceof MigrationEdgeLabel) {
                MigrationEdge graphMigration = (MigrationEdge)graphEdge;
                MigrationEdge stemGraphMigration = (MigrationEdge)stemGraphEdge;
                graphLabelValue = (MigrationEdgeLabelValue)graphEdge.getLabel().getCurrentValue();
                stemGraphLabelValue = (MigrationEdgeLabelValue)stemGraphEdge.getLabel().getCurrentValue();
                graphMigration.setPopulationIdentifier(stemGraphMigration.getPopulationIdentifier());
                graphMigration.setUseAbsoluteValues(stemGraphMigration.isUseAbsoluteValues());
                graphLabelValue.setMigrationRate(stemGraphLabelValue.getMigrationRate());
                graphLabelValue.setTimePeriod(stemGraphLabelValue.getTimePeriod());
                continue;
            }
            if (graphLabel instanceof RoadTransportRelationshipLabel) {
                graphLabelValue2 = (RoadTransportRelationshipLabelValue)graphLabel.getCurrentValue();
                stemGraphLabelValue2 = (RoadTransportRelationshipLabelValue)stemGraphLabel.getCurrentValue();
                graphLabelValue2.setRoadName(stemGraphLabelValue2.getRoadName());
                graphLabelValue2.setRoadClass(stemGraphLabelValue2.getRoadClass());
                graphLabelValue2.setNumberCrossings(stemGraphLabelValue2.getNumberCrossings());
                continue;
            }
            if (!(graphLabel instanceof PipeTransportEdgeLabel)) continue;
            PipeTransportEdge graphPipe = (PipeTransportEdge)graphEdge;
            PipeTransportEdge stemGraphPipe = (PipeTransportEdge)stemGraphEdge;
            graphLabelValue = (PipeTransportEdgeLabelValue)graphEdge.getLabel().getCurrentValue();
            stemGraphLabelValue = (PipeTransportEdgeLabelValue)stemGraphEdge.getLabel().getCurrentValue();
            graphPipe.setPopulationIdentifier(stemGraphPipe.getPopulationIdentifier());
            graphLabelValue.setMaxFlow(stemGraphLabelValue.getMaxFlow());
            graphLabelValue.setTimePeriod(stemGraphLabelValue.getTimePeriod());
        }
        for (NodeLabel graphLabel : graph.getNodeLabels().values()) {
            NodeLabel stemGraphLabel = this.stemGraph.getNodeLabel(graphLabel.getURI());
            if (graphLabel instanceof PopulationLabel) {
                PopulationLabel graphPopLabel = (PopulationLabel)graphLabel;
                PopulationLabel stemGraphPopLabel = (PopulationLabel)stemGraphLabel;
                graphPopLabel.setPopulationIdentifier(stemGraphPopLabel.getPopulationIdentifier());
                graphPopLabel.getCurrentPopulationValue().setCount(stemGraphPopLabel.getCurrentPopulationValue().getCount());
                graphPopLabel.setPopulatedArea(stemGraphPopLabel.getPopulatedArea());
                continue;
            }
            if (!(graphLabel instanceof AreaLabel)) continue;
            AreaLabel graphAreaLabel = (AreaLabel)graphLabel;
            AreaLabel stemGraphAreaLabel = (AreaLabel)stemGraphLabel;
            graphAreaLabel.getCurrentAreaValue().setArea(stemGraphAreaLabel.getCurrentAreaValue().getArea());
        }
    }

    private void addTranslationToNode(GraphNode node, double dx, double dy) {
        NodeData nodeData = (NodeData)node.getData();
        Set<Polygon> displayPolygons = this.graphPolygons.get(nodeData.getNodeURI());
        nodeData.setOrigX(nodeData.getOrigX() + dx);
        nodeData.setOrigY(nodeData.getOrigY() + dy);
        for (Polygon polygon : displayPolygons) {
            int i = 0;
            while (i < polygon.npoints) {
                int n = i;
                polygon.x[n] = polygon.x[n] + dx;
                int n2 = i++;
                polygon.y[n2] = polygon.y[n2] + dy;
            }
        }
    }

    private int[] polygon2IntArray(Polygon poly) {
        if (poly.npoints == 0) {
            return new int[2];
        }
        int[] points = new int[poly.npoints * 2];
        int i = 0;
        while (i < poly.npoints) {
            points[i * 2] = (int)(poly.x[i] * this.scaleX + this.translationX);
            points[i * 2 + 1] = (int)(poly.y[i] * this.scaleY + this.translationY);
            ++i;
        }
        return points;
    }

    private String createEdgeTitle(Node nodeA, Node nodeB, String typeName, boolean directed) {
        String nA = nodeA.getDublinCore().getTitle();
        String nB = nodeB.getDublinCore().getTitle();
        String title = null;
        title = directed ? String.valueOf(typeName) + "[(" + nA + ")->(" + nB + ")]" : String.valueOf(typeName) + "[(" + nA + ")<->(" + nB + ")]";
        return title;
    }

    private URI getRandomURI(String segment) {
        URI uri = null;
        boolean isDuplicate = true;
        while (isDuplicate) {
            uri = STEMURI.createURI((String)(String.valueOf(segment) + "/" + STEMURI.generateUniquePart()));
            boolean bl = isDuplicate = this.stemGraph.getNodes().containsKey((Object)uri) || this.stemGraph.getEdges().contains((Object)uri);
        }
        return uri;
    }

    private void preventOverlay(GraphConnection connection) {
        ConnectionData edgeData = (ConnectionData)connection.getData();
        ArrayList<GraphConnection> sameConnections = new ArrayList<GraphConnection>();
        int curveDepth = 0;
        for (GraphConnection c : this.graphConnections.values()) {
            GraphNode source1 = connection.getSource();
            GraphNode destination1 = connection.getDestination();
            GraphNode source2 = c.getSource();
            GraphNode destination2 = c.getDestination();
            if (source1 != source2 || destination1 != destination2 || c.equals(connection)) continue;
            sameConnections.add(c);
        }
        int i = 0;
        while (i < sameConnections.size()) {
            boolean exists = false;
            for (GraphConnection c : sameConnections) {
                if (((ConnectionData)c.getData()).getCurveDepth() != curveDepth) continue;
                exists = true;
                break;
            }
            if (!exists) break;
            curveDepth = 10 * (int)Math.ceil(((double)i + 1.0) / 2.0) * (int)Math.pow(-1.0, i);
            ++i;
        }
        edgeData.setCurveDepth(curveDepth);
        connection.setCurveDepth(curveDepth);
    }

    private Point2D.Double getLatLongFromCursorLocation(Point xy) {
        double lon = ((double)xy.x - this.translationX) / this.scaleX;
        double lat = ((double)xy.y - this.translationY) / this.scaleY;
        return new Point2D.Double(lon, lat);
    }

    private String formatLatLon(double lat, double lon) {
        DecimalFormat df = new DecimalFormat("0.00", DecimalFormatSymbols.getInstance(Locale.US));
        return String.valueOf(df.format(lat)) + " " + df.format(lon);
    }

    private String formatDouble(double value) {
        DecimalFormat df = new DecimalFormat("0.00", DecimalFormatSymbols.getInstance(Locale.US));
        return df.format(value);
    }

    private void checkSelectionVisible() {
        Object selectedItem = this.zestGraph.getSelection().get(0);
        int yMax = this.zestGraph.getSize().y;
        int yPos = 0;
        if (selectedItem instanceof GraphNode) {
            GraphNode node = (GraphNode)selectedItem;
            yPos = node.getLocation().y;
        } else if (selectedItem instanceof GraphConnection) {
            GraphConnection connection = (GraphConnection)selectedItem;
            GraphNode node1 = connection.getSource();
            GraphNode node2 = connection.getDestination();
            yPos = (node1.getLocation().y + node2.getLocation().y) / 2;
        }
        if (yPos + 10 > yMax) {
            this.translationY += (double)(yMax - 10 - yPos);
            this.redraw();
        }
    }

    private void setNodeColor(GraphNode gn) {
        NodeData data = (NodeData)gn.getData();
        switch (data.getGraphListIndex()) {
            case 0: {
                gn.setBackgroundColor(ColorConstants.black);
                return;
            }
            case 1: {
                gn.setBackgroundColor(ColorConstants.red);
                return;
            }
            case 2: {
                gn.setBackgroundColor(ColorConstants.green);
                return;
            }
            case 3: {
                gn.setBackgroundColor(ColorConstants.blue);
                return;
            }
            case 4: {
                gn.setBackgroundColor(ColorConstants.yellow);
                return;
            }
            case 5: {
                gn.setBackgroundColor(ColorConstants.orange);
                return;
            }
            case 6: {
                gn.setBackgroundColor(ColorConstants.cyan);
                return;
            }
        }
        gn.setBackgroundColor(ColorConstants.black);
    }

    private void setEdgeColor(GraphConnection gc) {
        ConnectionData cd = (ConnectionData)gc.getData();
        EdgeLabel label = cd.getEdgeLabel();
        if (label instanceof MigrationEdgeLabel) {
            gc.setLineStyle(1);
        } else if (label instanceof CommonBorderRelationshipLabel) {
            gc.setLineStyle(3);
        } else if (label instanceof RoadTransportRelationshipLabel) {
            gc.setLineStyle(2);
        } else if (label instanceof PipeTransportEdgeLabel) {
            gc.setLineStyle(4);
        } else if (label instanceof RelativePhysicalRelationshipLabel) {
            gc.setLineStyle(3);
        }
    }
}

