/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.ui.refactoring.participant;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditVisitor;
import org.eclipse.xtext.ui.refactoring.impl.DisplayChangeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextChangeCombiner {
    private static final Logger LOG = Logger.getLogger(TextChangeCombiner.class);

    public Change combineChanges(Change masterChange) {
        if (!(masterChange instanceof CompositeChange)) {
            return masterChange;
        }
        LinkedHashMap resource2edits = Maps.newLinkedHashMap();
        ArrayList otherChanges = Lists.newArrayList();
        this.visitCompositeChange((CompositeChange)masterChange, resource2edits, otherChanges);
        CompositeChange compositeChange = new CompositeChange(masterChange.getName());
        for (Map.Entry resource2edit : resource2edits.entrySet()) {
            Object key = resource2edit.getKey();
            TextChange combinedTextChange = this.createChange(key);
            if (combinedTextChange == null) continue;
            combinedTextChange.setEdit((TextEdit)resource2edit.getValue());
            compositeChange.add((Change)combinedTextChange);
        }
        for (Change otherChange : otherChanges) {
            compositeChange.add(otherChange);
        }
        if (compositeChange.getChildren().length == 0) {
            return null;
        }
        return compositeChange;
    }

    private void visitCompositeChange(CompositeChange sourceChange, Map<Object, MultiTextEdit> resource2edits, List<Change> otherChanges) {
        Change[] changeArray = sourceChange.getChildren();
        int n = changeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Change sourceSubChange = changeArray[n2];
            this.visitChange(sourceSubChange, resource2edits, otherChanges);
            ++n2;
        }
    }

    protected void visitChange(Change sourceChange, Map<Object, MultiTextEdit> resource2edits, List<Change> otherChanges) {
        if (sourceChange instanceof DisplayChangeWrapper) {
            this.visitChange(((DisplayChangeWrapper)sourceChange).getDelegate(), resource2edits, otherChanges);
        } else if (sourceChange instanceof CompositeChange) {
            this.visitCompositeChange((CompositeChange)sourceChange, resource2edits, otherChanges);
        } else if (sourceChange instanceof TextChange) {
            Object key = this.getKey((TextChange)sourceChange);
            if (key != null) {
                TextEdit edit;
                MultiTextEdit multiTextEdit = resource2edits.get(key);
                if (multiTextEdit == null) {
                    multiTextEdit = new MultiTextEdit();
                    resource2edits.put(key, multiTextEdit);
                }
                if ((edit = ((TextChange)sourceChange).getEdit().copy()) instanceof MultiTextEdit) {
                    TextEdit[] textEditArray = ((MultiTextEdit)edit).getChildren();
                    int n = textEditArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TextEdit textEdit = textEditArray[n2];
                        this.addIfNotDuplicate(multiTextEdit, textEdit);
                        ++n2;
                    }
                } else {
                    this.addIfNotDuplicate(multiTextEdit, edit);
                }
            }
        } else {
            CompositeChange parent = (CompositeChange)sourceChange.getParent();
            parent.remove(sourceChange);
            otherChanges.add(sourceChange);
        }
    }

    protected void addIfNotDuplicate(MultiTextEdit multiTextEdit, final TextEdit editToBeAdded) {
        final boolean[] overlaps = new boolean[1];
        TextEditVisitor textEditVisitor = new TextEditVisitor(){

            public boolean visitNode(TextEdit edit) {
                overlaps[0] = overlaps[0] | (!(edit instanceof MultiTextEdit) && edit.covers(editToBeAdded));
                return super.visitNode(edit);
            }
        };
        multiTextEdit.accept(textEditVisitor);
        if (!overlaps[0]) {
            multiTextEdit.addChild(editToBeAdded.copy());
        }
    }

    protected Object getKey(TextChange change) {
        if (change instanceof CompilationUnitChange) {
            return ((CompilationUnitChange)change).getCompilationUnit();
        }
        if (change instanceof TextFileChange) {
            return ((TextFileChange)change).getFile();
        }
        if (change instanceof DocumentChange) {
            try {
                return ((DocumentChange)change).getCurrentDocument((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                LOG.error((Object)"Error getting document for change.", (Throwable)e);
            }
        } else {
            LOG.error((Object)("Unhandled TextChange type: " + change.getClass().getName()));
        }
        return null;
    }

    protected TextChange createChange(Object key) {
        if (key instanceof ICompilationUnit) {
            return new CompilationUnitChange("Combined CompilationUnitChange", (ICompilationUnit)key);
        }
        if (key instanceof IFile) {
            return new TextFileChange("Combined TextFileChange", (IFile)key);
        }
        if (key instanceof IDocument) {
            return new DocumentChange("Combined DocumentChange", (IDocument)key);
        }
        LOG.error((Object)("Error creating change for " + key.getClass().getName()));
        return null;
    }
}

