/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.type.impl;

import java.util.Collection;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.model.attribute.AttributeFactory;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.MarkerType;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.attribute.impl.MarkerImpl;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.type.DifferenceSeries;
import org.eclipse.birt.chart.model.type.TypeFactory;
import org.eclipse.birt.chart.model.type.TypePackage;
import org.eclipse.birt.chart.model.type.impl.AreaSeriesImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DifferenceSeriesImpl
extends AreaSeriesImpl
implements DifferenceSeries {
    protected EList<Marker> negativeMarkers;
    protected LineAttributes negativeLineAttributes;

    protected DifferenceSeriesImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return TypePackage.Literals.DIFFERENCE_SERIES;
    }

    @Override
    public EList<Marker> getNegativeMarkers() {
        if (this.negativeMarkers == null) {
            this.negativeMarkers = new EObjectContainmentEList(Marker.class, (InternalEObject)this, 19);
        }
        return this.negativeMarkers;
    }

    @Override
    public LineAttributes getNegativeLineAttributes() {
        return this.negativeLineAttributes;
    }

    public NotificationChain basicSetNegativeLineAttributes(LineAttributes newNegativeLineAttributes, NotificationChain msgs) {
        LineAttributes oldNegativeLineAttributes = this.negativeLineAttributes;
        this.negativeLineAttributes = newNegativeLineAttributes;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 20, (Object)oldNegativeLineAttributes, (Object)newNegativeLineAttributes);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setNegativeLineAttributes(LineAttributes newNegativeLineAttributes) {
        if (newNegativeLineAttributes != this.negativeLineAttributes) {
            NotificationChain msgs = null;
            if (this.negativeLineAttributes != null) {
                msgs = ((InternalEObject)this.negativeLineAttributes).eInverseRemove((InternalEObject)this, -21, null, msgs);
            }
            if (newNegativeLineAttributes != null) {
                msgs = ((InternalEObject)newNegativeLineAttributes).eInverseAdd((InternalEObject)this, -21, null, msgs);
            }
            if ((msgs = this.basicSetNegativeLineAttributes(newNegativeLineAttributes, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 20, (Object)newNegativeLineAttributes, (Object)newNegativeLineAttributes));
        }
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 19: {
                return ((InternalEList)this.getNegativeMarkers()).basicRemove((Object)otherEnd, msgs);
            }
            case 20: {
                return this.basicSetNegativeLineAttributes(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 19: {
                return this.getNegativeMarkers();
            }
            case 20: {
                return this.getNegativeLineAttributes();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 19: {
                this.getNegativeMarkers().clear();
                this.getNegativeMarkers().addAll((Collection)newValue);
                return;
            }
            case 20: {
                this.setNegativeLineAttributes((LineAttributes)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 19: {
                this.getNegativeMarkers().clear();
                return;
            }
            case 20: {
                this.setNegativeLineAttributes(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 19: {
                return this.negativeMarkers != null && !this.negativeMarkers.isEmpty();
            }
            case 20: {
                return this.negativeLineAttributes != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public boolean canBeStacked() {
        return false;
    }

    @Override
    public boolean canParticipateInCombination() {
        return false;
    }

    public static final Series create() {
        DifferenceSeries ds = TypeFactory.eINSTANCE.createDifferenceSeries();
        ((DifferenceSeriesImpl)ds).initialize();
        return ds;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.setCurve(true);
        LineAttributes lia = LineAttributesImpl.create(ColorDefinitionImpl.BLACK(), LineStyle.SOLID_LITERAL, 1);
        lia.setVisible(true);
        this.setNegativeLineAttributes(lia);
        Marker m = AttributeFactory.eINSTANCE.createMarker();
        m.setType(MarkerType.BOX_LITERAL);
        m.setSize(4);
        m.setVisible(false);
        LineAttributes la = AttributeFactory.eINSTANCE.createLineAttributes();
        la.setVisible(true);
        m.setOutline(la);
        this.getNegativeMarkers().add((Object)m);
    }

    public static final Series createDefault() {
        DifferenceSeries ds = TypeFactory.eINSTANCE.createDifferenceSeries();
        ((DifferenceSeriesImpl)ds).initDefault();
        return ds;
    }

    @Override
    protected void initDefault() {
        super.initDefault();
        this.curve = true;
        LineAttributes lia = LineAttributesImpl.createDefault(null, LineStyle.SOLID_LITERAL, 1, true);
        this.setNegativeLineAttributes(lia);
        Marker m = MarkerImpl.createDefault(MarkerType.BOX_LITERAL, 4, false);
        LineAttributes la = LineAttributesImpl.createDefault(true);
        m.setOutline(la);
        this.getNegativeMarkers().add((Object)m);
    }

    @Override
    public String getDisplayName() {
        return Messages.getString("DifferenceSeriesImpl.displayName");
    }

    @Override
    public DifferenceSeries copyInstance() {
        DifferenceSeriesImpl dest = new DifferenceSeriesImpl();
        dest.set(this);
        return dest;
    }

    protected void set(DifferenceSeries src) {
        super.set(src);
        if (src.getNegativeMarkers() != null) {
            EList<Marker> list = this.getNegativeMarkers();
            for (Marker element : src.getNegativeMarkers()) {
                list.add((Object)element.copyInstance());
            }
        }
        if (src.getNegativeLineAttributes() != null) {
            this.setNegativeLineAttributes(src.getNegativeLineAttributes().copyInstance());
        }
    }

    @Override
    public int[] getDefinedDataDefinitionIndex() {
        int[] nArray = new int[2];
        nArray[1] = 1;
        return nArray;
    }
}

