/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.loggers.htmlgeneration;

import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.stem.util.loggers.htmlgeneration.Body;
import org.eclipse.stem.util.loggers.htmlgeneration.Head;
import org.eclipse.stem.util.loggers.htmlgeneration.Html;
import org.eclipse.stem.util.loggers.htmlgeneration.HtmlElement;
import org.eclipse.stem.util.loggers.htmlgeneration.LI;
import org.eclipse.stem.util.loggers.htmlgeneration.Span;
import org.eclipse.stem.util.loggers.htmlgeneration.TD;
import org.eclipse.stem.util.loggers.htmlgeneration.TR;
import org.eclipse.stem.util.loggers.htmlgeneration.Table;
import org.eclipse.stem.util.loggers.htmlgeneration.Tbody;
import org.eclipse.stem.util.loggers.htmlgeneration.Title;
import org.eclipse.stem.util.loggers.htmlgeneration.UL;

public class HTMLdocument {
    public final String HEADER = "<!DOCTYPE html>\n";
    public final String HTML_START = "<html>";
    public final String HTML_STOP = "</html>";
    protected List<HtmlElement> contents = new ArrayList<HtmlElement>();
    private Html html = new Html();

    public HTMLdocument() {
        this.contents.add(this.html);
    }

    public void add(HtmlElement element) {
        this.html.add(element);
    }

    public String getContents() {
        StringBuffer buf = new StringBuffer("<!DOCTYPE html>\n");
        int i = 0;
        while (i < this.contents.size()) {
            HtmlElement element = this.contents.get(i);
            buf.append(element.open());
            String data = element.getData();
            if (data != null) {
                buf.append(data);
            }
            buf.append(element.getContents(""));
            buf.append(element.close());
            ++i;
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        HTMLdocument doc = new HTMLdocument();
        Head head = new Head();
        doc.add(head);
        Title title = new Title("Simulation Summary");
        head.add(title);
        Body body = new Body();
        doc.add(body);
        Span span = new Span("style", "font-weight: bold;");
        body.add(span);
        Table table = new Table("style", "text-align: left; width: 100%;");
        table.addAttribute("border", "1");
        table.addAttribute("cellpadding", "2");
        table.addAttribute("cellspacing", "2");
        doc.add(table);
        Tbody tbody = new Tbody();
        table.add(tbody);
        TR tr = new TR("align", "center");
        tbody.add(tr);
        TD td = new TD("style", "background-color: rgb(102, 255, 255);");
        tr.add(td);
        Span span2 = new Span("style", "font-weight: bold;");
        span2.setData("STEM Simulation Summary");
        td.add(span2);
        TR tr2 = new TR();
        tbody.add(tr2);
        TD td2 = new TD();
        tr2.add(td2);
        UL ul = new UL();
        td2.add(ul);
        LI li1 = new LI("modelA");
        LI li2 = new LI("modelB");
        ul.add(li1);
        UL ul2 = new UL();
        ul.add(ul2);
        ul2.add(li2);
        UL ul3 = new UL();
        ul2.add(ul3);
        LI li2a = new LI("decorator1");
        LI li2b = new LI("decorator2");
        ul3.add(li2a);
        ul3.add(li2b);
        LI li3 = new LI("sequencer");
        LI li4 = new LI("solver");
        ul.add(li3);
        ul.add(li4);
        doc.writeDocument("/Users/jhkauf/Desktop/test.html", doc.getContents());
    }

    public void writeDocument(String fileName, String doc) {
        try {
            FileWriter fw = new FileWriter(fileName);
            fw.write(doc);
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            System.out.println("Error writing file to " + fileName);
            e.printStackTrace();
        }
    }
}

