/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.fr;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;

public class ElisionFilter
extends TokenFilter {
    private Set articles = null;
    private TermAttribute termAtt;
    private static char[] apostrophes = new char[]{'\'', '\u2019'};

    public void setArticles(Set articles) {
        this.articles = new HashSet();
        Iterator iter = articles.iterator();
        while (iter.hasNext()) {
            this.articles.add(((String)iter.next()).toLowerCase());
        }
    }

    protected ElisionFilter(TokenStream input) {
        super(input);
        this.articles = new HashSet<String>(Arrays.asList("l", "m", "t", "qu", "n", "s", "j"));
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
    }

    public ElisionFilter(TokenStream input, Set articles) {
        super(input);
        this.setArticles(articles);
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
    }

    public ElisionFilter(TokenStream input, String[] articles) {
        super(input);
        this.setArticles(new HashSet<String>(Arrays.asList(articles)));
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
    }

    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            char[] termBuffer = this.termAtt.termBuffer();
            int termLength = this.termAtt.termLength();
            int minPoz = Integer.MAX_VALUE;
            block0: for (int i = 0; i < apostrophes.length; ++i) {
                char apos = apostrophes[i];
                for (int poz = 0; poz < termLength; ++poz) {
                    if (termBuffer[poz] != apos) continue;
                    minPoz = Math.min(poz, minPoz);
                    continue block0;
                }
            }
            if (minPoz != Integer.MAX_VALUE && this.articles.contains(new String(this.termAtt.termBuffer(), 0, minPoz).toLowerCase())) {
                this.termAtt.setTermBuffer(this.termAtt.termBuffer(), minPoz + 1, this.termAtt.termLength() - (minPoz + 1));
            }
            return true;
        }
        return false;
    }

    public final Token next(Token reusableToken) throws IOException {
        return super.next(reusableToken);
    }

    public final Token next() throws IOException {
        return super.next();
    }
}

