/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.validation;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtext.resource.ClasspathUriResolutionException;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class ClasspathBasedChecks
extends AbstractDeclarativeValidator {
    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkFileNamingConventions(XtendFile xtendFile) {
        Resource resource = xtendFile.eResource();
        if (resource == null || resource.getResourceSet() == null) {
            return;
        }
        URI resourceURI = resource.getURI();
        String packageName = xtendFile.getPackage();
        StringBuilder classpathURIBuilder = new StringBuilder("classpath");
        classpathURIBuilder.append(":/");
        if (packageName != null) {
            classpathURIBuilder.append(packageName.replace(".", "/")).append("/");
        }
        classpathURIBuilder.append(resourceURI.lastSegment());
        URI classpathURI = URI.createURI((String)classpathURIBuilder.toString());
        URIConverter uriConverter = resource.getResourceSet().getURIConverter();
        try {
            URI normalizedURI = uriConverter.normalize(classpathURI);
            if (!resourceURI.equals((Object)normalizedURI)) {
                this.reportInvalidPackage(packageName, classpathURI);
            }
        }
        catch (ClasspathUriResolutionException e) {
            this.reportInvalidPackage(packageName, classpathURI);
        }
    }

    protected void reportInvalidPackage(String packageName, URI classpathURI) {
        this.error("The declared package '" + Strings.notNull((Object)packageName) + "' does not match the expected package", (EStructuralFeature)XtendPackage.Literals.XTEND_FILE__PACKAGE, -1, "org.eclipse.xtend.core.validation.IssueCodes.wrong_package", new String[0]);
    }
}

