/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.gis;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.stem.gis.Activator;
import org.eclipse.stem.gis.GisUtils;
import org.eclipse.stem.gis.coord.CoordinateSystem;
import org.eclipse.stem.gis.coord.CoordinateSystemLoader;
import org.eclipse.stem.gis.dbf.DbfHeader;
import org.eclipse.stem.gis.dbf.DbfInputStream;
import org.eclipse.stem.gis.shp.ShpHeader;
import org.eclipse.stem.gis.shp.ShpInputStream;
import org.eclipse.stem.gis.shp.ShpRecord;

public class ShapefileReader {
    protected ShpInputStream shpIn;
    protected DbfInputStream dbfIn;
    protected ShpRecord bufRecord;
    protected CoordinateSystem coordinateSystem;

    public ShapefileReader(File file) throws IOException {
        this.load(file);
    }

    public ShapefileReader(ShpInputStream shpis, DbfInputStream dbis, CoordinateSystem cs) throws IOException {
        this.shpIn = shpis;
        this.dbfIn = dbis;
        this.coordinateSystem = cs;
    }

    private void load(File shpFile) throws IOException {
        try {
            this.coordinateSystem = CoordinateSystemLoader.loadFromPrj(GisUtils.getProjectionFileForShp(shpFile));
        }
        catch (Exception e) {
            Activator.logWarning("Unable to load projection definition for the shapefile " + shpFile, e);
        }
        this.shpIn = new ShpInputStream(new BufferedInputStream(new FileInputStream(shpFile)), this.coordinateSystem);
        this.dbfIn = new DbfInputStream(new BufferedInputStream(new FileInputStream(GisUtils.getDbfFileForShp(shpFile))));
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }

    public ShpHeader getShapefileHeader() {
        return this.shpIn.getHeader();
    }

    public DbfHeader getTableHeader() {
        return this.dbfIn.getHeader();
    }

    public synchronized boolean hasMoreRecords() throws IOException {
        if (this.bufRecord == null) {
            this.bufRecord = this.getNextRecord();
        }
        return this.bufRecord != null;
    }

    public synchronized ShpRecord getNextRecord() throws IOException {
        ShpRecord record = null;
        if (this.bufRecord == null) {
            record = this.shpIn.readNextRecord();
            if (record != null) {
                record.setTableAttributes(this.dbfIn.readNextRecord());
            }
        } else {
            record = this.bufRecord;
            this.bufRecord = null;
        }
        return record;
    }

    public void close() {
        GisUtils.safeClose((InputStream)((Object)this.shpIn));
        GisUtils.safeClose((InputStream)((Object)this.dbfIn));
    }
}

