/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.feature;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.NewWizard;
import org.eclipse.pde.internal.ui.wizards.feature.AbstractFeatureSpecPage;
import org.eclipse.pde.internal.ui.wizards.feature.FeatureData;
import org.eclipse.pde.internal.ui.wizards.feature.PluginListPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public abstract class AbstractNewFeatureWizard
extends NewWizard
implements IExecutableExtension {
    public static final String DEF_PROJECT_NAME = "project-name";
    public static final String DEF_FEATURE_ID = "feature-id";
    public static final String DEF_FEATURE_NAME = "feature-name";
    protected AbstractFeatureSpecPage fSpecPage;
    protected PluginListPage fSecondPage;
    protected FeaturePatchProvider fProvider;
    private IConfigurationElement fConfig;

    public AbstractNewFeatureWizard() {
        this.setDialogSettings(PDEPlugin.getDefault().getDialogSettings());
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.fSpecPage = this.createFirstPage();
        String pname = this.getDefaultValue(DEF_PROJECT_NAME);
        if (pname != null) {
            this.fSpecPage.setInitialProjectName(pname);
        }
        this.fSpecPage.setInitialId(this.getDefaultValue(DEF_FEATURE_ID));
        this.fSpecPage.setInitialName(this.getDefaultValue(DEF_FEATURE_NAME));
        this.addPage((IWizardPage)this.fSpecPage);
        this.fProvider = new FeaturePatchProvider();
    }

    protected abstract AbstractFeatureSpecPage createFirstPage();

    public boolean canFinish() {
        IWizardPage page = this.getContainer().getCurrentPage();
        return page == this.fSpecPage && page.isPageComplete() || page == this.fSecondPage && page.isPageComplete();
    }

    protected abstract IRunnableWithProgress getOperation();

    public boolean performFinish() {
        try {
            IDialogSettings settings = this.getDialogSettings();
            this.fSpecPage.saveSettings(settings);
            if (settings != null && this.fSecondPage != null) {
                this.fSecondPage.saveSettings(settings);
            }
            this.getContainer().run(false, true, this.getOperation());
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfig);
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public void setInitializationData(IConfigurationElement config, String property, Object data) throws CoreException {
        this.fConfig = config;
    }

    public class FeaturePatchProvider
    implements IProjectProvider {
        public String getProjectName() {
            return AbstractNewFeatureWizard.this.fSpecPage.getProjectName();
        }

        public IProject getProject() {
            return AbstractNewFeatureWizard.this.fSpecPage.getProjectHandle();
        }

        public IPath getLocationPath() {
            return AbstractNewFeatureWizard.this.fSpecPage.getLocationPath();
        }

        public IFeatureModel getFeatureToPatch() {
            return AbstractNewFeatureWizard.this.fSpecPage.getFeatureToPatch();
        }

        public FeatureData getFeatureData() {
            return AbstractNewFeatureWizard.this.fSpecPage.getFeatureData();
        }

        public String getInstallHandlerLibrary() {
            return AbstractNewFeatureWizard.this.fSpecPage.getInstallHandlerLibrary();
        }

        public IPluginBase[] getPluginListSelection() {
            return AbstractNewFeatureWizard.this.fSecondPage != null ? AbstractNewFeatureWizard.this.fSecondPage.getSelectedPlugins() : null;
        }

        public ILaunchConfiguration getLaunchConfiguration() {
            return AbstractNewFeatureWizard.this.fSecondPage != null ? AbstractNewFeatureWizard.this.fSecondPage.getSelectedLaunchConfiguration() : null;
        }
    }
}

