/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.trace.internal;

import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.runnable.StartupMonitor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.trace.internal.TracingStartupMonitor;
import org.eclipse.ui.trace.internal.utils.DebugOptionsHandler;
import org.eclipse.ui.trace.internal.utils.PreferenceHandler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class TracingUIActivator
extends AbstractUIPlugin {
    private static TracingUIActivator plugin = null;

    public static TracingUIActivator getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        if (DebugOptionsHandler.isTracingEnabled()) {
            DebugOptionsHandler.setLaunchInDebugMode(true);
        } else if (!Platform.getInstanceLocation().isSet()) {
            TracingStartupMonitor startupMonitor = new TracingStartupMonitor();
            Hashtable properties = new Hashtable(1);
            ServiceRegistration registration = context.registerService(StartupMonitor.class, (Object)startupMonitor, properties);
            startupMonitor.setRegistration((ServiceRegistration<StartupMonitor>)registration);
        } else {
            this.initPreferences();
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public final void logException(Exception ex) {
        if (ex != null) {
            Status errorStatus = new Status(4, "org.eclipse.ui.trace", ex.getMessage(), (Throwable)ex);
            this.getLog().log((IStatus)errorStatus);
        }
    }

    protected final void initPreferences() {
        if (PreferenceHandler.isTracingEnabled()) {
            DebugOptionsHandler.setDebugEnabled(true);
            DebugOptionsHandler.getDebugOptions().setFile(new File(PreferenceHandler.getFilePath()));
            System.setProperty("eclipse.trace.size.max", String.valueOf(PreferenceHandler.getMaxFileSize()));
            System.setProperty("eclipse.trace.backup.max", String.valueOf(PreferenceHandler.getMaxFileCount()));
            Map<String, String> prefs = PreferenceHandler.getPreferenceProperties();
            DebugOptionsHandler.getDebugOptions().setOptions(prefs);
        }
    }
}

